/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.formula;

import java.util.Objects;
import java.util.Optional;
import org.sonar.ce.task.projectanalysis.formula.Counter;
import org.sonar.ce.task.projectanalysis.formula.CounterInitializationContext;
import org.sonar.ce.task.projectanalysis.formula.CreateMeasureContext;
import org.sonar.ce.task.projectanalysis.formula.Formula;
import org.sonar.ce.task.projectanalysis.measure.Measure;

public class AverageFormula
implements Formula<AverageCounter> {
    private final String outputMetricKey;
    private final String mainMetric;
    private final String byMetric;

    private AverageFormula(Builder builder) {
        this.outputMetricKey = builder.outputMetricKey;
        this.mainMetric = builder.mainMetric;
        this.byMetric = builder.byMetric;
    }

    @Override
    public AverageCounter createNewCounter() {
        return new AverageCounter();
    }

    @Override
    public Optional<Measure> createMeasure(AverageCounter counter, CreateMeasureContext context) {
        Optional<Double> mainValueOptional = counter.getMainValue();
        Optional<Double> byValueOptional = counter.getByValue();
        if (mainValueOptional.isPresent() && byValueOptional.isPresent()) {
            double mainValue = mainValueOptional.get();
            double byValue = byValueOptional.get();
            if (byValue > 0.0) {
                return Optional.of(Measure.newMeasureBuilder().create(mainValue / byValue, context.getMetric().getDecimalScale()));
            }
        }
        return Optional.empty();
    }

    @Override
    public String[] getOutputMetricKeys() {
        return new String[]{this.outputMetricKey};
    }

    class AverageCounter
    implements Counter<AverageCounter> {
        private boolean initialized = false;
        private double mainValue = 0.0;
        private double byValue = 0.0;

        AverageCounter() {
        }

        @Override
        public void aggregate(AverageCounter counter) {
            this.addValuesIfPresent(counter.getMainValue(), counter.getByValue());
        }

        @Override
        public void initialize(CounterInitializationContext context) {
            Optional<Double> mainValueOptional = this.getDoubleValue(context.getMeasure(AverageFormula.this.mainMetric));
            Optional<Double> byValueOptional = this.getDoubleValue(context.getMeasure(AverageFormula.this.byMetric));
            this.addValuesIfPresent(mainValueOptional, byValueOptional);
        }

        private void addValuesIfPresent(Optional<Double> counterMainValue, Optional<Double> counterByValue) {
            if (counterMainValue.isPresent() && counterByValue.isPresent()) {
                this.initialized = true;
                this.mainValue += counterMainValue.get().doubleValue();
                this.byValue += counterByValue.get().doubleValue();
            }
        }

        public Optional<Double> getMainValue() {
            return this.getValue(this.mainValue);
        }

        public Optional<Double> getByValue() {
            return this.getValue(this.byValue);
        }

        private Optional<Double> getValue(double value) {
            if (this.initialized) {
                return Optional.of(value);
            }
            return Optional.empty();
        }

        private Optional<Double> getDoubleValue(Optional<Measure> measureOptional) {
            if (!measureOptional.isPresent()) {
                return Optional.empty();
            }
            Measure measure = measureOptional.get();
            switch (measure.getValueType()) {
                case DOUBLE: {
                    return Optional.of(measure.getDoubleValue());
                }
                case LONG: {
                    return Optional.of(Double.valueOf(measure.getLongValue()));
                }
                case INT: {
                    return Optional.of(Double.valueOf(measure.getIntValue()));
                }
                case NO_VALUE: {
                    return Optional.empty();
                }
            }
            throw new IllegalArgumentException(String.format("Measure of type '%s' are not supported", measure.getValueType().name()));
        }
    }

    public static class Builder {
        private String outputMetricKey;
        private String mainMetric;
        private String byMetric;

        private Builder() {
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public Builder setOutputMetricKey(String m) {
            this.outputMetricKey = m;
            return this;
        }

        public Builder setMainMetricKey(String m) {
            this.mainMetric = m;
            return this;
        }

        public Builder setByMetricKey(String m) {
            this.byMetric = m;
            return this;
        }

        public AverageFormula build() {
            Objects.requireNonNull(this.outputMetricKey, "Output metric key cannot be null");
            Objects.requireNonNull(this.mainMetric, "Main metric Key cannot be null");
            Objects.requireNonNull(this.byMetric, "By metric Key cannot be null");
            return new AverageFormula(this);
        }
    }
}

