/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.issue;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.api.utils.DateUtils;
import org.sonar.ce.task.projectanalysis.component.Component;
import org.sonar.ce.task.projectanalysis.component.SiblingComponentsWithOpenIssues;
import org.sonar.ce.task.projectanalysis.issue.ComponentIssuesLoader;
import org.sonar.ce.task.projectanalysis.issue.SiblingIssue;
import org.sonar.core.issue.DefaultIssue;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.issue.IssueDto;
import org.sonar.db.issue.ShortBranchIssueDto;

public class SiblingsIssuesLoader {
    private final SiblingComponentsWithOpenIssues siblingComponentsWithOpenIssues;
    private final DbClient dbClient;
    private final ComponentIssuesLoader componentIssuesLoader;

    public SiblingsIssuesLoader(SiblingComponentsWithOpenIssues siblingComponentsWithOpenIssues, DbClient dbClient, ComponentIssuesLoader componentIssuesLoader) {
        this.siblingComponentsWithOpenIssues = siblingComponentsWithOpenIssues;
        this.dbClient = dbClient;
        this.componentIssuesLoader = componentIssuesLoader;
    }

    public Collection<SiblingIssue> loadCandidateSiblingIssuesForMerging(Component component) {
        String componentKey = ComponentDto.removeBranchAndPullRequestFromKey((String)component.getDbKey());
        Set<String> uuids = this.siblingComponentsWithOpenIssues.getUuids(componentKey);
        if (uuids.isEmpty()) {
            return Collections.emptyList();
        }
        try (DbSession session = this.dbClient.openSession(false);){
            Collection collection = this.dbClient.issueDao().selectOpenByComponentUuids(session, uuids).stream().map(SiblingsIssuesLoader::toSiblingIssue).collect(Collectors.toList());
            return collection;
        }
    }

    private static SiblingIssue toSiblingIssue(ShortBranchIssueDto dto) {
        return new SiblingIssue(dto.getKey(), dto.getLine(), dto.getMessage(), dto.getChecksum(), dto.getRuleKey(), dto.getStatus(), dto.getBranchKey(), dto.getKeyType(), DateUtils.longToDate((Long)dto.getIssueUpdateDate()));
    }

    public Map<SiblingIssue, DefaultIssue> loadDefaultIssuesWithChanges(Collection<SiblingIssue> lightIssues) {
        if (lightIssues.isEmpty()) {
            return Collections.emptyMap();
        }
        Map<String, SiblingIssue> issuesByKey = lightIssues.stream().collect(Collectors.toMap(SiblingIssue::getKey, i -> i));
        try (DbSession session = this.dbClient.openSession(false);){
            List issues = (List)this.dbClient.issueDao().selectByKeys(session, issuesByKey.keySet()).stream().map(IssueDto::toDefaultIssue).collect(MoreCollectors.toList((int)issuesByKey.size()));
            this.componentIssuesLoader.loadChanges(session, issues);
            Map map = (Map)issues.stream().collect(MoreCollectors.uniqueIndex(i -> (SiblingIssue)issuesByKey.get(i.key()), i -> i, (int)issues.size()));
            return map;
        }
    }
}

