/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.issue.filter;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.sonar.api.ce.ComputeEngineSide;
import org.sonar.api.config.Configuration;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.ce.task.projectanalysis.component.Component;
import org.sonar.ce.task.projectanalysis.component.ConfigurationRepository;
import org.sonar.ce.task.projectanalysis.issue.filter.IssuePattern;
import org.sonar.core.issue.DefaultIssue;

@ComputeEngineSide
public class IssueFilter {
    private static final Logger LOG = Loggers.get(IssueFilter.class);
    private final List<IssuePattern> exclusionPatterns;
    private final List<IssuePattern> inclusionPatterns;

    public IssueFilter(ConfigurationRepository configRepository) {
        Configuration config = configRepository.getConfiguration();
        this.exclusionPatterns = IssueFilter.loadPatterns("sonar.issue.ignore.multicriteria", config);
        this.inclusionPatterns = IssueFilter.loadPatterns("sonar.issue.enforce.multicriteria", config);
    }

    public boolean accept(DefaultIssue issue, Component component) {
        if (component.getType() != Component.Type.FILE || this.exclusionPatterns.isEmpty() && this.inclusionPatterns.isEmpty()) {
            return true;
        }
        if (this.isExclude(issue, component)) {
            return false;
        }
        return this.isInclude(issue, component);
    }

    private boolean isExclude(DefaultIssue issue, Component file) {
        IssuePattern matchingPattern = null;
        Iterator<IssuePattern> patternIterator = this.exclusionPatterns.iterator();
        while (matchingPattern == null && patternIterator.hasNext()) {
            IssuePattern nextPattern = patternIterator.next();
            if (!nextPattern.match(issue, file)) continue;
            matchingPattern = nextPattern;
        }
        if (matchingPattern != null) {
            LOG.debug("Issue {} ignored by exclusion pattern {}", (Object)issue, matchingPattern);
            return true;
        }
        return false;
    }

    private boolean isInclude(DefaultIssue issue, Component file) {
        boolean atLeastOneRuleMatched = false;
        boolean atLeastOnePatternFullyMatched = false;
        IssuePattern matchingPattern = null;
        for (IssuePattern pattern : this.inclusionPatterns) {
            if (!pattern.getRulePattern().match(issue.ruleKey().toString())) continue;
            atLeastOneRuleMatched = true;
            String filePath = file.getName();
            if (filePath == null || !pattern.getComponentPattern().match(filePath)) continue;
            atLeastOnePatternFullyMatched = true;
            matchingPattern = pattern;
        }
        if (atLeastOneRuleMatched) {
            if (atLeastOnePatternFullyMatched) {
                LOG.debug("Issue {} enforced by pattern {}", (Object)issue, matchingPattern);
            }
            return atLeastOnePatternFullyMatched;
        }
        return true;
    }

    private static List<IssuePattern> loadPatterns(String propertyKey, Configuration settings) {
        ArrayList<IssuePattern> patterns = new ArrayList<IssuePattern>();
        String patternConf = settings.get(propertyKey).orElse("");
        for (String id : Splitter.on((String)",").omitEmptyStrings().split((CharSequence)patternConf)) {
            String propPrefix = propertyKey + "." + id + ".";
            String componentPathPattern = settings.get(propPrefix + "resourceKey").orElse(null);
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)componentPathPattern) ? 1 : 0) != 0, (Object)String.format("File path pattern cannot be empty. Please check '%s' settings", propertyKey));
            String ruleKeyPattern = settings.get(propPrefix + "ruleKey").orElse(null);
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)ruleKeyPattern) ? 1 : 0) != 0, (Object)String.format("Rule key pattern cannot be empty. Please check '%s' settings", propertyKey));
            patterns.add(new IssuePattern(componentPathPattern, ruleKeyPattern));
        }
        return patterns;
    }
}

