/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.source;

import java.util.List;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.sonar.ce.task.projectanalysis.component.Component;
import org.sonar.ce.task.projectanalysis.source.DbLineHashVersion;
import org.sonar.ce.task.projectanalysis.source.SignificantCodeRepository;
import org.sonar.ce.task.projectanalysis.source.SourceLinesHashCache;
import org.sonar.ce.task.projectanalysis.source.SourceLinesHashRepository;
import org.sonar.ce.task.projectanalysis.source.SourceLinesRepository;
import org.sonar.core.hash.LineRange;
import org.sonar.core.hash.SourceLineHashesComputer;
import org.sonar.core.util.CloseableIterator;
import org.sonar.db.source.LineHashVersion;

public class SourceLinesHashRepositoryImpl
implements SourceLinesHashRepository {
    private final SourceLinesRepository sourceLinesRepository;
    private final SignificantCodeRepository significantCodeRepository;
    private final SourceLinesHashCache cache;
    private final DbLineHashVersion dbLineHashesVersion;

    public SourceLinesHashRepositoryImpl(SourceLinesRepository sourceLinesRepository, SignificantCodeRepository significantCodeRepository, SourceLinesHashCache cache, DbLineHashVersion dbLineHashVersion) {
        this.sourceLinesRepository = sourceLinesRepository;
        this.significantCodeRepository = significantCodeRepository;
        this.cache = cache;
        this.dbLineHashesVersion = dbLineHashVersion;
    }

    @Override
    public List<String> getLineHashesMatchingDBVersion(Component component) {
        return this.cache.computeIfAbsent(component, this::createLineHashesMatchingDBVersion);
    }

    @Override
    public int getLineHashesVersion(Component component) {
        if (this.significantCodeRepository.getRangesPerLine(component).isPresent()) {
            return LineHashVersion.WITH_SIGNIFICANT_CODE.getDbValue();
        }
        return LineHashVersion.WITHOUT_SIGNIFICANT_CODE.getDbValue();
    }

    @Override
    public LineHashesComputer getLineHashesComputerToPersist(Component component) {
        boolean cacheHit = this.cache.contains(component);
        if (cacheHit && !this.dbLineHashesVersion.hasLineHashesWithoutSignificantCode(component)) {
            return new CachedLineHashesComputer(this.cache.get(component));
        }
        Optional<LineRange[]> significantCodePerLine = this.significantCodeRepository.getRangesPerLine(component);
        if (cacheHit && !significantCodePerLine.isPresent()) {
            return new CachedLineHashesComputer(this.cache.get(component));
        }
        return SourceLinesHashRepositoryImpl.createLineHashesProcessor(component.getFileAttributes().getLines(), significantCodePerLine);
    }

    private List<String> createLineHashesMatchingDBVersion(Component component) {
        if (this.dbLineHashesVersion.hasLineHashesWithoutSignificantCode(component)) {
            return this.createLineHashes(component, Optional.empty());
        }
        Optional<LineRange[]> significantCodePerLine = this.significantCodeRepository.getRangesPerLine(component);
        return this.createLineHashes(component, significantCodePerLine);
    }

    private List<String> createLineHashes(Component component, Optional<LineRange[]> significantCodePerLine) {
        LineHashesComputer processor = SourceLinesHashRepositoryImpl.createLineHashesProcessor(component.getFileAttributes().getLines(), significantCodePerLine);
        try (CloseableIterator<String> lines = this.sourceLinesRepository.readLines(component);){
            while (lines.hasNext()) {
                processor.addLine((String)lines.next());
            }
            List<String> list = processor.getResult();
            return list;
        }
    }

    private static LineHashesComputer createLineHashesProcessor(int numLines, Optional<LineRange[]> significantCodePerLine) {
        if (significantCodePerLine.isPresent()) {
            return new SignificantCodeLineHashesComputer(new SourceLineHashesComputer(numLines), significantCodePerLine.get());
        }
        return new SimpleLineHashesComputer(numLines);
    }

    static class SignificantCodeLineHashesComputer
    implements LineHashesComputer {
        private final SourceLineHashesComputer delegate;
        private final LineRange[] rangesPerLine;
        private int i = 0;

        public SignificantCodeLineHashesComputer(SourceLineHashesComputer hashComputer, LineRange[] rangesPerLine) {
            this.rangesPerLine = rangesPerLine;
            this.delegate = hashComputer;
        }

        @Override
        public void addLine(String line) {
            LineRange range = null;
            if (this.i < this.rangesPerLine.length) {
                range = this.rangesPerLine[this.i];
            }
            if (range == null) {
                this.delegate.addLine("");
            } else {
                this.delegate.addLine(StringUtils.substring((String)line, (int)range.startOffset(), (int)range.endOffset()));
            }
            ++this.i;
        }

        @Override
        public List<String> getResult() {
            return this.delegate.getLineHashes();
        }
    }

    static class SimpleLineHashesComputer
    implements LineHashesComputer {
        private final SourceLineHashesComputer delegate;

        public SimpleLineHashesComputer(int numLines) {
            this.delegate = new SourceLineHashesComputer(numLines);
        }

        @Override
        public void addLine(String line) {
            this.delegate.addLine(line);
        }

        @Override
        public List<String> getResult() {
            return this.delegate.getLineHashes();
        }
    }

    static class CachedLineHashesComputer
    implements LineHashesComputer {
        private final List<String> lineHashes;

        public CachedLineHashesComputer(List<String> lineHashes) {
            this.lineHashes = lineHashes;
        }

        @Override
        public void addLine(String line) {
        }

        @Override
        public List<String> getResult() {
            return this.lineHashes;
        }
    }

    public static interface LineHashesComputer {
        public void addLine(String var1);

        public List<String> getResult();
    }
}

