/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.dotnet.shared.plugins;

import javax.annotation.CheckForNull;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextRange;
import org.sonarsource.dotnet.protobuf.SonarAnalyzer;

public final class SensorContextUtils {
    private SensorContextUtils() {
    }

    @CheckForNull
    public static InputFile toInputFile(FileSystem fs, String file) {
        return fs.inputFile(fs.predicates().hasPath(file));
    }

    public static TextRange toTextRange(InputFile inputFile, SonarAnalyzer.TextRange pbTextRange) {
        int startLine = pbTextRange.getStartLine();
        int startLineOffset = pbTextRange.getStartOffset();
        int endLine = pbTextRange.getEndLine();
        int endLineOffset = pbTextRange.getEndOffset();
        return inputFile.newRange(startLine, startLineOffset, endLine, endLineOffset);
    }
}

