/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.es;

import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.sonar.server.es.Facets;

public class SearchIdResult<ID> {
    private final List<ID> ids;
    private final Facets facets;
    private final long total;

    public SearchIdResult(SearchResponse response, Function<String, ID> converter, TimeZone timeZone) {
        this.facets = new Facets(response, timeZone);
        this.total = response.getHits().getTotalHits();
        this.ids = SearchIdResult.convertToIds(response.getHits(), converter);
    }

    public List<ID> getIds() {
        return this.ids;
    }

    public long getTotal() {
        return this.total;
    }

    public Facets getFacets() {
        return this.facets;
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this);
    }

    private static <ID> List<ID> convertToIds(SearchHits hits, Function<String, ID> converter) {
        ArrayList<Object> docs = new ArrayList<Object>();
        for (SearchHit hit : hits.getHits()) {
            docs.add(converter.apply((Object)hit.getId()));
        }
        return docs;
    }
}

