/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.es.newindex;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.elasticsearch.common.settings.Settings;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.server.es.IndexType;
import org.sonar.server.es.newindex.NewIndex;

public final class BuiltIndex<T extends NewIndex<T>> {
    private final IndexType.IndexMainType mainType;
    private final Set<IndexType.IndexRelationType> relationTypes;
    private final Settings settings;
    private final Map<String, Object> attributes;

    BuiltIndex(T newIndex) {
        this.mainType = ((NewIndex)newIndex).getMainType();
        this.settings = ((NewIndex)newIndex).getSettings().build();
        this.relationTypes = (Set)((NewIndex)newIndex).getRelationsStream().collect(MoreCollectors.toSet());
        this.attributes = BuiltIndex.buildAttributes(newIndex);
    }

    private static Map<String, Object> buildAttributes(NewIndex<?> newIndex) {
        TreeMap<String, Object> indexAttributes = new TreeMap<String, Object>(newIndex.getAttributes());
        BuiltIndex.setRouting(indexAttributes, newIndex);
        indexAttributes.put("properties", BuiltIndex.buildProperties(newIndex));
        return ImmutableSortedMap.copyOf(indexAttributes);
    }

    private static void setRouting(Map<String, Object> indexAttributes, NewIndex newIndex) {
        if (!newIndex.getRelations().isEmpty()) {
            indexAttributes.put("_routing", ImmutableMap.of((Object)"required", (Object)true));
        }
    }

    private static TreeMap<String, Object> buildProperties(NewIndex<?> newIndex) {
        TreeMap<String, Object> indexProperties = new TreeMap<String, Object>(newIndex.getProperties());
        BuiltIndex.setTypeField(indexProperties, newIndex);
        BuiltIndex.setJoinField(indexProperties, newIndex);
        return indexProperties;
    }

    private static void setTypeField(TreeMap<String, Object> indexProperties, NewIndex newIndex) {
        Collection<IndexType.IndexRelationType> relations = newIndex.getRelations();
        if (!relations.isEmpty()) {
            indexProperties.put("indexType", ImmutableMap.of((Object)"type", (Object)"keyword", (Object)"norms", (Object)false, (Object)"store", (Object)false, (Object)"doc_values", (Object)false));
        }
    }

    private static void setJoinField(TreeMap<String, Object> indexProperties, NewIndex newIndex) {
        Collection<IndexType.IndexRelationType> relations = newIndex.getRelations();
        IndexType.IndexMainType mainType = newIndex.getMainType();
        if (!relations.isEmpty()) {
            indexProperties.put(mainType.getIndex().getJoinField(), ImmutableMap.of((Object)"type", (Object)"join", (Object)"relations", (Object)ImmutableMap.of((Object)mainType.getType(), (Object)BuiltIndex.namesToStringOrStringArray(relations))));
        }
    }

    private static Serializable namesToStringOrStringArray(Collection<IndexType.IndexRelationType> relations) {
        if (relations.size() == 1) {
            return relations.iterator().next().getName();
        }
        return relations.stream().map(IndexType.IndexRelationType::getName).sorted().toArray(String[]::new);
    }

    public IndexType.IndexMainType getMainType() {
        return this.mainType;
    }

    public Set<IndexType.IndexRelationType> getRelationTypes() {
        return this.relationTypes;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }
}

