/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.es.newindex;

import com.google.common.base.Preconditions;
import org.sonar.server.es.Index;
import org.sonar.server.es.IndexType;
import org.sonar.server.es.newindex.BuiltIndex;
import org.sonar.server.es.newindex.NewIndex;
import org.sonar.server.es.newindex.SettingsConfiguration;
import org.sonar.server.es.newindex.TypeMapping;

public class NewRegularIndex
extends NewIndex<NewRegularIndex> {
    private IndexType.IndexMainType mainType;

    public NewRegularIndex(Index index, SettingsConfiguration settingsConfiguration) {
        super(index, settingsConfiguration);
    }

    @Override
    public IndexType.IndexMainType getMainType() {
        Preconditions.checkState((this.mainType != null ? 1 : 0) != 0, (Object)"Main type has not been defined");
        return this.mainType;
    }

    @Override
    public TypeMapping createTypeMapping(IndexType.IndexMainType mainType) {
        Preconditions.checkState((this.mainType == null ? 1 : 0) != 0, (Object)"Main type can only be defined once");
        this.mainType = mainType;
        return super.createTypeMapping(mainType);
    }

    @Override
    public TypeMapping createTypeMapping(IndexType.IndexRelationType relationType) {
        Preconditions.checkState((this.mainType != null ? 1 : 0) != 0, (Object)"Mapping for main type must be created first");
        Preconditions.checkArgument((boolean)relationType.getMainType().equals(this.mainType), (String)"main type of relation must be %s", (Object[])new Object[]{this.mainType});
        return super.createTypeMapping(relationType);
    }

    @Override
    public BuiltIndex<NewRegularIndex> build() {
        Preconditions.checkState((this.mainType != null ? 1 : 0) != 0, (Object)"Mapping for main type must be defined");
        Preconditions.checkState((!this.mainType.getIndex().acceptsRelations() || !this.getRelations().isEmpty() ? 1 : 0) != 0, (Object)"At least one relation must be defined when index accepts relations");
        return new BuiltIndex<NewRegularIndex>(this);
    }
}

