/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.es.request;

import org.apache.commons.lang.StringUtils;
import org.elasticsearch.action.ListenableActionFuture;
import org.elasticsearch.action.admin.cluster.state.ClusterStateAction;
import org.elasticsearch.action.admin.cluster.state.ClusterStateRequest;
import org.elasticsearch.action.admin.cluster.state.ClusterStateRequestBuilder;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.unit.TimeValue;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Profiler;
import org.sonar.server.es.EsClient;

public class ProxyClusterStateRequestBuilder
extends ClusterStateRequestBuilder {
    public ProxyClusterStateRequestBuilder(Client client) {
        super((ElasticsearchClient)client.admin().cluster(), ClusterStateAction.INSTANCE);
    }

    public ClusterStateResponse get() {
        Profiler profiler = Profiler.createIfTrace((Logger)EsClient.LOGGER).start();
        try {
            ClusterStateResponse clusterStateResponse = (ClusterStateResponse)super.execute().actionGet();
            return clusterStateResponse;
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Fail to execute %s", this.toString()), e);
        }
        finally {
            if (profiler.isTraceEnabled()) {
                profiler.stopTrace(this.toString());
            }
        }
    }

    public ClusterStateResponse get(TimeValue timeout) {
        throw new IllegalStateException("Not yet implemented");
    }

    public ClusterStateResponse get(String timeout) {
        throw new IllegalStateException("Not yet implemented");
    }

    public ListenableActionFuture<ClusterStateResponse> execute() {
        throw new UnsupportedOperationException("execute() should not be called as it's used for asynchronous");
    }

    public String toString() {
        StringBuilder message = new StringBuilder();
        message.append("ES cluster state request");
        if (((ClusterStateRequest)this.request).indices().length > 0) {
            message.append(String.format(" on indices '%s'", StringUtils.join((Object[])((ClusterStateRequest)this.request).indices(), (String)",")));
        }
        return message.toString();
    }
}

