/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.issue.notification;

import javax.annotation.CheckForNull;
import org.sonar.api.config.EmailSettings;
import org.sonar.api.notifications.Notification;
import org.sonar.core.i18n.I18n;
import org.sonar.server.issue.notification.EmailMessage;
import org.sonar.server.issue.notification.FPOrWontFixNotification;
import org.sonar.server.issue.notification.IssueChangesEmailTemplate;
import org.sonar.server.issue.notification.IssuesChangesNotificationBuilder;

public class FpOrWontFixEmailTemplate
extends IssueChangesEmailTemplate {
    private static final String NOTIFICATION_NAME_I18N_KEY = "notification.dispatcher.NewFalsePositiveIssue";

    public FpOrWontFixEmailTemplate(I18n i18n, EmailSettings settings) {
        super(i18n, settings);
    }

    @Override
    @CheckForNull
    public EmailMessage format(Notification notif) {
        if (!(notif instanceof FPOrWontFixNotification)) {
            return null;
        }
        FPOrWontFixNotification notification = (FPOrWontFixNotification)notif;
        EmailMessage emailMessage = new EmailMessage().setMessageId(FpOrWontFixEmailTemplate.getMessageId(notification.getResolution())).setSubject(FpOrWontFixEmailTemplate.buildSubject(notification)).setHtmlMessage(this.buildMessage(notification));
        if (notification.getChange() instanceof IssuesChangesNotificationBuilder.UserChange) {
            IssuesChangesNotificationBuilder.User user = ((IssuesChangesNotificationBuilder.UserChange)notification.getChange()).getUser();
            emailMessage.setFrom(user.getName().orElse(user.getLogin()));
        }
        return emailMessage;
    }

    private static String getMessageId(FPOrWontFixNotification.FpOrWontFix resolution) {
        if (resolution == FPOrWontFixNotification.FpOrWontFix.WONT_FIX) {
            return "wontfix-issue-changes";
        }
        if (resolution == FPOrWontFixNotification.FpOrWontFix.FP) {
            return "fp-issue-changes";
        }
        throw new IllegalArgumentException("Unsupported resolution " + (Object)((Object)resolution));
    }

    private static String buildSubject(FPOrWontFixNotification notification) {
        return "Issues marked as " + FpOrWontFixEmailTemplate.resolutionLabel(notification.getResolution());
    }

    private String buildMessage(FPOrWontFixNotification notification) {
        StringBuilder sb = new StringBuilder();
        FpOrWontFixEmailTemplate.paragraph(sb, s -> s.append("Hi,"));
        FpOrWontFixEmailTemplate.paragraph(sb, s -> s.append("A manual change has resolved ").append(notification.getChangedIssues().size() > 1 ? "issues" : "an issue").append(" as ").append(FpOrWontFixEmailTemplate.resolutionLabel(notification.getResolution())).append(":"));
        this.addIssuesByProjectThenRule(sb, notification.getChangedIssues());
        this.addFooter(sb, NOTIFICATION_NAME_I18N_KEY);
        return sb.toString();
    }

    private static String resolutionLabel(FPOrWontFixNotification.FpOrWontFix resolution) {
        if (resolution == FPOrWontFixNotification.FpOrWontFix.WONT_FIX) {
            return "Won't Fix";
        }
        if (resolution == FPOrWontFixNotification.FpOrWontFix.FP) {
            return "False Positive";
        }
        throw new IllegalArgumentException("Unsupported resolution " + (Object)((Object)resolution));
    }
}

