/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.issue.notification;

import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.server.issue.notification.MyNewIssuesNotification;
import org.sonar.server.issue.notification.NewIssuesNotification;
import org.sonar.server.notification.EmailNotificationHandler;
import org.sonar.server.notification.NotificationDispatcherMetadata;
import org.sonar.server.notification.NotificationManager;
import org.sonar.server.notification.email.EmailNotificationChannel;

public class MyNewIssuesNotificationHandler
extends EmailNotificationHandler<MyNewIssuesNotification> {
    public static final String KEY = "SQ-MyNewIssues";
    private static final NotificationDispatcherMetadata METADATA = NotificationDispatcherMetadata.create("SQ-MyNewIssues").setProperty("globalNotification", String.valueOf(true)).setProperty("perProjectNotification", String.valueOf(true));
    private final NotificationManager notificationManager;

    public MyNewIssuesNotificationHandler(NotificationManager notificationManager, EmailNotificationChannel emailNotificationChannel) {
        super(emailNotificationChannel);
        this.notificationManager = notificationManager;
    }

    @Override
    public Optional<NotificationDispatcherMetadata> getMetadata() {
        return Optional.of(METADATA);
    }

    public static NotificationDispatcherMetadata newMetadata() {
        return METADATA;
    }

    @Override
    public Class<MyNewIssuesNotification> getNotificationClass() {
        return MyNewIssuesNotification.class;
    }

    @Override
    public Set<EmailNotificationChannel.EmailDeliveryRequest> toEmailDeliveryRequests(Collection<MyNewIssuesNotification> notifications) {
        Multimap notificationsByProjectKey = (Multimap)notifications.stream().filter(t -> t.getProjectKey() != null).filter(t -> t.getAssignee() != null).collect(MoreCollectors.index(NewIssuesNotification::getProjectKey));
        if (notificationsByProjectKey.isEmpty()) {
            return Collections.emptySet();
        }
        return (Set)notificationsByProjectKey.asMap().entrySet().stream().flatMap(e -> this.toEmailDeliveryRequests((String)e.getKey(), (Collection)e.getValue())).collect(MoreCollectors.toSet((int)notifications.size()));
    }

    private Stream<? extends EmailNotificationChannel.EmailDeliveryRequest> toEmailDeliveryRequests(String projectKey, Collection<MyNewIssuesNotification> notifications) {
        Set<String> assignees = notifications.stream().map(MyNewIssuesNotification::getAssignee).collect(Collectors.toSet());
        Map recipientsByLogin = (Map)this.notificationManager.findSubscribedEmailRecipients(KEY, projectKey, assignees, NotificationManager.SubscriberPermissionsOnProject.ALL_MUST_HAVE_ROLE_USER).stream().collect(MoreCollectors.uniqueIndex(NotificationManager.EmailRecipient::getLogin));
        return notifications.stream().map(notification -> MyNewIssuesNotificationHandler.toEmailDeliveryRequest(recipientsByLogin, notification)).filter(Objects::nonNull);
    }

    @CheckForNull
    private static EmailNotificationChannel.EmailDeliveryRequest toEmailDeliveryRequest(Map<String, NotificationManager.EmailRecipient> recipientsByLogin, MyNewIssuesNotification notification) {
        String assignee = notification.getAssignee();
        NotificationManager.EmailRecipient emailRecipient = recipientsByLogin.get(assignee);
        if (emailRecipient != null) {
            return new EmailNotificationChannel.EmailDeliveryRequest(emailRecipient.getEmail(), notification);
        }
        return null;
    }
}

