/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.organization;

import java.util.Optional;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.server.organization.OrganizationFlags;

public class OrganizationFlagsImpl
implements OrganizationFlags {
    static final String FAILURE_MESSAGE_ENABLED = "Organization support is enabled";
    static final String FAILURE_MESSAGE_DISABLED = "Organization support is disabled";
    private final DbClient dbClient;

    public OrganizationFlagsImpl(DbClient dbClient) {
        this.dbClient = dbClient;
    }

    @Override
    public boolean isEnabled(DbSession dbSession) {
        Optional value = this.dbClient.internalPropertiesDao().selectByKey(dbSession, "organization.enabled");
        return value.map("true"::equals).orElse(false);
    }

    @Override
    public void checkEnabled(DbSession dbSession) {
        if (!this.isEnabled(dbSession)) {
            throw new IllegalStateException(FAILURE_MESSAGE_DISABLED);
        }
    }

    @Override
    public void checkDisabled(DbSession dbSession) {
        if (this.isEnabled(dbSession)) {
            throw new IllegalStateException(FAILURE_MESSAGE_ENABLED);
        }
    }

    @Override
    public void enable(DbSession dbSession) {
        this.dbClient.internalPropertiesDao().save(dbSession, "organization.enabled", String.valueOf(true));
    }
}

