/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.property;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.sonar.server.property.InternalProperties;

public class MapInternalProperties
implements InternalProperties {
    private final Map<String, String> values = new HashMap<String, String>(1);

    @Override
    public Optional<String> read(String propertyKey) {
        MapInternalProperties.checkPropertyKey(propertyKey);
        return Optional.ofNullable(this.values.get(propertyKey));
    }

    @Override
    public void write(String propertyKey, @Nullable String value) {
        MapInternalProperties.checkPropertyKey(propertyKey);
        this.values.put(propertyKey, value);
    }

    private static void checkPropertyKey(@Nullable String propertyKey) {
        Preconditions.checkArgument((propertyKey != null && !propertyKey.isEmpty() ? 1 : 0) != 0, (Object)"property key can't be null nor empty");
    }
}

