/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.process.cluster;

import java.util.Arrays;

public enum NodeType {
    APPLICATION("application"),
    SEARCH("search");

    private final String value;

    private NodeType(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public static NodeType parse(String nodeType) {
        return Arrays.stream(NodeType.values()).filter(t -> nodeType.equals(t.value)).findFirst().orElseThrow(() -> new IllegalArgumentException("Invalid value: " + nodeType));
    }

    public static boolean isValid(String nodeType) {
        return Arrays.stream(NodeType.values()).anyMatch(t -> nodeType.equals(t.value));
    }
}

