/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Trivia;
import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.flex.FlexCheck;
import org.sonar.flex.FlexGrammar;
import org.sonar.flex.checks.asdoc.ASDocClassCheck;
import org.sonar.flex.checks.asdoc.ASDocMemberCheck;
import org.sonar.flex.checks.utils.Clazz;

@Rule(key="S1176")
public class ASDocCheck
extends FlexCheck {
    public static final String INHERIT_TAG = "@inheritDoc";
    public static final String PRIVATE_TAG = "@private";
    private static final boolean DEFAULT_CLASSES = true;
    private static final boolean DEFAULT_PROPERTIES = true;
    private static final boolean DEFAULT_METHODS = true;
    private static final boolean DEFAULT_METHOD_PARAMS = true;
    private static final boolean DEFAULT_METHOD_RETURN = true;
    @RuleProperty(key="asdoc_classes", description="Public classes should be documented", defaultValue="true", type="BOOLEAN")
    public boolean classes = true;
    @RuleProperty(key="asdoc_properties", description="Public properties should be documented", defaultValue="true", type="BOOLEAN")
    public boolean properties = true;
    @RuleProperty(key="asdoc_methods", description="Public methods should be documented", defaultValue="true", type="BOOLEAN")
    public boolean methods = true;
    @RuleProperty(key="asdoc_method_param", description="All parameters of public methods should be documented", defaultValue="true", type="BOOLEAN")
    public boolean methodParams = true;
    @RuleProperty(key="asdoc_method_return", description="All return type of public methods should be documented", defaultValue="true", type="BOOLEAN")
    public boolean methodReturn = true;
    private ASDocClassCheck classChecker = new ASDocClassCheck();
    private ASDocMemberCheck memberChecker = new ASDocMemberCheck();

    @Override
    public List<AstNodeType> subscribedTo() {
        return Collections.singletonList(FlexGrammar.CLASS_DEF);
    }

    @Override
    public void visitNode(AstNode astNode) {
        boolean hasPrivateTag = this.classChecker.visitNode(this, astNode);
        if (!hasPrivateTag) {
            this.memberChecker.visitNode(this, Clazz.getDirectives(astNode));
        }
    }

    public boolean hasASDoc(List<Trivia> trivia) {
        for (Trivia comment : trivia) {
            String value = comment.getToken().getValue().trim();
            if (!value.startsWith("/**") || !value.endsWith("*/")) continue;
            return true;
        }
        return false;
    }

    public boolean containsOnOfTags(List<Trivia> trivia, String ... tags) {
        for (Trivia comment : trivia) {
            String value = comment.getToken().getValue();
            for (String tag : tags) {
                if (!value.contains(tag)) continue;
                return true;
            }
        }
        return false;
    }
}

