/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.http;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.CookieHandler;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.BasicAuthenticationManager;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManagerExt;
import org.tmatesoft.svn.core.auth.ISVNProxyManager;
import org.tmatesoft.svn.core.auth.ISVNProxyManagerEx;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.auth.SVNPasswordAuthentication;
import org.tmatesoft.svn.core.internal.io.dav.handlers.DAVErrorHandler;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPAuthentication;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPBasicAuthentication;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPDigestAuthentication;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPHeader;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPNTLMAuthentication;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPNegotiateAuthentication;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPParser;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPRequest;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPSSLKeyManager;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPStatus;
import org.tmatesoft.svn.core.internal.io.dav.http.IHTTPConnection;
import org.tmatesoft.svn.core.internal.io.dav.http.SpoolFile;
import org.tmatesoft.svn.core.internal.io.dav.http.XMLReader;
import org.tmatesoft.svn.core.internal.util.ChunkedInputStream;
import org.tmatesoft.svn.core.internal.util.FixedSizeInputStream;
import org.tmatesoft.svn.core.internal.util.SVNSSLUtil;
import org.tmatesoft.svn.core.internal.util.SVNSocketFactory;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.wc.IOExceptionWrapper;
import org.tmatesoft.svn.core.internal.wc.SVNCancellableOutputStream;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.util.ISVNDebugLog;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class HTTPConnection
implements IHTTPConnection {
    private static final DefaultHandler DEFAULT_SAX_HANDLER = new DefaultHandler();
    private static EntityResolver NO_ENTITY_RESOLVER = new EntityResolver(){

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            return new InputSource(new ByteArrayInputStream(new byte[0]));
        }
    };
    private static final int requestAttempts;
    private static final int DEFAULT_HTTP_TIMEOUT = 3600000;
    private static SAXParserFactory ourSAXParserFactory;
    private static final Map<String, List<String>> emptyHeader;
    private byte[] myBuffer;
    private SAXParser mySAXParser;
    private SVNURL myHost;
    private OutputStream myOutputStream;
    private InputStream myInputStream;
    private Socket mySocket;
    private SVNRepository myRepository;
    private boolean myIsSecured;
    private boolean myIsProxied;
    private boolean myLogSSLParams;
    private SVNAuthentication myLastValidAuth;
    private HTTPAuthentication myChallengeCredentials;
    private HTTPAuthentication myProxyAuthentication;
    private boolean myIsSpoolResponse;
    private TrustManager myTrustManager;
    private HTTPSSLKeyManager myKeyManager;
    private String myCharset;
    private boolean myIsSpoolAll;
    private File mySpoolDirectory;
    private long myNextRequestTimeout;
    private int myRequestCount;
    private HTTPStatus myLastStatus;

    public HTTPConnection(SVNRepository repository, String charset, File spoolDirectory, boolean spoolAll) throws SVNException {
        this.myRepository = repository;
        this.myCharset = charset;
        this.myHost = repository.getLocation().setPath("", false);
        this.myIsSecured = "https".equalsIgnoreCase(this.myHost.getProtocol());
        this.myIsSpoolAll = spoolAll;
        this.mySpoolDirectory = spoolDirectory;
        this.myNextRequestTimeout = Long.MAX_VALUE;
    }

    @Override
    public HTTPStatus getLastStatus() {
        return this.myLastStatus;
    }

    public SVNURL getHost() {
        return this.myHost;
    }

    private void connect(HTTPSSLKeyManager keyManager, TrustManager trustManager, ISVNProxyManager proxyManager) throws IOException, SVNException {
        SVNURL location = this.myRepository.getLocation();
        if (this.mySocket == null || SVNSocketFactory.isSocketStale(this.mySocket)) {
            int readTimeout;
            this.close();
            String host = location.getHost();
            int port = location.getPort();
            ISVNAuthenticationManager authManager = this.myRepository.getAuthenticationManager();
            int connectTimeout = authManager != null ? authManager.getConnectTimeout(this.myRepository) : 0;
            int n = readTimeout = authManager != null ? authManager.getReadTimeout(this.myRepository) : 3600000;
            if (readTimeout < 0) {
                readTimeout = 3600000;
            }
            if (proxyManager != null && proxyManager.getProxyHost() != null) {
                ISVNDebugLog debugLog = this.myRepository.getDebugLog();
                debugLog.logFine(SVNLogType.NETWORK, "Using proxy " + proxyManager.getProxyHost() + " (secured=" + this.myIsSecured + ")");
                this.mySocket = SVNSocketFactory.createPlainSocket(proxyManager.getProxyHost(), proxyManager.getProxyPort(), connectTimeout, readTimeout, this.myRepository.getCanceller());
                this.myIsProxied = true;
                if (this.myIsSecured) {
                    int authAttempts = 0;
                    boolean credentialsUsed = false;
                    while (true) {
                        if (this.mySocket == null) {
                            this.mySocket = SVNSocketFactory.createPlainSocket(proxyManager.getProxyHost(), proxyManager.getProxyPort(), connectTimeout, readTimeout, this.myRepository.getCanceller());
                            debugLog.logFine(SVNLogType.NETWORK, "proxy connection reopened");
                        }
                        HTTPRequest connectRequest = new HTTPRequest(this.myCharset);
                        connectRequest.setConnection(this);
                        if (this.myProxyAuthentication != null) {
                            String authToken = this.myProxyAuthentication.authenticate();
                            connectRequest.setProxyAuthentication(authToken);
                            debugLog.logFine(SVNLogType.NETWORK, "auth token set: " + authToken);
                        }
                        connectRequest.setForceProxyAuth(true);
                        connectRequest.dispatch("CONNECT", host + ":" + port, null, 0, 0, null);
                        HTTPStatus status = connectRequest.getStatus();
                        if (status.getCode() == 200) {
                            KeyManager[] keyManagerArray;
                            this.myInputStream = null;
                            this.myOutputStream = null;
                            this.myProxyAuthentication = null;
                            if (keyManager != null) {
                                KeyManager[] keyManagerArray2 = new KeyManager[1];
                                keyManagerArray = keyManagerArray2;
                                keyManagerArray2[0] = keyManager;
                            } else {
                                keyManagerArray = new KeyManager[]{};
                            }
                            this.mySocket = SVNSocketFactory.createSSLSocket(keyManagerArray, trustManager, host, port, this.mySocket, readTimeout);
                            proxyManager.acknowledgeProxyContext(true, null);
                            return;
                        }
                        if (status.getCode() == 407) {
                            if (HTTPConnection.hasToCloseConnection(connectRequest.getResponseHeader())) {
                                this.close();
                                debugLog.logFine(SVNLogType.NETWORK, "Connection closed as requested by the response header");
                            }
                            debugLog.logFine(SVNLogType.NETWORK, "authentication attempt #" + ++authAttempts);
                            List<String> proxyAuthHeaders = connectRequest.getResponseHeader().getHeaderValues("Proxy-Authenticate");
                            List<String> authTypes = Arrays.asList("Basic", "Digest", "Negotiate", "NTLM");
                            debugLog.logFine(SVNLogType.NETWORK, "authentication methods supported: " + authTypes);
                            try {
                                this.myProxyAuthentication = HTTPAuthentication.parseAuthParameters(proxyAuthHeaders, this.myProxyAuthentication, this.myCharset, authTypes, null, this.myRequestCount);
                            }
                            catch (SVNException svne) {
                                this.myRepository.getDebugLog().logFine(SVNLogType.NETWORK, svne);
                                this.close();
                                throw svne;
                            }
                            debugLog.logFine(SVNLogType.NETWORK, "authentication type chosen: " + this.myProxyAuthentication.getClass().getSimpleName());
                            connectRequest.initCredentials(this.myProxyAuthentication, "CONNECT", host + ":" + port);
                            HTTPNTLMAuthentication ntlmProxyAuth = null;
                            HTTPNegotiateAuthentication negotiateProxyAuth = null;
                            if (this.myProxyAuthentication instanceof HTTPNTLMAuthentication) {
                                ntlmProxyAuth = (HTTPNTLMAuthentication)this.myProxyAuthentication;
                                if (ntlmProxyAuth.isInType3State()) {
                                    debugLog.logFine(SVNLogType.NETWORK, "continuation of NTLM authentication");
                                    continue;
                                }
                            } else if (this.myProxyAuthentication instanceof HTTPNegotiateAuthentication && (negotiateProxyAuth = (HTTPNegotiateAuthentication)this.myProxyAuthentication).isStarted()) {
                                debugLog.logFine(SVNLogType.NETWORK, "continuation of Negotiate authentication");
                                continue;
                            }
                            if (ntlmProxyAuth != null && authAttempts == 1 && !ntlmProxyAuth.allowPropmtForCredentials()) continue;
                            if (negotiateProxyAuth != null && !negotiateProxyAuth.needsLogin()) {
                                debugLog.logFine(SVNLogType.NETWORK, "Negotiate will use existing credentials");
                                continue;
                            }
                            if (!credentialsUsed) {
                                this.myProxyAuthentication.setCredentials(SVNPasswordAuthentication.newInstance(proxyManager.getProxyUserName(), this.getProxyPasswordValue(proxyManager), false, this.myRepository.getLocation(), false));
                                debugLog.logFine(SVNLogType.NETWORK, "explicit credentials set");
                                credentialsUsed = true;
                                continue;
                            }
                            debugLog.logFine(SVNLogType.NETWORK, "no more credentials to try");
                            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, "HTTP proxy authorization failed");
                            if (proxyManager != null) {
                                proxyManager.acknowledgeProxyContext(false, err);
                            }
                            SVNErrorManager.error(err, SVNLogType.NETWORK);
                            continue;
                        }
                        SVNURL proxyURL = SVNURL.parseURIEncoded("http://" + proxyManager.getProxyHost() + ":" + proxyManager.getProxyPort());
                        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "{0} request failed on ''{1}''", "CONNECT", proxyURL);
                        proxyManager.acknowledgeProxyContext(false, err);
                        SVNErrorManager.error(err, connectRequest.getErrorMessage(), SVNLogType.NETWORK);
                    }
                }
                if (proxyManager.getProxyUserName() != null && this.getProxyPasswordValue(proxyManager) != null) {
                    this.myProxyAuthentication = new HTTPBasicAuthentication("UTF-8");
                    this.myProxyAuthentication.setCredentials(SVNPasswordAuthentication.newInstance(proxyManager.getProxyUserName(), this.getProxyPasswordValue(proxyManager), false, this.myRepository.getLocation(), false));
                    debugLog.logFine(SVNLogType.NETWORK, "explicit credentials set");
                }
            } else {
                Socket socket;
                this.myIsProxied = false;
                this.myProxyAuthentication = null;
                if (this.myIsSecured) {
                    KeyManager[] keyManagerArray;
                    if (keyManager != null) {
                        KeyManager[] keyManagerArray3 = new KeyManager[1];
                        keyManagerArray = keyManagerArray3;
                        keyManagerArray3[0] = keyManager;
                    } else {
                        keyManagerArray = new KeyManager[]{};
                    }
                    socket = SVNSocketFactory.createSSLSocket(keyManagerArray, trustManager, host, port, connectTimeout, readTimeout, this.myRepository.getCanceller());
                } else {
                    socket = SVNSocketFactory.createPlainSocket(host, port, connectTimeout, readTimeout, this.myRepository.getCanceller());
                }
                this.mySocket = socket;
                this.myLogSSLParams = true;
            }
        }
    }

    private char[] getProxyPasswordValue(ISVNProxyManager proxyManager) {
        if (proxyManager == null) {
            return null;
        }
        if (proxyManager instanceof ISVNProxyManagerEx) {
            return ((ISVNProxyManagerEx)proxyManager).getProxyPasswordValue();
        }
        String password = proxyManager.getProxyPassword();
        if (password == null) {
            return null;
        }
        return password.toCharArray();
    }

    public void readHeader(HTTPRequest request) throws IOException {
        InputStream is = this.myRepository.getDebugLog().createLogStream(SVNLogType.NETWORK, this.getInputStream());
        try {
            HTTPStatus status = HTTPParser.parseStatus(is, this.myCharset);
            HTTPHeader header = HTTPHeader.parseHeader(is, this.myCharset);
            request.setStatus(status);
            request.setResponseHeader(header);
        }
        catch (ParseException e) {
            String line = HTTPParser.readLine(is, this.myCharset);
            while (line != null && line.length() > 0) {
                line = HTTPParser.readLine(is, this.myCharset);
            }
            throw new IOException(e.getMessage());
        }
        finally {
            this.myRepository.getDebugLog().flushStream(is);
        }
    }

    public SVNErrorMessage readError(HTTPRequest request, String method, String path) {
        DAVErrorHandler errorHandler = new DAVErrorHandler();
        try {
            this.readData(request, method, path, (DefaultHandler)errorHandler);
        }
        catch (IOException e) {
            return null;
        }
        return errorHandler.getErrorMessage();
    }

    public void sendData(byte[] body) throws IOException {
        try {
            this.getOutputStream().write(body, 0, body.length);
            this.getOutputStream().flush();
        }
        finally {
            this.myRepository.getDebugLog().flushStream(this.getOutputStream());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendData(InputStream source, long length) throws IOException {
        try {
            byte[] buffer = this.getBuffer();
            while (length > 0L) {
                int read = source.read(buffer, 0, (int)Math.min((long)buffer.length, length));
                if (read > 0) {
                    length -= (long)read;
                    this.getOutputStream().write(buffer, 0, read);
                    continue;
                }
                if (read >= 0) continue;
                break;
            }
            this.getOutputStream().flush();
        }
        finally {
            this.myRepository.getDebugLog().flushStream(this.getOutputStream());
        }
    }

    @Override
    public SVNAuthentication getLastValidCredentials() {
        return this.myLastValidAuth;
    }

    @Override
    public void clearAuthenticationCache() {
        this.clearLastValidAuth();
        this.myTrustManager = null;
        this.myKeyManager = null;
        this.myChallengeCredentials = null;
        this.myProxyAuthentication = null;
        this.myRequestCount = 0;
    }

    private void clearLastValidAuth() {
        if (this.myLastValidAuth != null) {
            this.myLastValidAuth.dismissSensitiveData();
        }
        this.myLastValidAuth = null;
    }

    @Override
    public HTTPStatus request(String method, String path, HTTPHeader header, StringBuffer body, int ok1, int ok2, OutputStream dst, DefaultHandler handler) throws SVNException {
        return this.request(method, path, header, body, ok1, ok2, dst, handler, null);
    }

    @Override
    public HTTPStatus request(String method, String path, HTTPHeader header, StringBuffer body, int ok1, int ok2, OutputStream dst, DefaultHandler handler, SVNErrorMessage context) throws SVNException {
        byte[] buffer = null;
        if (body != null) {
            try {
                buffer = body.toString().getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                buffer = body.toString().getBytes();
            }
        }
        return this.request(method, path, header, buffer != null ? new ByteArrayInputStream(buffer) : null, ok1, ok2, dst, handler, context);
    }

    @Override
    public HTTPStatus request(String method, String path, HTTPHeader header, InputStream body, int ok1, int ok2, OutputStream dst, DefaultHandler handler) throws SVNException {
        return this.request(method, path, header, body, ok1, ok2, dst, handler, null);
    }

    @Override
    public HTTPStatus request(String method, String path, HTTPHeader header, InputStream body, int ok1, int ok2, OutputStream dst, DefaultHandler handler, SVNErrorMessage context) throws SVNException {
        SVNErrorMessage err;
        block93: {
            HTTPRequest request;
            String realm;
            SVNAuthentication httpAuth;
            ISVNProxyManager proxyManager;
            TrustManager trustManager;
            ISVNAuthenticationManager authManager;
            block94: {
                boolean isAuthForced;
                this.myLastStatus = null;
                ++this.myRequestCount;
                if ("".equals(path) || path == null) {
                    path = "/";
                }
                authManager = this.myRepository.getAuthenticationManager();
                HTTPSSLKeyManager keyManager = this.myKeyManager == null && authManager != null ? this.createKeyManager() : this.myKeyManager;
                trustManager = this.myTrustManager == null && authManager != null ? authManager.getTrustManager(this.myRepository.getLocation()) : this.myTrustManager;
                proxyManager = authManager != null ? authManager.getProxyManager(this.myRepository.getLocation()) : null;
                String sslRealm = this.composeRealm("");
                httpAuth = this.myLastValidAuth;
                boolean bl = isAuthForced = authManager != null ? authManager.isAuthenticationForced() : false;
                if (httpAuth == null && isAuthForced) {
                    httpAuth = authManager.getFirstAuthentication("svn.simple", sslRealm, null);
                    this.myChallengeCredentials = new HTTPBasicAuthentication((SVNPasswordAuthentication)httpAuth, this.myCharset);
                }
                realm = null;
                request = new HTTPRequest(this.myCharset);
                request.setConnection(this);
                request.setKeepAlive(true);
                request.setRequestBody(body);
                request.setResponseHandler(handler);
                request.setResponseStream(dst);
                err = null;
                boolean ntlmAuthIsRequired = false;
                boolean ntlmProxyAuthIsRequired = false;
                boolean negoAuthIsRequired = false;
                int authAttempts = 0;
                while (true) {
                    if (this.myNextRequestTimeout < 0L || System.currentTimeMillis() >= this.myNextRequestTimeout) {
                        SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "Keep-Alive timeout detected");
                        this.close();
                        if (this.isClearCredentialsOnClose(this.myChallengeCredentials)) {
                            httpAuth = null;
                        }
                    }
                    int retryCount = 1;
                    try {
                        CookieHandler cookieHandler;
                        err = null;
                        String httpAuthResponse = null;
                        String proxyAuthResponse = null;
                        URI actualURI = null;
                        try {
                            actualURI = new URI(this.myRepository.getLocation().toString());
                        }
                        catch (URISyntaxException e) {
                            this.myRepository.getDebugLog().logError(SVNLogType.NETWORK, e);
                        }
                        while (retryCount >= 0) {
                            SSLSession session;
                            Map<String, List<String>> cookieHeader;
                            this.connect(keyManager, trustManager, proxyManager);
                            request.reset();
                            request.setProxied(this.myIsProxied);
                            request.setSecured(this.myIsSecured);
                            if (this.myProxyAuthentication != null && (ntlmProxyAuthIsRequired || !"NTLM".equals(this.myProxyAuthentication.getAuthenticationScheme()))) {
                                if (proxyAuthResponse == null) {
                                    request.initCredentials(this.myProxyAuthentication, method, path);
                                    proxyAuthResponse = this.myProxyAuthentication.authenticate();
                                }
                                request.setProxyAuthentication(proxyAuthResponse);
                            }
                            if (this.myChallengeCredentials != null && (ntlmAuthIsRequired || negoAuthIsRequired || !"NTLM".equals(this.myChallengeCredentials.getAuthenticationScheme()) && !"Negotiate".equals(this.myChallengeCredentials.getAuthenticationScheme()) && httpAuth != null)) {
                                if (httpAuthResponse == null) {
                                    request.initCredentials(this.myChallengeCredentials, method, path);
                                    httpAuthResponse = this.myChallengeCredentials.authenticate();
                                }
                                request.setAuthentication(httpAuthResponse);
                            }
                            if ((cookieHandler = CookieHandler.getDefault()) != null && actualURI != null && (cookieHeader = cookieHandler.get(actualURI, emptyHeader)) != null) {
                                request.setCookies(cookieHeader);
                            }
                            if (this.mySocket instanceof SSLSocket && this.myLogSSLParams && (session = ((SSLSocket)this.mySocket).getSession()) != null) {
                                this.myRepository.getDebugLog().logFine(SVNLogType.NETWORK, "Connected to " + this.myRepository.getLocation() + " using " + session.getProtocol());
                                this.myLogSSLParams = false;
                            }
                            try {
                                request.dispatch(method, path, header, ok1, ok2, context);
                                break;
                            }
                            catch (EOFException pe) {
                                this.myRepository.getDebugLog().logFine(SVNLogType.NETWORK, pe);
                                if (retryCount > 0) {
                                    this.close();
                                    continue;
                                }
                                throw (IOException)new IOException(pe.getMessage()).initCause(pe);
                            }
                            catch (SocketException e) {
                                if (!"Broken pipe".equals(e.getMessage())) {
                                    throw e;
                                }
                                this.myRepository.getDebugLog().logFine(SVNLogType.NETWORK, e);
                                if (retryCount > 0) {
                                    this.close();
                                    continue;
                                }
                                throw (SocketException)new SocketException(e.getMessage()).initCause(e);
                            }
                            finally {
                                --retryCount;
                            }
                        }
                        if ((cookieHandler = CookieHandler.getDefault()) != null && actualURI != null) {
                            cookieHandler.put(actualURI, request.getResponseHeader().getRawHeaders());
                        }
                        this.myNextRequestTimeout = request.getNextRequestTimeout();
                        this.myLastStatus = request.getStatus();
                        this.myLastStatus.setHeader(request.getResponseHeader());
                    }
                    catch (SSLHandshakeException ssl) {
                        this.myRepository.getDebugLog().logFine(SVNLogType.NETWORK, ssl);
                        this.close();
                        if (ssl.getCause() instanceof SVNSSLUtil.CertificateNotTrustedException || ssl.getCause() instanceof SVNSSLUtil.CertificateDoesNotConformConstraints) {
                            SVNErrorManager.cancel(ssl.getCause().getMessage(), SVNLogType.NETWORK);
                        }
                        SVNErrorMessage sslErr = SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, "SSL handshake failed: ''{0}''", new Object[]{ssl.getMessage()}, 0, ssl);
                        if (keyManager != null && keyManager.isInitialized()) {
                            keyManager.acknowledgeAndClearAuthentication(sslErr);
                        } else {
                            sslErr = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "SSL handshake failed: ''{0}''", new Object[]{ssl.getMessage()}, 0, ssl);
                            SVNErrorManager.error(sslErr, SVNLogType.NETWORK);
                        }
                        err = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, ssl);
                        continue;
                    }
                    catch (IOException e) {
                        this.myRepository.getDebugLog().logFine(SVNLogType.NETWORK, e);
                        if (e instanceof SocketTimeoutException) {
                            err = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "timed out waiting for server", null, 0, e);
                        } else if (e instanceof UnknownHostException) {
                            err = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "unknown host", null, 0, e);
                        } else if (e instanceof ConnectException) {
                            err = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "connection refused by the server", null, 0, e);
                        } else if (e instanceof SVNCancellableOutputStream.IOCancelException) {
                            SVNErrorManager.cancel(e.getMessage(), SVNLogType.NETWORK);
                        } else {
                            err = e instanceof SSLException ? SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, e) : SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, e);
                        }
                    }
                    catch (SVNException e) {
                        this.myRepository.getDebugLog().logFine(SVNLogType.NETWORK, e);
                        this.close();
                        throw e;
                    }
                    finally {
                        this.finishResponse(request);
                        continue;
                    }
                    if (err != null) {
                        if (proxyManager != null) {
                            proxyManager.acknowledgeProxyContext(false, err);
                        }
                        this.close();
                        break block93;
                    }
                    if (proxyManager != null) {
                        proxyManager.acknowledgeProxyContext(true, err);
                    }
                    if (keyManager != null) {
                        this.myKeyManager = keyManager;
                        this.myTrustManager = trustManager;
                        keyManager.acknowledgeAndClearAuthentication(null);
                    }
                    if (this.myLastStatus.getCode() == 403) {
                        if (httpAuth != null && authManager != null) {
                            BasicAuthenticationManager.acknowledgeAuthentication(false, "svn.simple", realm, request.getErrorMessage(), httpAuth, this.myRepository.getLocation(), authManager);
                        }
                        this.clearLastValidAuth();
                        this.close();
                        err = request.getErrorMessage();
                        break block94;
                    }
                    if (this.myIsProxied && this.myLastStatus.getCode() == 407) {
                        List<String> proxyAuthHeaders = request.getResponseHeader().getHeaderValues("Proxy-Authenticate");
                        Collection<String> authTypes = null;
                        if (authManager != null && authManager instanceof DefaultSVNAuthenticationManager) {
                            DefaultSVNAuthenticationManager defaultAuthManager = (DefaultSVNAuthenticationManager)authManager;
                            authTypes = defaultAuthManager.getAuthTypes(this.myRepository.getLocation());
                        }
                        try {
                            this.myProxyAuthentication = HTTPAuthentication.parseAuthParameters(proxyAuthHeaders, this.myProxyAuthentication, this.myCharset, authTypes, null, this.myRequestCount);
                        }
                        catch (SVNException svne) {
                            this.myRepository.getDebugLog().logFine(SVNLogType.NETWORK, svne);
                            err = svne.getErrorMessage();
                            break block93;
                        }
                        if (this.myProxyAuthentication instanceof HTTPNTLMAuthentication) {
                            ntlmProxyAuthIsRequired = true;
                            HTTPNTLMAuthentication ntlmProxyAuth = (HTTPNTLMAuthentication)this.myProxyAuthentication;
                            if (ntlmProxyAuth.isInType3State()) continue;
                        }
                        err = SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, "HTTP proxy authorization failed");
                        if (proxyManager != null) {
                            proxyManager.acknowledgeProxyContext(false, err);
                        }
                        this.close();
                        break block93;
                    }
                    if (this.myLastStatus.getCode() == 401) {
                        ++authAttempts;
                        List<String> authHeaderValues = request.getResponseHeader().getHeaderValues("WWW-Authenticate");
                        if (authHeaderValues == null || authHeaderValues.size() == 0) {
                            err = request.getErrorMessage();
                            this.myLastStatus.setError(SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, err.getMessageTemplate(), err.getRelatedObjects()));
                            if ("LOCK".equalsIgnoreCase(method)) {
                                this.myLastStatus.getError().setChildErrorMessage(SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Probably you are trying to lock file in repository that only allows anonymous access"));
                            }
                            SVNErrorManager.error(this.myLastStatus.getError(), SVNLogType.NETWORK);
                            return this.myLastStatus;
                        }
                        boolean skip = false;
                        boolean bl2 = isAuthForced = authManager != null ? authManager.isAuthenticationForced() : false;
                        if (isAuthForced && httpAuth != null && this.myChallengeCredentials != null && !HTTPAuthentication.isSchemeSupportedByServer(this.myChallengeCredentials.getAuthenticationScheme(), authHeaderValues)) {
                            skip = true;
                        }
                        Collection<String> authTypes = null;
                        if (authManager != null && authManager instanceof DefaultSVNAuthenticationManager) {
                            DefaultSVNAuthenticationManager defaultAuthManager = (DefaultSVNAuthenticationManager)authManager;
                            authTypes = defaultAuthManager.getAuthTypes(this.myRepository.getLocation());
                        }
                        try {
                            this.myChallengeCredentials = HTTPAuthentication.parseAuthParameters(authHeaderValues, this.myChallengeCredentials, this.myCharset, authTypes, authManager, this.myRequestCount);
                        }
                        catch (SVNException svne) {
                            err = svne.getErrorMessage();
                            break block93;
                        }
                        this.myChallengeCredentials.setChallengeParameter("method", method);
                        this.myChallengeCredentials.setChallengeParameter("uri", HTTPParser.getCanonicalPath(path, null).toString());
                        if (skip) {
                            this.close();
                            continue;
                        }
                        HTTPNTLMAuthentication ntlmAuth = null;
                        HTTPNegotiateAuthentication negoAuth = null;
                        if (this.myChallengeCredentials instanceof HTTPNTLMAuthentication) {
                            ntlmAuthIsRequired = true;
                            ntlmAuth = (HTTPNTLMAuthentication)this.myChallengeCredentials;
                            if (ntlmAuth.isInType3State()) {
                                continue;
                            }
                        } else if (this.myChallengeCredentials instanceof HTTPDigestAuthentication) {
                            if (this.myLastValidAuth != null) {
                                this.clearLastValidAuth();
                                continue;
                            }
                        } else if (this.myChallengeCredentials instanceof HTTPNegotiateAuthentication) {
                            negoAuthIsRequired = true;
                            negoAuth = (HTTPNegotiateAuthentication)this.myChallengeCredentials;
                            if (negoAuth.isStarted()) continue;
                        }
                        this.clearLastValidAuth();
                        if (ntlmAuth != null && authAttempts == 1) {
                            if (!ntlmAuth.allowPropmtForCredentials()) continue;
                            httpAuth = null;
                        }
                        if (negoAuth != null) {
                            if (!negoAuth.needsLogin()) continue;
                            httpAuth = null;
                        }
                        if (authManager == null) {
                            err = request.getErrorMessage();
                            break block93;
                        }
                        realm = this.myChallengeCredentials.getChallengeParameter("realm");
                        realm = realm == null ? "" : " " + realm;
                        realm = this.composeRealm(realm);
                        if (httpAuth == null) {
                            httpAuth = authManager.getFirstAuthentication("svn.simple", realm, this.myRepository.getLocation());
                        } else if (authAttempts >= requestAttempts) {
                            BasicAuthenticationManager.acknowledgeAuthentication(false, "svn.simple", realm, request.getErrorMessage(), httpAuth, this.myRepository.getLocation(), authManager);
                            httpAuth = authManager.getNextAuthentication("svn.simple", realm, this.myRepository.getLocation());
                        }
                        if (httpAuth == null) {
                            err = SVNErrorMessage.create(SVNErrorCode.CANCELLED, new SVNCancelException(SVNErrorMessage.create(SVNErrorCode.CANCELLED, "ISVNAuthentication provider did not provide credentials; HTTP authorization cancelled.")));
                            break block93;
                        }
                        if (httpAuth == null) continue;
                        this.myChallengeCredentials.setCredentials((SVNPasswordAuthentication)httpAuth);
                        continue;
                    }
                    if (this.myLastStatus.getCode() != 301 && this.myLastStatus.getCode() != 302) break;
                    String newLocation = request.getResponseHeader().getFirstHeaderValue("Location");
                    if (newLocation != null) {
                        String newPath;
                        int hostIndex = newLocation.indexOf("://");
                        if (hostIndex > 0) {
                            hostIndex += 3;
                            hostIndex = newLocation.indexOf("/", hostIndex);
                        }
                        if (hostIndex > 0 && hostIndex < newLocation.length() && (newPath = newLocation.substring(hostIndex)).endsWith("/") && !newPath.endsWith("//") && !path.endsWith("/") && newPath.substring(0, newPath.length() - 1).equals(path)) {
                            path = path + "//";
                            continue;
                        }
                    }
                    break block94;
                    break;
                }
                if (request.getErrorMessage() != null) {
                    err = request.getErrorMessage();
                } else {
                    ntlmProxyAuthIsRequired = false;
                    ntlmAuthIsRequired = false;
                    negoAuthIsRequired = false;
                }
            }
            if (err == null) {
                if (this.myIsProxied && proxyManager != null) {
                    proxyManager.acknowledgeProxyContext(true, null);
                }
                if (httpAuth != null && realm != null && authManager != null) {
                    BasicAuthenticationManager.acknowledgeAuthentication(true, "svn.simple", realm, null, httpAuth, this.myRepository.getLocation(), authManager);
                }
                if (trustManager != null && authManager != null) {
                    authManager.acknowledgeTrustManager(trustManager);
                }
                if (httpAuth != null) {
                    this.myLastValidAuth = httpAuth.copy();
                }
                if (this.myLastStatus.getCodeClass() == 2 && authManager instanceof ISVNAuthenticationManagerExt) {
                    ((ISVNAuthenticationManagerExt)authManager).acknowledgeConnectionSuccessful(this.myRepository.getLocation(), method);
                }
                this.myLastStatus.setHeader(request.getResponseHeader());
                return this.myLastStatus;
            }
        }
        this.close();
        if (err != null && err.getErrorCode().getCategory() != 175000 && err.getErrorCode() != SVNErrorCode.UNSUPPORTED_FEATURE) {
            SVNErrorManager.error(err, SVNLogType.NETWORK);
        }
        this.myRepository.getDebugLog().logFine(SVNLogType.NETWORK, new Exception(err.getMessage()));
        SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "{0} request failed on ''{1}''", new Object[]{method, path}, err.getType(), err.getCause());
        SVNErrorManager.error(err, err2, SVNLogType.NETWORK);
        return null;
    }

    private String composeRealm(String realm) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<");
        buffer.append(this.myHost.getProtocol());
        buffer.append("://");
        if (this.myHost.getUserInfo() != null && !"".equals(this.myHost.getUserInfo().trim())) {
            buffer.append(this.myHost.getUserInfo());
            buffer.append("@");
        }
        buffer.append(this.myHost.getHost());
        buffer.append(":");
        buffer.append(this.myHost.getPort());
        buffer.append(">");
        if (realm != null) {
            buffer.append(realm);
        }
        return buffer.toString();
    }

    private boolean isClearCredentialsOnClose(HTTPAuthentication auth) {
        return !(auth instanceof HTTPBasicAuthentication) && !(auth instanceof HTTPDigestAuthentication) && !(auth instanceof HTTPNegotiateAuthentication);
    }

    private HTTPSSLKeyManager createKeyManager() {
        if (!this.myIsSecured) {
            return null;
        }
        SVNURL location = this.myRepository.getLocation();
        ISVNAuthenticationManager authManager = this.myRepository.getAuthenticationManager();
        String sslRealm = "<" + location.getProtocol() + "://" + location.getHost() + ":" + location.getPort() + ">";
        return new HTTPSSLKeyManager(authManager, sslRealm, location);
    }

    public SVNErrorMessage readData(HTTPRequest request, OutputStream dst) throws IOException {
        InputStream stream = this.createInputStream(request.getResponseHeader(), this.getInputStream());
        byte[] buffer = this.getBuffer();
        boolean willCloseConnection = false;
        try {
            int count;
            while ((count = stream.read(buffer)) >= 0) {
                if (dst == null) continue;
                dst.write(buffer, 0, count);
            }
        }
        catch (IOException e) {
            willCloseConnection = true;
            if (e instanceof IOExceptionWrapper) {
                IOExceptionWrapper wrappedException = (IOExceptionWrapper)e;
                SVNErrorMessage sVNErrorMessage = wrappedException.getOriginalException().getErrorMessage();
                return sVNErrorMessage;
            }
            if (e.getCause() instanceof SVNException) {
                SVNErrorMessage sVNErrorMessage = ((SVNException)e.getCause()).getErrorMessage();
                return sVNErrorMessage;
            }
            throw e;
        }
        finally {
            if (!willCloseConnection) {
                SVNFileUtil.closeFile(stream);
            }
            this.myRepository.getDebugLog().flushStream(stream);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public SVNErrorMessage readData(HTTPRequest request, String method, String path, DefaultHandler handler) throws IOException {
        block27: {
            block24: {
                block22: {
                    block25: {
                        block23: {
                            is = null;
                            tmpFile = null;
                            err = null;
                            if (!this.myIsSpoolResponse && !this.myIsSpoolAll) ** GOTO lbl41
                            dst = null;
                            tmpFile = new SpoolFile(this.mySpoolDirectory);
                            dst = tmpFile.openForWriting();
                            dst = new SVNCancellableOutputStream(dst, this.myRepository.getCanceller());
                            err = this.readData(request, dst);
                            SVNFileUtil.closeFile(dst);
                            dst = null;
                            if (err == null) break block22;
                            var9_11 = err;
                            SVNFileUtil.closeFile(dst);
                            if (!this.myIsSpoolResponse && !this.myIsSpoolAll) break block23;
                            SVNFileUtil.closeFile(is);
                            break block25;
                        }
                        if (err == null && !HTTPConnection.hasToCloseConnection(request.getResponseHeader())) {
                            SVNFileUtil.closeFile(is);
                        }
                    }
                    if (tmpFile != null) {
                        try {
                            tmpFile.delete();
                        }
                        catch (SVNException e) {
                            throw new IOException(e.getMessage());
                        }
                    }
                    this.myIsSpoolResponse = false;
                    return var9_11;
                }
                try {
                    block26: {
                        is = tmpFile.openForReading();
                        {
                            catch (Throwable var11_13) {
                                SVNFileUtil.closeFile(dst);
                                throw var11_13;
                            }
                        }
                        SVNFileUtil.closeFile(dst);
                        break block26;
lbl41:
                        // 1 sources

                        is = this.createInputStream(request.getResponseHeader(), this.getInputStream());
                    }
                    err = this.readData(is, method, path, handler);
                    if (!this.myIsSpoolResponse && !this.myIsSpoolAll) break block24;
                }
                catch (IOException e) {
                    try {
                        throw e;
                    }
                    catch (Throwable var12_14) {
                        if (this.myIsSpoolResponse || this.myIsSpoolAll) {
                            SVNFileUtil.closeFile(is);
                        } else if (err == null && !HTTPConnection.hasToCloseConnection(request.getResponseHeader())) {
                            SVNFileUtil.closeFile(is);
                        }
                        if (tmpFile != null) {
                            try {
                                tmpFile.delete();
                            }
                            catch (SVNException e) {
                                throw new IOException(e.getMessage());
                            }
                        }
                        this.myIsSpoolResponse = false;
                        throw var12_14;
                    }
                }
                SVNFileUtil.closeFile(is);
                break block27;
            }
            if (err == null && !HTTPConnection.hasToCloseConnection(request.getResponseHeader())) {
                SVNFileUtil.closeFile(is);
            }
        }
        if (tmpFile != null) {
            try {
                tmpFile.delete();
            }
            catch (SVNException e) {
                throw new IOException(e.getMessage());
            }
        }
        this.myIsSpoolResponse = false;
        return err;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SVNErrorMessage readData(InputStream is, String method, String path, DefaultHandler handler) throws FactoryConfigurationError, UnsupportedEncodingException, IOException {
        try {
            if (this.mySAXParser == null) {
                this.mySAXParser = HTTPConnection.getSAXParserFactory().newSAXParser();
            }
            XMLReader reader = new XMLReader(is);
            while (!reader.isClosed()) {
                org.xml.sax.XMLReader xmlReader = this.mySAXParser.getXMLReader();
                xmlReader.setContentHandler(handler);
                xmlReader.setDTDHandler(handler);
                xmlReader.setErrorHandler(handler);
                xmlReader.setEntityResolver(NO_ENTITY_RESOLVER);
                xmlReader.parse(new InputSource(reader));
            }
        }
        catch (SAXException e) {
            this.mySAXParser = null;
            if (e instanceof SAXParseException) {
                if (handler instanceof DAVErrorHandler) {
                    SVNErrorMessage sVNErrorMessage = null;
                    return sVNErrorMessage;
                }
            } else {
                if (e.getException() instanceof SVNException) {
                    SVNErrorMessage sVNErrorMessage = ((SVNException)e.getException()).getErrorMessage();
                    return sVNErrorMessage;
                }
                if (e.getCause() instanceof SVNException) {
                    SVNErrorMessage sVNErrorMessage = ((SVNException)e.getCause()).getErrorMessage();
                    return sVNErrorMessage;
                }
            }
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "Processing {0} request response failed: {1} ({2}) ", method, e.getMessage(), path);
            return sVNErrorMessage;
        }
        catch (ParserConfigurationException e) {
            this.mySAXParser = null;
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "XML parser configuration error while processing {0} request response: {1} ({2}) ", method, e.getMessage(), path);
            return sVNErrorMessage;
        }
        catch (EOFException e) {
        }
        finally {
            if (this.mySAXParser != null) {
                org.xml.sax.XMLReader xmlReader = null;
                try {
                    xmlReader = this.mySAXParser.getXMLReader();
                }
                catch (SAXException sAXException) {}
                if (xmlReader != null) {
                    xmlReader.setContentHandler(DEFAULT_SAX_HANDLER);
                    xmlReader.setDTDHandler(DEFAULT_SAX_HANDLER);
                    xmlReader.setErrorHandler(DEFAULT_SAX_HANDLER);
                    xmlReader.setEntityResolver(NO_ENTITY_RESOLVER);
                }
            }
            this.myRepository.getDebugLog().flushStream(is);
        }
        return null;
    }

    public void skipData(HTTPRequest request) throws IOException {
        if (HTTPConnection.hasToCloseConnection(request.getResponseHeader())) {
            return;
        }
        InputStream is = this.createInputStream(request.getResponseHeader(), this.getInputStream());
        while (is.skip(2048L) > 0L) {
        }
    }

    @Override
    public void close() {
        if (this.isClearCredentialsOnClose(this.myChallengeCredentials)) {
            this.clearAuthenticationCache();
        } else {
            this.clearLastValidAuth();
        }
        if (this.mySocket != null) {
            if (this.myInputStream != null) {
                try {
                    this.myInputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.myOutputStream != null) {
                try {
                    this.myOutputStream.flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.myOutputStream != null) {
                try {
                    this.myOutputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            try {
                this.mySocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.mySocket = null;
            this.myOutputStream = null;
            this.myInputStream = null;
        }
    }

    private byte[] getBuffer() {
        if (this.myBuffer == null) {
            this.myBuffer = new byte[32768];
        }
        return this.myBuffer;
    }

    private InputStream getInputStream() throws IOException {
        if (this.myInputStream == null) {
            if (this.mySocket == null) {
                return null;
            }
            this.myInputStream = new BufferedInputStream(this.mySocket.getInputStream(), 2048);
        }
        return this.myInputStream;
    }

    private OutputStream getOutputStream() throws IOException {
        SVNDebugLog.getDefaultLog().logFine(SVNLogType.DEFAULT, "socket output stream requested...");
        if (this.myOutputStream == null) {
            if (this.mySocket == null) {
                return null;
            }
            this.myOutputStream = new BufferedOutputStream(this.mySocket.getOutputStream(), 2048);
            this.myOutputStream = this.myRepository.getDebugLog().createLogStream(SVNLogType.NETWORK, this.myOutputStream);
        }
        return this.myOutputStream;
    }

    private void finishResponse(HTTPRequest request) {
        HTTPHeader header;
        if (this.myOutputStream != null) {
            try {
                this.myOutputStream.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        HTTPHeader hTTPHeader = header = request != null ? request.getResponseHeader() : null;
        if (HTTPConnection.hasToCloseConnection(header)) {
            this.close();
        }
    }

    private static boolean hasToCloseConnection(HTTPHeader header) {
        if (header == null) {
            return true;
        }
        String connectionHeader = header.getFirstHeaderValue("Connection");
        String proxyHeader = header.getFirstHeaderValue("Proxy-Connection");
        if (connectionHeader != null && connectionHeader.toLowerCase().indexOf("close") >= 0) {
            return true;
        }
        return proxyHeader != null && proxyHeader.toLowerCase().indexOf("close") >= 0;
    }

    private InputStream createInputStream(HTTPHeader readHeader, InputStream is) throws IOException {
        if ("chunked".equalsIgnoreCase(readHeader.getFirstHeaderValue("Transfer-Encoding"))) {
            is = new ChunkedInputStream(is, this.myCharset);
        } else if (readHeader.getFirstHeaderValue("Content-Length") != null) {
            String lengthStr = readHeader.getFirstHeaderValue("Content-Length");
            long length = 0L;
            try {
                length = Long.parseLong(lengthStr);
            }
            catch (NumberFormatException nfe) {
                length = 0L;
            }
            is = new FixedSizeInputStream(is, length);
        } else if (!HTTPConnection.hasToCloseConnection(readHeader)) {
            is = new FixedSizeInputStream(is, 0L);
            readHeader.setHeaderValue("Connection", "close");
        }
        if ("gzip".equals(readHeader.getFirstHeaderValue("Content-Encoding"))) {
            is = new GZIPInputStream(is);
        }
        return this.myRepository.getDebugLog().createLogStream(SVNLogType.NETWORK, is);
    }

    private static synchronized SAXParserFactory getSAXParserFactory() throws FactoryConfigurationError {
        if (ourSAXParserFactory == null) {
            ourSAXParserFactory = HTTPConnection.createSAXParserFactory();
            HashMap<String, Boolean> supportedFeatures = new HashMap<String, Boolean>();
            try {
                ourSAXParserFactory.setFeature("http://xml.org/sax/features/namespaces", true);
                supportedFeatures.put("http://xml.org/sax/features/namespaces", Boolean.TRUE);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
            }
            catch (ParserConfigurationException parserConfigurationException) {
                // empty catch block
            }
            try {
                ourSAXParserFactory.setFeature("http://xml.org/sax/features/validation", false);
                supportedFeatures.put("http://xml.org/sax/features/validation", Boolean.FALSE);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
            }
            catch (ParserConfigurationException parserConfigurationException) {
                // empty catch block
            }
            try {
                ourSAXParserFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                supportedFeatures.put("http://apache.org/xml/features/nonvalidating/load-external-dtd", Boolean.FALSE);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
            }
            catch (ParserConfigurationException parserConfigurationException) {
                // empty catch block
            }
            if (supportedFeatures.size() < 3) {
                ourSAXParserFactory = HTTPConnection.createSAXParserFactory();
                for (String name : supportedFeatures.keySet()) {
                    try {
                        ourSAXParserFactory.setFeature(name, supportedFeatures.get(name) == Boolean.TRUE);
                    }
                    catch (SAXNotRecognizedException sAXNotRecognizedException) {
                    }
                    catch (SAXNotSupportedException sAXNotSupportedException) {
                    }
                    catch (ParserConfigurationException parserConfigurationException) {}
                }
            }
            ourSAXParserFactory.setNamespaceAware(true);
            ourSAXParserFactory.setValidating(false);
        }
        return ourSAXParserFactory;
    }

    public static SAXParserFactory createSAXParserFactory() {
        String legacy = System.getProperty("svnkit.sax.useDefault");
        if (legacy == null || !Boolean.valueOf(legacy).booleanValue()) {
            return SAXParserFactory.newInstance();
        }
        String[] parsers = new String[]{"com.sun.org.apache.xerces.internal.jaxp.SAXParserFactoryImpl", "org.apache.crimson.jaxp.SAXParserFactoryImpl"};
        for (int i = 0; i < parsers.length; ++i) {
            String className = parsers[i];
            ClassLoader loader = HTTPConnection.class.getClassLoader();
            try {
                Object factory;
                Class<?> clazz = null;
                clazz = loader != null ? loader.loadClass(className) : Class.forName(className);
                if (clazz == null || !((factory = clazz.newInstance()) instanceof SAXParserFactory)) continue;
                return (SAXParserFactory)factory;
            }
            catch (ClassNotFoundException classNotFoundException) {
                continue;
            }
            catch (InstantiationException instantiationException) {
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return SAXParserFactory.newInstance();
    }

    @Override
    public void setSpoolResponse(boolean spoolResponse) {
        this.myIsSpoolResponse = spoolResponse;
    }

    public void setSpoolAll(boolean spoolAll) {
        this.myIsSpoolAll = spoolAll;
    }

    public void setSpoolDirectory(File spoolDirectory) {
        this.mySpoolDirectory = spoolDirectory;
    }

    static {
        String attemptsString = System.getProperty("svnkit.http.requestAttempts", "1");
        int attempts = 1;
        try {
            attempts = Integer.parseInt(attemptsString);
        }
        catch (NumberFormatException nfe) {
            attempts = 1;
        }
        if (attempts <= 0) {
            attempts = 1;
        }
        requestAttempts = attempts;
        emptyHeader = Collections.unmodifiableMap(Collections.emptyMap());
    }
}

