/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.svn;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.util.List;
import java.util.Set;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.BasicAuthenticationManager;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManagerExt;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.internal.io.svn.ISVNConnector;
import org.tmatesoft.svn.core.internal.io.svn.SVNAuthenticator;
import org.tmatesoft.svn.core.internal.io.svn.SVNItem;
import org.tmatesoft.svn.core.internal.io.svn.SVNReader;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryImpl;
import org.tmatesoft.svn.core.internal.io.svn.SVNWriter;
import org.tmatesoft.svn.core.internal.util.SVNHashSet;
import org.tmatesoft.svn.core.internal.wc.SVNClassLoader;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNConnection {
    private final ISVNConnector myConnector;
    private String myRealm;
    private String myRoot;
    private OutputStream myOutputStream;
    private InputStream myInputStream;
    private SVNRepositoryImpl myRepository;
    private boolean myIsSVNDiff1;
    private boolean myIsCommitRevprops;
    private boolean myIsReopening = false;
    private boolean myIsCredentialsReceived = false;
    private InputStream myLoggingInputStream;
    private Set myCapabilities;
    private byte[] myHandshakeBuffer = new byte[8192];
    private SVNAuthenticator myEncryptor;
    private SVNAuthentication myAuthentication;
    private static final String EDIT_PIPELINE = "edit-pipeline";
    private static final String SVNDIFF1 = "svndiff1";
    private static final String ABSENT_ENTRIES = "absent-entries";
    private static final String COMMIT_REVPROPS = "commit-revprops";
    private static final String MERGE_INFO = "mergeinfo";
    private static final String DEPTH = "depth";
    private static final String LOG_REVPROPS = "log-revprops";

    public SVNConnection(ISVNConnector connector, SVNRepositoryImpl repository) {
        this.myConnector = connector;
        this.myRepository = repository;
    }

    public void open(SVNRepositoryImpl repository) throws SVNException {
        this.myIsReopening = true;
        try {
            this.myIsCredentialsReceived = false;
            this.myConnector.open(repository);
            this.myRepository = repository;
            try {
                this.handshake(repository);
            }
            catch (SVNException th) {
                this.myConnector.handleExceptionOnOpen(repository, th);
            }
        }
        finally {
            this.myIsReopening = false;
        }
    }

    public String getRealm() {
        return this.myRealm;
    }

    public boolean isSVNDiff1() {
        return this.myIsSVNDiff1;
    }

    public boolean isCommitRevprops() {
        return this.myIsCommitRevprops;
    }

    private InputStream skipLeadingGrabage(int attempt) throws SVNException {
        SVNErrorMessage err;
        byte[] bytes = this.myHandshakeBuffer;
        int r = 0;
        try {
            r = this.getInputStream().read(bytes);
        }
        catch (IOException e) {
            SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA, "Handshake failed: ''{0}''", (Object)e.getMessage());
            SVNErrorManager.error(err2, SVNLogType.NETWORK);
        }
        if (r >= 0) {
            for (int i = 0; i < r; ++i) {
                if (bytes[i] != 40 || bytes[i + 1] != 32) continue;
                return new SequenceInputStream(new ByteArrayInputStream(bytes, i, r - i), this.getInputStream());
            }
        }
        if (r >= 0 && attempt == 0) {
            return this.skipLeadingGrabage(attempt + 1);
        }
        if (r <= 0) {
            err = SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA, "Handshake failed, data stream ended unexpectedly");
            SVNErrorManager.error(err, SVNLogType.NETWORK);
        }
        err = SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA, "Handshake failed, received: ''{0}''", (Object)new String(bytes, 0, r));
        SVNErrorManager.error(err, SVNLogType.NETWORK);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handshake(SVNRepositoryImpl repository) throws SVNException {
        this.checkConnection();
        InputStream is = this.skipLeadingGrabage(0);
        List items = null;
        try {
            items = SVNReader.parse(is, "nnll", null);
        }
        finally {
            this.myRepository.getDebugLog().flushStream(this.myLoggingInputStream);
        }
        Long minVer = (Long)items.get(0);
        Long maxVer = (Long)items.get(1);
        if (minVer > 2L) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_SVN_BAD_VERSION, "Server requires minimum version {0}", (Object)minVer), SVNLogType.NETWORK);
        } else if (maxVer < 2L) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_SVN_BAD_VERSION, "Server requires maximum version {0}", (Object)maxVer), SVNLogType.NETWORK);
        }
        List capabilities = (List)items.get(3);
        this.addCapabilities(capabilities);
        if (!this.hasCapability(EDIT_PIPELINE)) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_SVN_BAD_VERSION, "Server does not support edit pipelining"), SVNLogType.NETWORK);
        }
        this.myIsSVNDiff1 = SVNReader.hasValue(items, 3, SVNDIFF1);
        this.myIsCommitRevprops = SVNReader.hasValue(items, 3, COMMIT_REVPROPS);
        this.write("(n(wwwwww)s)", new Object[]{"2", EDIT_PIPELINE, SVNDIFF1, ABSENT_ENTRIES, DEPTH, MERGE_INFO, LOG_REVPROPS, repository.getLocation().toString()});
    }

    protected boolean hasCapability(String capability) {
        if (this.myCapabilities != null) {
            return this.myCapabilities.contains(capability);
        }
        return false;
    }

    public void authenticate(SVNRepositoryImpl repository) throws SVNException {
        List items;
        ISVNAuthenticationManager authManager = this.myRepository.getAuthenticationManager();
        try {
            items = this.read("ls", null, true);
        }
        catch (SVNException ex) {
            SVNErrorMessage errorMessage = ex.getErrorMessage();
            if (errorMessage != null && errorMessage.getErrorCode() == SVNErrorCode.RA_NOT_AUTHORIZED && authManager != null && this.myAuthentication != null) {
                BasicAuthenticationManager.acknowledgeAuthentication(false, "svn.simple", this.myRealm, errorMessage, this.myAuthentication, repository.getLocation(), authManager);
            }
            throw ex;
        }
        List mechs = SVNReader.getList(items, 0);
        if (mechs == null || mechs.size() == 0) {
            if (authManager instanceof ISVNAuthenticationManagerExt) {
                ((ISVNAuthenticationManagerExt)authManager).acknowledgeConnectionSuccessful(this.myRepository.getLocation(), "");
            }
            return;
        }
        this.myRealm = SVNReader.getString(items, 1);
        if (authManager != null && authManager.isAuthenticationForced() && mechs.contains("ANONYMOUS") && (mechs.contains("CRAM-MD5") || mechs.contains("DIGEST-MD5"))) {
            mechs.remove("ANONYMOUS");
        }
        SVNAuthenticator authenticator = this.createSASLAuthenticator();
        this.myAuthentication = authenticator.authenticate(mechs, this.myRealm, repository);
        this.receiveRepositoryCredentials(repository);
        if (authManager instanceof ISVNAuthenticationManagerExt) {
            ((ISVNAuthenticationManagerExt)authManager).acknowledgeConnectionSuccessful(this.myRepository.getLocation(), "");
        }
    }

    private SVNAuthenticator createSASLAuthenticator() throws SVNException {
        return SVNClassLoader.getSASLAuthenticator(this);
    }

    private void addCapabilities(List capabilities) throws SVNException {
        if (this.myCapabilities == null) {
            this.myCapabilities = new SVNHashSet();
        }
        if (capabilities == null || capabilities.isEmpty()) {
            return;
        }
        for (SVNItem item : capabilities) {
            if (item.getKind() != 0) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA, "Capability entry is not a word");
                SVNErrorManager.error(err, SVNLogType.NETWORK);
            }
            this.myCapabilities.add(item.getWord());
        }
    }

    private void receiveRepositoryCredentials(SVNRepositoryImpl repository) throws SVNException {
        if (this.myIsCredentialsReceived) {
            return;
        }
        List creds = this.read("s?s?l", null, true);
        this.myIsCredentialsReceived = true;
        if (creds != null && creds.size() >= 2 && creds.get(0) != null && creds.get(1) != null) {
            SVNURL rootURL;
            SVNURL sVNURL = rootURL = creds.get(1) != null ? SVNURL.parseURIEncoded(SVNReader.getString(creds, 1)) : null;
            if (rootURL != null && rootURL.toString().length() > repository.getLocation().toString().length()) {
                SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_SVN_MALFORMED_DATA, "Impossibly long repository root from server"), SVNLogType.NETWORK);
            }
            if (repository != null && repository.getRepositoryRoot(false) == null) {
                repository.updateCredentials(SVNReader.getString(creds, 0), rootURL);
            }
            if (this.myRealm == null) {
                this.myRealm = SVNReader.getString(creds, 0);
            }
            if (this.myRoot == null) {
                this.myRoot = SVNReader.getString(creds, 1);
            }
            if (creds.size() > 2 && creds.get(2) instanceof List) {
                List capabilities = (List)creds.get(2);
                this.addCapabilities(capabilities);
            }
        }
    }

    public void setEncrypted(SVNAuthenticator encryptor) {
        this.myEncryptor = encryptor;
    }

    public boolean isEncrypted() {
        return this.myEncryptor != null;
    }

    public void close() throws SVNException {
        if (this.myEncryptor != null) {
            this.myEncryptor.dispose();
            this.myEncryptor = null;
        }
        this.myInputStream = null;
        this.myLoggingInputStream = null;
        this.myOutputStream = null;
        this.myConnector.close(this.myRepository);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List read(String template, List items, boolean readMalformedData) throws SVNException {
        try {
            this.checkConnection();
            List list = SVNReader.parse(this.getInputStream(), template, items);
            return list;
        }
        catch (SVNException e) {
            this.handleIOError(e, readMalformedData);
            List list = null;
            return list;
        }
        finally {
            this.myRepository.getDebugLog().flushStream(this.myLoggingInputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List readTuple(String template, boolean readMalformedData) throws SVNException {
        try {
            this.checkConnection();
            List list = SVNReader.readTuple(this.getInputStream(), template);
            return list;
        }
        catch (SVNException e) {
            this.handleIOError(e, readMalformedData);
            List list = null;
            return list;
        }
        finally {
            this.myRepository.getDebugLog().flushStream(this.myLoggingInputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SVNItem readItem(boolean readMalformedData) throws SVNException {
        try {
            this.checkConnection();
            SVNItem sVNItem = SVNReader.readItem(this.getInputStream());
            return sVNItem;
        }
        catch (SVNException e) {
            this.handleIOError(e, readMalformedData);
            SVNItem sVNItem = null;
            return sVNItem;
        }
        finally {
            this.myRepository.getDebugLog().flushStream(this.myLoggingInputStream);
        }
    }

    private void handleIOError(SVNException e, boolean readMalformedData) throws SVNException {
        if (readMalformedData && e.getErrorMessage().getErrorCode() == SVNErrorCode.RA_SVN_MALFORMED_DATA) {
            byte[] malfored = new byte[1024];
            try {
                this.getInputStream().read(malfored);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        throw e;
    }

    public void writeError(SVNErrorMessage error) throws SVNException {
        Object[] buffer = new Object[]{"failure"};
        this.write("(w(", buffer);
        while (error != null) {
            String message = error.getMessage() == null ? "" : error.getMessage();
            buffer = new Object[]{new Long(error.getErrorCode().getCode()), message, "", new Integer(0)};
            this.write("(nssn)", buffer);
            error = error.getChildErrorMessage();
        }
        this.write(")", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String template, Object[] items) throws SVNException {
        try {
            SVNWriter.write(this.getOutputStream(), template, items);
        }
        finally {
            try {
                this.getOutputStream().flush();
            }
            catch (IOException iOException) {
            }
            catch (SVNException sVNException) {}
            this.myRepository.getDebugLog().flushStream(this.getOutputStream());
        }
    }

    public boolean isConnectionStale() {
        return this.myConnector.isStale();
    }

    private void checkConnection() throws SVNException {
        if (!this.myIsReopening && !this.myConnector.isConnected(this.myRepository)) {
            this.myIsReopening = true;
            try {
                this.close();
                this.open(this.myRepository);
            }
            finally {
                this.myIsReopening = false;
            }
        }
    }

    public OutputStream getDeltaStream(final String token) {
        return new OutputStream(){
            Object[] myPrefix;
            {
                this.myPrefix = new Object[]{"textdelta-chunk", token};
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                try {
                    SVNConnection.this.write("(w(s", this.myPrefix);
                    SVNConnection.this.getOutputStream().write(String.valueOf(len).getBytes("UTF-8"));
                    SVNConnection.this.getOutputStream().write(58);
                    SVNConnection.this.getOutputStream().write(b, off, len);
                    SVNConnection.this.getOutputStream().write(32);
                    SVNConnection.this.write("))", null);
                }
                catch (SVNException e) {
                    throw new IOException(e.getMessage());
                }
            }

            @Override
            public void write(byte[] b) throws IOException {
                this.write(b, 0, b.length);
            }

            @Override
            public void write(int b) throws IOException {
                this.write(new byte[]{(byte)(b & 0xFF)});
            }
        };
    }

    OutputStream getOutputStream() throws SVNException {
        if (this.myOutputStream == null) {
            try {
                this.myOutputStream = this.myRepository.getDebugLog().createLogStream(SVNLogType.NETWORK, this.myConnector.getOutputStream());
            }
            catch (IOException e) {
                SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_SVN_IO_ERROR, e.getMessage()), e, SVNLogType.NETWORK);
            }
        }
        return this.myOutputStream;
    }

    InputStream getInputStream() throws SVNException {
        if (this.myInputStream == null) {
            try {
                InputStream is = this.myConnector.getInputStream();
                this.myLoggingInputStream = this.myInputStream = this.myRepository.getDebugLog().createLogStream(SVNLogType.NETWORK, is);
            }
            catch (IOException e) {
                SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_SVN_IO_ERROR, e.getMessage()), e, SVNLogType.NETWORK);
            }
        }
        return this.myInputStream;
    }

    void setOutputStream(OutputStream os) {
        if (this.myOutputStream != null) {
            this.myRepository.getDebugLog().flushStream(this.myOutputStream);
        }
        this.myOutputStream = os;
    }

    void setInputStream(InputStream is) {
        if (this.myLoggingInputStream != null) {
            this.myRepository.getDebugLog().flushStream(this.myLoggingInputStream);
        }
        this.myInputStream = is;
        this.myLoggingInputStream = is;
    }

    ISVNConnector getConnector() {
        return this.myConnector;
    }
}

