/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.util;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.util.logging.Level;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.util.SVNFLock;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNDoubleLock {
    private static boolean ourUseDoubleLock = Boolean.valueOf(System.getProperty("svnkit.useDoubleLock", Boolean.valueOf(SVNFileUtil.isLinux).toString()));
    private SVNFLock flock;
    private RandomAccessFile randomAccessFile;
    private FileLock posixLock;
    private final File file;
    private final boolean exclusive;
    private boolean valid;

    public static SVNDoubleLock obtain(File file, boolean exclusive) throws SVNException {
        SVNFLock flock = ourUseDoubleLock ? SVNFLock.obtain(file, exclusive) : null;
        RandomAccessFile randomAccessFile = null;
        FileLock posixLock = null;
        try {
            randomAccessFile = new RandomAccessFile(file, "rw");
            posixLock = randomAccessFile.getChannel().lock(0L, Long.MAX_VALUE, !exclusive);
        }
        catch (IOException e) {
            if (flock != null) {
                flock.release();
            }
            SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e);
            SVNErrorManager.error(errorMessage, SVNLogType.DEFAULT);
        }
        return new SVNDoubleLock(flock, randomAccessFile, posixLock, file, exclusive);
    }

    private SVNDoubleLock(SVNFLock flock, RandomAccessFile randomAccessFile, FileLock posixLock, File file, boolean exclusive) {
        this.flock = flock;
        this.randomAccessFile = randomAccessFile;
        this.posixLock = posixLock;
        this.file = file;
        this.exclusive = exclusive;
        this.valid = true;
    }

    public void release() {
        try {
            if (this.posixLock != null) {
                this.posixLock.release();
                this.posixLock = null;
            }
            if (this.randomAccessFile != null) {
                this.randomAccessFile.close();
                this.randomAccessFile = null;
            }
            if (this.flock != null) {
                this.flock.release();
                this.flock = null;
            }
            this.valid = false;
        }
        catch (IOException e) {
            SVNDebugLog.getDefaultLog().log(SVNLogType.DEFAULT, e, Level.INFO);
        }
    }

    public String toString() {
        if (!this.valid) {
            return "SVNDoubleLock{file=" + this.file + ", valid = false, exclusive=" + this.exclusive + "}";
        }
        return "SVNDoubleLock{" + (this.flock != null ? "flock=" + this.flock : "flock is not supported") + ", posixLock=" + this.posixLock + '}';
    }
}

