/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.blobstore;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.util.CollectionUtils;

public class BlobPath
implements Iterable<String> {
    private static final String SEPARATOR = "/";
    private final List<String> paths;

    public BlobPath() {
        this.paths = Collections.emptyList();
    }

    public static BlobPath cleanPath() {
        return new BlobPath();
    }

    private BlobPath(List<String> paths) {
        this.paths = paths;
    }

    @Override
    public Iterator<String> iterator() {
        return this.paths.iterator();
    }

    public String[] toArray() {
        return this.paths.toArray(new String[this.paths.size()]);
    }

    public BlobPath add(String path) {
        return new BlobPath(CollectionUtils.appendToCopy(this.paths, path));
    }

    public String buildAsString() {
        String p = String.join((CharSequence)SEPARATOR, this.paths);
        if (p.isEmpty() || p.endsWith(SEPARATOR)) {
            return p;
        }
        return p + SEPARATOR;
    }

    @Nullable
    public BlobPath parent() {
        if (this.paths.isEmpty()) {
            return null;
        }
        return new BlobPath(new ArrayList<String>(this.paths.subList(0, this.paths.size() - 1)));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (String path : this.paths) {
            sb.append('[').append(path).append(']');
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlobPath other = (BlobPath)o;
        return this.paths.equals(other.paths);
    }

    public int hashCode() {
        return Objects.hash(this.paths);
    }
}

