/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.snapshots;

import java.io.IOException;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.Version;
import org.elasticsearch.action.ShardOperationFailedException;
import org.elasticsearch.cluster.SnapshotsInProgress;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.snapshots.SnapshotFeatureInfo;
import org.elasticsearch.snapshots.SnapshotId;
import org.elasticsearch.snapshots.SnapshotShardFailure;
import org.elasticsearch.snapshots.SnapshotState;
import org.elasticsearch.snapshots.SnapshotsService;

public final class SnapshotInfo
implements Comparable<SnapshotInfo>,
ToXContent,
Writeable {
    public static final Version DATA_STREAMS_IN_SNAPSHOT = Version.V_7_9_0;
    public static final String CONTEXT_MODE_PARAM = "context_mode";
    public static final String CONTEXT_MODE_SNAPSHOT = "SNAPSHOT";
    public static final Version METADATA_FIELD_INTRODUCED = Version.V_7_3_0;
    private static final DateFormatter DATE_TIME_FORMATTER = DateFormatter.forPattern("strict_date_optional_time");
    private static final String SNAPSHOT = "snapshot";
    private static final String UUID = "uuid";
    private static final String INDICES = "indices";
    private static final String DATA_STREAMS = "data_streams";
    private static final String STATE = "state";
    private static final String REASON = "reason";
    private static final String START_TIME = "start_time";
    private static final String START_TIME_IN_MILLIS = "start_time_in_millis";
    private static final String END_TIME = "end_time";
    private static final String END_TIME_IN_MILLIS = "end_time_in_millis";
    private static final String DURATION = "duration";
    private static final String DURATION_IN_MILLIS = "duration_in_millis";
    private static final String FAILURES = "failures";
    private static final String SHARDS = "shards";
    private static final String TOTAL = "total";
    private static final String FAILED = "failed";
    private static final String SUCCESSFUL = "successful";
    private static final String VERSION_ID = "version_id";
    private static final String VERSION = "version";
    private static final String NAME = "name";
    private static final String TOTAL_SHARDS = "total_shards";
    private static final String SUCCESSFUL_SHARDS = "successful_shards";
    private static final String INCLUDE_GLOBAL_STATE = "include_global_state";
    private static final String USER_METADATA = "metadata";
    private static final String FEATURE_STATES = "feature_states";
    private static final Version INCLUDE_GLOBAL_STATE_INTRODUCED = Version.V_6_2_0;
    private static final Comparator<SnapshotInfo> COMPARATOR = Comparator.comparing(SnapshotInfo::startTime).thenComparing(SnapshotInfo::snapshotId);
    public static final ObjectParser<SnapshotInfoBuilder, Void> SNAPSHOT_INFO_PARSER = new ObjectParser(SnapshotInfoBuilder.class.getName(), true, SnapshotInfoBuilder::new);
    private static final ObjectParser<ShardStatsBuilder, Void> SHARD_STATS_PARSER = new ObjectParser(ShardStatsBuilder.class.getName(), true, () -> new ShardStatsBuilder());
    private final SnapshotId snapshotId;
    @Nullable
    private final SnapshotState state;
    @Nullable
    private final String reason;
    private final List<String> indices;
    private final List<String> dataStreams;
    private final List<SnapshotFeatureInfo> featureStates;
    private final long startTime;
    private final long endTime;
    private final int totalShards;
    private final int successfulShards;
    @Nullable
    private Boolean includeGlobalState;
    @Nullable
    private final Map<String, Object> userMetadata;
    @Nullable
    private final Version version;
    private final List<SnapshotShardFailure> shardFailures;

    public SnapshotInfo(SnapshotId snapshotId, List<String> indices, List<String> dataStreams, List<SnapshotFeatureInfo> featureStates, SnapshotState state) {
        this(snapshotId, indices, dataStreams, featureStates, null, null, 0L, 0L, 0, 0, Collections.emptyList(), null, null, state);
    }

    public SnapshotInfo(SnapshotId snapshotId, List<String> indices, List<String> dataStreams, List<SnapshotFeatureInfo> featureStates, Version version, SnapshotState state) {
        this(snapshotId, indices, dataStreams, featureStates, null, version, 0L, 0L, 0, 0, Collections.emptyList(), null, null, state);
    }

    public SnapshotInfo(SnapshotsInProgress.Entry entry) {
        this(entry.snapshot().getSnapshotId(), entry.indices().stream().map(IndexId::getName).collect(Collectors.toList()), entry.dataStreams(), entry.featureStates(), null, Version.CURRENT, entry.startTime(), 0L, 0, 0, Collections.emptyList(), entry.includeGlobalState(), entry.userMetadata(), SnapshotState.IN_PROGRESS);
    }

    public SnapshotInfo(SnapshotId snapshotId, List<String> indices, List<String> dataStreams, List<SnapshotFeatureInfo> featureStates, String reason, long endTime, int totalShards, List<SnapshotShardFailure> shardFailures, Boolean includeGlobalState, Map<String, Object> userMetadata, long startTime) {
        this(snapshotId, indices, dataStreams, featureStates, reason, Version.CURRENT, startTime, endTime, totalShards, totalShards - shardFailures.size(), shardFailures, includeGlobalState, userMetadata, SnapshotInfo.snapshotState(reason, shardFailures));
    }

    SnapshotInfo(SnapshotId snapshotId, List<String> indices, List<String> dataStreams, List<SnapshotFeatureInfo> featureStates, String reason, Version version, long startTime, long endTime, int totalShards, int successfulShards, List<SnapshotShardFailure> shardFailures, Boolean includeGlobalState, Map<String, Object> userMetadata, SnapshotState state) {
        this.snapshotId = Objects.requireNonNull(snapshotId);
        this.indices = Collections.unmodifiableList(Objects.requireNonNull(indices));
        this.dataStreams = Collections.unmodifiableList(Objects.requireNonNull(dataStreams));
        this.featureStates = Collections.unmodifiableList(Objects.requireNonNull(featureStates));
        this.state = state;
        this.reason = reason;
        this.version = version;
        this.startTime = startTime;
        this.endTime = endTime;
        this.totalShards = totalShards;
        this.successfulShards = successfulShards;
        this.shardFailures = Objects.requireNonNull(shardFailures);
        this.includeGlobalState = includeGlobalState;
        this.userMetadata = userMetadata;
    }

    public SnapshotInfo(StreamInput in) throws IOException {
        this.snapshotId = new SnapshotId(in);
        this.indices = Collections.unmodifiableList(in.readStringList());
        this.state = in.readBoolean() ? SnapshotState.fromValue(in.readByte()) : null;
        this.reason = in.readOptionalString();
        this.startTime = in.readVLong();
        this.endTime = in.readVLong();
        this.totalShards = in.readVInt();
        this.successfulShards = in.readVInt();
        this.shardFailures = Collections.unmodifiableList(in.readList(SnapshotShardFailure::new));
        Version version = this.version = in.readBoolean() ? Version.readVersion(in) : null;
        if (in.getVersion().onOrAfter(INCLUDE_GLOBAL_STATE_INTRODUCED)) {
            this.includeGlobalState = in.readOptionalBoolean();
        }
        this.userMetadata = in.getVersion().onOrAfter(METADATA_FIELD_INTRODUCED) ? in.readMap() : null;
        this.dataStreams = in.getVersion().onOrAfter(DATA_STREAMS_IN_SNAPSHOT) ? in.readStringList() : Collections.emptyList();
        this.featureStates = in.getVersion().before(SnapshotsService.FEATURE_STATES_VERSION) ? Collections.emptyList() : Collections.unmodifiableList(in.readList(SnapshotFeatureInfo::new));
    }

    public SnapshotInfo basic() {
        return new SnapshotInfo(this.snapshotId, this.indices, Collections.emptyList(), this.featureStates, this.state);
    }

    public SnapshotId snapshotId() {
        return this.snapshotId;
    }

    @Nullable
    public SnapshotState state() {
        return this.state;
    }

    @Nullable
    public String reason() {
        return this.reason;
    }

    public List<String> indices() {
        return this.indices;
    }

    public List<String> dataStreams() {
        return this.dataStreams;
    }

    public long startTime() {
        return this.startTime;
    }

    public long endTime() {
        return this.endTime;
    }

    public int totalShards() {
        return this.totalShards;
    }

    public int failedShards() {
        return this.totalShards - this.successfulShards;
    }

    public int successfulShards() {
        return this.successfulShards;
    }

    public Boolean includeGlobalState() {
        return this.includeGlobalState;
    }

    public List<SnapshotShardFailure> shardFailures() {
        return this.shardFailures;
    }

    @Nullable
    public Version version() {
        return this.version;
    }

    @Nullable
    public Map<String, Object> userMetadata() {
        return this.userMetadata;
    }

    public List<SnapshotFeatureInfo> featureStates() {
        return this.featureStates;
    }

    @Override
    public int compareTo(SnapshotInfo o) {
        return COMPARATOR.compare(this, o);
    }

    public String toString() {
        return "SnapshotInfo{snapshotId=" + this.snapshotId + ", state=" + (Object)((Object)this.state) + ", reason='" + this.reason + '\'' + ", indices=" + this.indices + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", totalShards=" + this.totalShards + ", successfulShards=" + this.successfulShards + ", includeGlobalState=" + this.includeGlobalState + ", version=" + this.version + ", shardFailures=" + this.shardFailures + ", featureStates=" + this.featureStates + '}';
    }

    public RestStatus status() {
        if (this.state == SnapshotState.FAILED) {
            return RestStatus.INTERNAL_SERVER_ERROR;
        }
        if (this.shardFailures.size() == 0) {
            return RestStatus.OK;
        }
        return RestStatus.status(this.successfulShards, this.totalShards, this.shardFailures.toArray(new ShardOperationFailedException[this.shardFailures.size()]));
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (CONTEXT_MODE_SNAPSHOT.equals(params.param(CONTEXT_MODE_PARAM))) {
            return this.toXContentInternal(builder, params);
        }
        boolean verbose = params.paramAsBoolean("verbose", true);
        builder.startObject();
        builder.field(SNAPSHOT, this.snapshotId.getName());
        builder.field(UUID, this.snapshotId.getUUID());
        if (this.version != null) {
            builder.field(VERSION_ID, this.version.id);
            builder.field(VERSION, this.version.toString());
        }
        builder.startArray(INDICES);
        for (String index : this.indices) {
            builder.value(index);
        }
        builder.endArray();
        builder.startArray(DATA_STREAMS);
        for (String dataStream : this.dataStreams) {
            builder.value(dataStream);
        }
        builder.endArray();
        if (this.includeGlobalState != null) {
            builder.field(INCLUDE_GLOBAL_STATE, this.includeGlobalState);
        }
        if (this.userMetadata != null) {
            builder.field(USER_METADATA, this.userMetadata);
        }
        if (verbose || this.state != null) {
            builder.field(STATE, (Object)this.state);
        }
        if (this.reason != null) {
            builder.field(REASON, this.reason);
        }
        if (verbose || this.startTime != 0L) {
            builder.field(START_TIME, DATE_TIME_FORMATTER.format(Instant.ofEpochMilli(this.startTime).atZone(ZoneOffset.UTC)));
            builder.field(START_TIME_IN_MILLIS, this.startTime);
        }
        if (verbose || this.endTime != 0L) {
            builder.field(END_TIME, DATE_TIME_FORMATTER.format(Instant.ofEpochMilli(this.endTime).atZone(ZoneOffset.UTC)));
            builder.field(END_TIME_IN_MILLIS, this.endTime);
            builder.humanReadableField(DURATION_IN_MILLIS, DURATION, (Object)new TimeValue(Math.max(0L, this.endTime - this.startTime)));
        }
        if (verbose || !this.shardFailures.isEmpty()) {
            builder.startArray(FAILURES);
            for (SnapshotShardFailure shardFailure : this.shardFailures) {
                shardFailure.toXContent(builder, params);
            }
            builder.endArray();
        }
        if (verbose || this.totalShards != 0) {
            builder.startObject(SHARDS);
            builder.field(TOTAL, this.totalShards);
            builder.field(FAILED, this.failedShards());
            builder.field(SUCCESSFUL, this.successfulShards);
            builder.endObject();
        }
        if (verbose || !this.featureStates.isEmpty()) {
            builder.startArray(FEATURE_STATES);
            for (SnapshotFeatureInfo snapshotFeatureInfo : this.featureStates) {
                builder.value((Object)snapshotFeatureInfo);
            }
            builder.endArray();
        }
        builder.endObject();
        return builder;
    }

    private XContentBuilder toXContentInternal(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(SNAPSHOT);
        builder.field(NAME, this.snapshotId.getName());
        builder.field(UUID, this.snapshotId.getUUID());
        assert (this.version != null) : "version must always be known when writing a snapshot metadata blob";
        builder.field(VERSION_ID, this.version.id);
        builder.startArray(INDICES);
        for (String index : this.indices) {
            builder.value(index);
        }
        builder.endArray();
        builder.startArray(DATA_STREAMS);
        for (String dataStream : this.dataStreams) {
            builder.value(dataStream);
        }
        builder.endArray();
        builder.field(STATE, (Object)this.state);
        if (this.reason != null) {
            builder.field(REASON, this.reason);
        }
        if (this.includeGlobalState != null) {
            builder.field(INCLUDE_GLOBAL_STATE, this.includeGlobalState);
        }
        builder.field(USER_METADATA, this.userMetadata);
        builder.field(START_TIME, this.startTime);
        builder.field(END_TIME, this.endTime);
        builder.field(TOTAL_SHARDS, this.totalShards);
        builder.field(SUCCESSFUL_SHARDS, this.successfulShards);
        builder.startArray(FAILURES);
        for (SnapshotShardFailure shardFailure : this.shardFailures) {
            shardFailure.toXContent(builder, params);
        }
        builder.endArray();
        builder.startArray(FEATURE_STATES);
        for (SnapshotFeatureInfo snapshotFeatureInfo : this.featureStates) {
            builder.value((Object)snapshotFeatureInfo);
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public static SnapshotInfo fromXContentInternal(XContentParser parser) throws IOException {
        String name = null;
        String uuid = null;
        Version version = Version.CURRENT;
        SnapshotState state = SnapshotState.IN_PROGRESS;
        String reason = null;
        List<String> indices = Collections.emptyList();
        List<String> dataStreams = Collections.emptyList();
        long startTime = 0L;
        long endTime = 0L;
        int totalShards = 0;
        int successfulShards = 0;
        Boolean includeGlobalState = null;
        Map userMetadata = null;
        List<SnapshotShardFailure> shardFailures = Collections.emptyList();
        List<SnapshotFeatureInfo> featureStates = Collections.emptyList();
        if (parser.currentToken() == null) {
            parser.nextToken();
        }
        if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
            parser.nextToken();
        }
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.nextToken(), parser);
        String currentFieldName = parser.currentName();
        if (SNAPSHOT.equals(currentFieldName)) {
            XContentParser.Token token;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token != XContentParser.Token.FIELD_NAME) continue;
                currentFieldName = parser.currentName();
                token = parser.nextToken();
                if (token.isValue()) {
                    if (NAME.equals(currentFieldName)) {
                        name = parser.text();
                        continue;
                    }
                    if (UUID.equals(currentFieldName)) {
                        uuid = parser.text();
                        continue;
                    }
                    if (STATE.equals(currentFieldName)) {
                        state = SnapshotState.valueOf(parser.text());
                        continue;
                    }
                    if (REASON.equals(currentFieldName)) {
                        reason = parser.text();
                        continue;
                    }
                    if (START_TIME.equals(currentFieldName)) {
                        startTime = parser.longValue();
                        continue;
                    }
                    if (END_TIME.equals(currentFieldName)) {
                        endTime = parser.longValue();
                        continue;
                    }
                    if (TOTAL_SHARDS.equals(currentFieldName)) {
                        totalShards = parser.intValue();
                        continue;
                    }
                    if (SUCCESSFUL_SHARDS.equals(currentFieldName)) {
                        successfulShards = parser.intValue();
                        continue;
                    }
                    if (VERSION_ID.equals(currentFieldName)) {
                        version = Version.fromId(parser.intValue());
                        continue;
                    }
                    if (!INCLUDE_GLOBAL_STATE.equals(currentFieldName)) continue;
                    includeGlobalState = parser.booleanValue();
                    continue;
                }
                if (token == XContentParser.Token.START_ARRAY) {
                    if (DATA_STREAMS.equals(currentFieldName)) {
                        dataStreams = new ArrayList<String>();
                        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                            dataStreams.add(parser.text());
                        }
                        continue;
                    }
                    if (INDICES.equals(currentFieldName)) {
                        ArrayList<String> indicesArray = new ArrayList<String>();
                        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                            indicesArray.add(parser.text());
                        }
                        indices = Collections.unmodifiableList(indicesArray);
                        continue;
                    }
                    if (FAILURES.equals(currentFieldName)) {
                        ArrayList<SnapshotShardFailure> shardFailureArrayList = new ArrayList<SnapshotShardFailure>();
                        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                            shardFailureArrayList.add(SnapshotShardFailure.fromXContent(parser));
                        }
                        shardFailures = Collections.unmodifiableList(shardFailureArrayList);
                        continue;
                    }
                    if (FEATURE_STATES.equals(currentFieldName)) {
                        ArrayList<SnapshotFeatureInfo> snapshotFeatureInfoArrayList = new ArrayList<SnapshotFeatureInfo>();
                        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                            snapshotFeatureInfoArrayList.add(SnapshotFeatureInfo.fromXContent(parser));
                        }
                        featureStates = Collections.unmodifiableList(snapshotFeatureInfoArrayList);
                        continue;
                    }
                    parser.skipChildren();
                    continue;
                }
                if (token != XContentParser.Token.START_OBJECT) continue;
                if (USER_METADATA.equals(currentFieldName)) {
                    userMetadata = parser.map();
                    continue;
                }
                parser.skipChildren();
            }
        }
        if (uuid == null) {
            uuid = name;
        }
        return new SnapshotInfo(new SnapshotId(name, uuid), indices, dataStreams, featureStates, reason, version, startTime, endTime, totalShards, successfulShards, shardFailures, includeGlobalState, userMetadata, state);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.snapshotId.writeTo(out);
        out.writeStringCollection(this.indices);
        if (this.state != null) {
            out.writeBoolean(true);
            out.writeByte(this.state.value());
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalString(this.reason);
        out.writeVLong(this.startTime);
        out.writeVLong(this.endTime);
        out.writeVInt(this.totalShards);
        out.writeVInt(this.successfulShards);
        out.writeList(this.shardFailures);
        if (this.version != null) {
            out.writeBoolean(true);
            Version.writeVersion(this.version, out);
        } else {
            out.writeBoolean(false);
        }
        if (out.getVersion().onOrAfter(INCLUDE_GLOBAL_STATE_INTRODUCED)) {
            out.writeOptionalBoolean(this.includeGlobalState);
        }
        if (out.getVersion().onOrAfter(METADATA_FIELD_INTRODUCED)) {
            out.writeMap(this.userMetadata);
        }
        if (out.getVersion().onOrAfter(DATA_STREAMS_IN_SNAPSHOT)) {
            out.writeStringCollection(this.dataStreams);
        }
        if (out.getVersion().onOrAfter(SnapshotsService.FEATURE_STATES_VERSION)) {
            out.writeList(this.featureStates);
        }
    }

    private static SnapshotState snapshotState(String reason, List<SnapshotShardFailure> shardFailures) {
        if (reason == null) {
            if (shardFailures.isEmpty()) {
                return SnapshotState.SUCCESS;
            }
            return SnapshotState.PARTIAL;
        }
        return SnapshotState.FAILED;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SnapshotInfo that = (SnapshotInfo)o;
        return this.startTime == that.startTime && this.endTime == that.endTime && this.totalShards == that.totalShards && this.successfulShards == that.successfulShards && Objects.equals(this.snapshotId, that.snapshotId) && this.state == that.state && Objects.equals(this.reason, that.reason) && Objects.equals(this.indices, that.indices) && Objects.equals(this.dataStreams, that.dataStreams) && Objects.equals(this.includeGlobalState, that.includeGlobalState) && Objects.equals(this.version, that.version) && Objects.equals(this.shardFailures, that.shardFailures) && Objects.equals(this.userMetadata, that.userMetadata) && Objects.equals(this.featureStates, that.featureStates);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.snapshotId, this.state, this.reason, this.indices, this.dataStreams, this.startTime, this.endTime, this.totalShards, this.successfulShards, this.includeGlobalState, this.version, this.shardFailures, this.userMetadata, this.featureStates});
    }

    static {
        SNAPSHOT_INFO_PARSER.declareString((rec$, x$0) -> ((SnapshotInfoBuilder)rec$).setSnapshotName(x$0), new ParseField(SNAPSHOT, new String[0]));
        SNAPSHOT_INFO_PARSER.declareString((rec$, x$0) -> ((SnapshotInfoBuilder)rec$).setSnapshotUUID(x$0), new ParseField(UUID, new String[0]));
        SNAPSHOT_INFO_PARSER.declareString((rec$, x$0) -> ((SnapshotInfoBuilder)rec$).setState(x$0), new ParseField(STATE, new String[0]));
        SNAPSHOT_INFO_PARSER.declareString((rec$, x$0) -> ((SnapshotInfoBuilder)rec$).setReason(x$0), new ParseField(REASON, new String[0]));
        SNAPSHOT_INFO_PARSER.declareStringArray((rec$, x$0) -> ((SnapshotInfoBuilder)rec$).setIndices(x$0), new ParseField(INDICES, new String[0]));
        SNAPSHOT_INFO_PARSER.declareStringArray((rec$, x$0) -> ((SnapshotInfoBuilder)rec$).setDataStreams(x$0), new ParseField(DATA_STREAMS, new String[0]));
        SNAPSHOT_INFO_PARSER.declareObjectArray((rec$, x$0) -> ((SnapshotInfoBuilder)rec$).setFeatureStates(x$0), SnapshotFeatureInfo.SNAPSHOT_FEATURE_INFO_PARSER, new ParseField(FEATURE_STATES, new String[0]));
        SNAPSHOT_INFO_PARSER.declareLong((rec$, x$0) -> ((SnapshotInfoBuilder)rec$).setStartTime(x$0), new ParseField(START_TIME_IN_MILLIS, new String[0]));
        SNAPSHOT_INFO_PARSER.declareLong((rec$, x$0) -> ((SnapshotInfoBuilder)rec$).setEndTime(x$0), new ParseField(END_TIME_IN_MILLIS, new String[0]));
        SNAPSHOT_INFO_PARSER.declareObject((rec$, x$0) -> ((SnapshotInfoBuilder)rec$).setShardStatsBuilder(x$0), SHARD_STATS_PARSER, new ParseField(SHARDS, new String[0]));
        SNAPSHOT_INFO_PARSER.declareBoolean((rec$, x$0) -> ((SnapshotInfoBuilder)rec$).setIncludeGlobalState(x$0), new ParseField(INCLUDE_GLOBAL_STATE, new String[0]));
        SNAPSHOT_INFO_PARSER.declareObject((rec$, x$0) -> ((SnapshotInfoBuilder)rec$).setUserMetadata(x$0), (p, c) -> p.map(), new ParseField(USER_METADATA, new String[0]));
        SNAPSHOT_INFO_PARSER.declareInt((rec$, x$0) -> ((SnapshotInfoBuilder)rec$).setVersion(x$0), new ParseField(VERSION_ID, new String[0]));
        SNAPSHOT_INFO_PARSER.declareObjectArray((rec$, x$0) -> ((SnapshotInfoBuilder)rec$).setShardFailures(x$0), SnapshotShardFailure.SNAPSHOT_SHARD_FAILURE_PARSER, new ParseField(FAILURES, new String[0]));
        SHARD_STATS_PARSER.declareInt((rec$, x$0) -> ((ShardStatsBuilder)rec$).setTotalShards(x$0), new ParseField(TOTAL, new String[0]));
        SHARD_STATS_PARSER.declareInt((rec$, x$0) -> ((ShardStatsBuilder)rec$).setSuccessfulShards(x$0), new ParseField(SUCCESSFUL, new String[0]));
    }

    private static final class ShardStatsBuilder {
        private int totalShards;
        private int successfulShards;

        private ShardStatsBuilder() {
        }

        private void setTotalShards(int totalShards) {
            this.totalShards = totalShards;
        }

        int getTotalShards() {
            return this.totalShards;
        }

        private void setSuccessfulShards(int successfulShards) {
            this.successfulShards = successfulShards;
        }

        int getSuccessfulShards() {
            return this.successfulShards;
        }
    }

    public static final class SnapshotInfoBuilder {
        private String snapshotName = null;
        private String snapshotUUID = null;
        private String state = null;
        private String reason = null;
        private List<String> indices = null;
        private List<String> dataStreams = null;
        private List<SnapshotFeatureInfo> featureStates = null;
        private long startTime = 0L;
        private long endTime = 0L;
        private ShardStatsBuilder shardStatsBuilder = null;
        private Boolean includeGlobalState = null;
        private Map<String, Object> userMetadata = null;
        private int version = -1;
        private List<SnapshotShardFailure> shardFailures = null;

        private void setSnapshotName(String snapshotName) {
            this.snapshotName = snapshotName;
        }

        private void setSnapshotUUID(String snapshotUUID) {
            this.snapshotUUID = snapshotUUID;
        }

        private void setState(String state) {
            this.state = state;
        }

        private void setReason(String reason) {
            this.reason = reason;
        }

        private void setIndices(List<String> indices) {
            this.indices = indices;
        }

        private void setDataStreams(List<String> dataStreams) {
            this.dataStreams = dataStreams;
        }

        private void setFeatureStates(List<SnapshotFeatureInfo> featureStates) {
            this.featureStates = featureStates;
        }

        private void setStartTime(long startTime) {
            this.startTime = startTime;
        }

        private void setEndTime(long endTime) {
            this.endTime = endTime;
        }

        private void setShardStatsBuilder(ShardStatsBuilder shardStatsBuilder) {
            this.shardStatsBuilder = shardStatsBuilder;
        }

        private void setIncludeGlobalState(Boolean includeGlobalState) {
            this.includeGlobalState = includeGlobalState;
        }

        private void setUserMetadata(Map<String, Object> userMetadata) {
            this.userMetadata = userMetadata;
        }

        private void setVersion(int version) {
            this.version = version;
        }

        private void setShardFailures(List<SnapshotShardFailure> shardFailures) {
            this.shardFailures = shardFailures;
        }

        public SnapshotInfo build() {
            int successfulShards;
            SnapshotId snapshotId = new SnapshotId(this.snapshotName, this.snapshotUUID);
            if (this.indices == null) {
                this.indices = Collections.emptyList();
            }
            if (this.dataStreams == null) {
                this.dataStreams = Collections.emptyList();
            }
            if (this.featureStates == null) {
                this.featureStates = Collections.emptyList();
            }
            SnapshotState snapshotState = this.state == null ? null : SnapshotState.valueOf(this.state);
            Version version = this.version == -1 ? Version.CURRENT : Version.fromId(this.version);
            int totalShards = this.shardStatsBuilder == null ? 0 : this.shardStatsBuilder.getTotalShards();
            int n = successfulShards = this.shardStatsBuilder == null ? 0 : this.shardStatsBuilder.getSuccessfulShards();
            if (this.shardFailures == null) {
                this.shardFailures = new ArrayList<SnapshotShardFailure>();
            }
            return new SnapshotInfo(snapshotId, this.indices, this.dataStreams, this.featureStates, this.reason, version, this.startTime, this.endTime, totalShards, successfulShards, this.shardFailures, this.includeGlobalState, this.userMetadata, snapshotState);
        }
    }
}

