/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.RecognitionException;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.sonar.api.SonarProduct;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.issue.NewIssue;
import org.sonar.api.batch.sensor.issue.NewIssueLocation;
import org.sonar.api.issue.NoSonarFilter;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.FileLinesContext;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonar.api.measures.Metric;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugins.python.PythonChecks;
import org.sonar.plugins.python.PythonHighlighter;
import org.sonar.plugins.python.Scanner;
import org.sonar.plugins.python.SonarQubePythonFile;
import org.sonar.plugins.python.SymbolVisitor;
import org.sonar.plugins.python.api.IssueLocation;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonFile;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.PythonVisitorContext;
import org.sonar.plugins.python.api.tree.FileInput;
import org.sonar.plugins.python.cpd.PythonCpdAnalyzer;
import org.sonar.python.SubscriptionVisitor;
import org.sonar.python.metrics.FileLinesVisitor;
import org.sonar.python.metrics.FileMetrics;
import org.sonar.python.parser.PythonParser;
import org.sonar.python.semantic.ProjectLevelSymbolTable;
import org.sonar.python.semantic.SymbolUtils;
import org.sonar.python.tree.PythonTreeMaker;

public class PythonScanner
extends Scanner {
    private static final Logger LOG = Loggers.get(PythonScanner.class);
    private final PythonParser parser;
    private final Map<InputFile, String> packageNames = new HashMap<InputFile, String>();
    private final PythonChecks checks;
    private final FileLinesContextFactory fileLinesContextFactory;
    private final NoSonarFilter noSonarFilter;
    private final PythonCpdAnalyzer cpdAnalyzer;
    private final ProjectLevelSymbolTable projectLevelSymbolTable = new ProjectLevelSymbolTable();

    public PythonScanner(SensorContext context, PythonChecks checks, FileLinesContextFactory fileLinesContextFactory, NoSonarFilter noSonarFilter, List<InputFile> files) {
        super(context);
        this.checks = checks;
        this.fileLinesContextFactory = fileLinesContextFactory;
        this.noSonarFilter = noSonarFilter;
        this.cpdAnalyzer = new PythonCpdAnalyzer(context);
        this.parser = PythonParser.create();
        long startTime = System.currentTimeMillis();
        GlobalSymbolsScanner globalSymbolsStep = new GlobalSymbolsScanner(context);
        globalSymbolsStep.execute(files, context);
        long stopTime = System.currentTimeMillis() - startTime;
        LOG.debug("Time to build the project level symbol table: " + stopTime + "ms");
    }

    @Override
    protected String name() {
        return "rules execution";
    }

    @Override
    protected void scanFile(InputFile inputFile) {
        PythonVisitorContext visitorContext;
        PythonFile pythonFile = SonarQubePythonFile.create(inputFile);
        try {
            AstNode astNode = this.parser.parse(pythonFile.content());
            FileInput parse = new PythonTreeMaker().fileInput(astNode);
            visitorContext = new PythonVisitorContext(parse, pythonFile, PythonScanner.getWorkingDirectory(this.context), this.packageNames.get(inputFile), this.projectLevelSymbolTable);
            this.saveMeasures(inputFile, visitorContext);
        }
        catch (RecognitionException e) {
            visitorContext = new PythonVisitorContext(pythonFile, e);
            LOG.error("Unable to parse file: " + inputFile.toString());
            LOG.error(e.getMessage());
            this.context.newAnalysisError().onFile(inputFile).at(inputFile.newPointer(e.getLine(), 0)).message(e.getMessage()).save();
        }
        ArrayList<PythonSubscriptionCheck> checksBasedOnTree = new ArrayList<PythonSubscriptionCheck>();
        for (PythonCheck check : this.checks.all()) {
            if (check instanceof PythonSubscriptionCheck) {
                checksBasedOnTree.add((PythonSubscriptionCheck)check);
                continue;
            }
            check.scanFile(visitorContext);
        }
        SubscriptionVisitor.analyze(checksBasedOnTree, visitorContext);
        this.saveIssues(inputFile, visitorContext.getIssues());
        if (visitorContext.rootTree() != null) {
            new SymbolVisitor(this.context.newSymbolTable().onFile(inputFile)).visitFileInput(visitorContext.rootTree());
            new PythonHighlighter(this.context, inputFile).scanFile(visitorContext);
        }
    }

    static File getWorkingDirectory(SensorContext context) {
        return context.runtime().getProduct().equals((Object)SonarProduct.SONARLINT) ? null : context.fileSystem().workDir();
    }

    @Override
    protected void processException(Exception e, InputFile file) {
        LOG.warn("Unable to analyze file: " + file.toString(), (Throwable)e);
    }

    private void saveIssues(InputFile inputFile, List<PythonCheck.PreciseIssue> issues) {
        for (PythonCheck.PreciseIssue preciseIssue : issues) {
            RuleKey ruleKey = this.checks.ruleKey(preciseIssue.check());
            NewIssue newIssue = this.context.newIssue().forRule(ruleKey);
            Integer cost = preciseIssue.cost();
            if (cost != null) {
                newIssue.gap(Double.valueOf(cost.doubleValue()));
            }
            NewIssueLocation primaryLocation = PythonScanner.newLocation(inputFile, newIssue, preciseIssue.primaryLocation());
            newIssue.at(primaryLocation);
            ArrayDeque<NewIssueLocation> secondaryLocationsFlow = new ArrayDeque<NewIssueLocation>();
            for (IssueLocation secondaryLocation : preciseIssue.secondaryLocations()) {
                String fileId = secondaryLocation.fileId();
                if (fileId != null) {
                    InputFile issueLocationFile = PythonScanner.component(fileId, this.context);
                    if (issueLocationFile == null) continue;
                    secondaryLocationsFlow.addFirst(PythonScanner.newLocation(issueLocationFile, newIssue, secondaryLocation));
                    continue;
                }
                newIssue.addLocation(PythonScanner.newLocation(inputFile, newIssue, secondaryLocation));
            }
            if (!secondaryLocationsFlow.isEmpty()) {
                secondaryLocationsFlow.addFirst(primaryLocation);
                newIssue.addFlow(secondaryLocationsFlow);
            }
            newIssue.save();
        }
    }

    @CheckForNull
    private static InputFile component(String fileId, SensorContext sensorContext) {
        InputFile inputFile = sensorContext.fileSystem().inputFile(sensorContext.fileSystem().predicates().is(new File(fileId)));
        if (inputFile == null) {
            LOG.debug("Failed to find InputFile for {}", (Object)fileId);
        }
        return inputFile;
    }

    private static NewIssueLocation newLocation(InputFile inputFile, NewIssue issue, IssueLocation location) {
        String message;
        NewIssueLocation newLocation = issue.newLocation().on((InputComponent)inputFile);
        if (location.startLine() != 0) {
            TextRange range = location.startLineOffset() == -1 ? inputFile.selectLine(location.startLine()) : inputFile.newRange(location.startLine(), location.startLineOffset(), location.endLine(), location.endLineOffset());
            newLocation.at(range);
        }
        if ((message = location.message()) != null) {
            newLocation.message(message);
        }
        return newLocation;
    }

    private void saveMeasures(InputFile inputFile, PythonVisitorContext visitorContext) {
        FileMetrics fileMetrics = new FileMetrics(visitorContext);
        FileLinesVisitor fileLinesVisitor = fileMetrics.fileLinesVisitor();
        this.cpdAnalyzer.pushCpdTokens(inputFile, visitorContext);
        this.noSonarFilter.noSonarInFile(inputFile, fileLinesVisitor.getLinesWithNoSonar());
        Set<Integer> linesOfCode = fileLinesVisitor.getLinesOfCode();
        this.saveMetricOnFile(inputFile, (Metric<Integer>)CoreMetrics.NCLOC, linesOfCode.size());
        this.saveMetricOnFile(inputFile, (Metric<Integer>)CoreMetrics.STATEMENTS, fileMetrics.numberOfStatements());
        this.saveMetricOnFile(inputFile, (Metric<Integer>)CoreMetrics.FUNCTIONS, fileMetrics.numberOfFunctions());
        this.saveMetricOnFile(inputFile, (Metric<Integer>)CoreMetrics.CLASSES, fileMetrics.numberOfClasses());
        this.saveMetricOnFile(inputFile, (Metric<Integer>)CoreMetrics.COMPLEXITY, fileMetrics.complexity());
        this.saveMetricOnFile(inputFile, (Metric<Integer>)CoreMetrics.COGNITIVE_COMPLEXITY, fileMetrics.cognitiveComplexity());
        this.saveMetricOnFile(inputFile, (Metric<Integer>)CoreMetrics.COMMENT_LINES, fileLinesVisitor.getCommentLineCount());
        FileLinesContext fileLinesContext = this.fileLinesContextFactory.createFor(inputFile);
        for (int line : linesOfCode) {
            fileLinesContext.setIntValue("ncloc_data", line, 1);
        }
        for (int line : fileLinesVisitor.getExecutableLines()) {
            fileLinesContext.setIntValue("executable_lines_data", line, 1);
        }
        fileLinesContext.save();
    }

    private void saveMetricOnFile(InputFile inputFile, Metric<Integer> metric, Integer value) {
        this.context.newMeasure().withValue((Serializable)value).forMetric(metric).on((InputComponent)inputFile).save();
    }

    private class GlobalSymbolsScanner
    extends Scanner {
        private GlobalSymbolsScanner(SensorContext context) {
            super(context);
        }

        @Override
        protected String name() {
            return "global symbols computation";
        }

        @Override
        protected void scanFile(InputFile inputFile) throws IOException {
            AstNode astNode = PythonScanner.this.parser.parse(inputFile.contents());
            FileInput astRoot = new PythonTreeMaker().fileInput(astNode);
            String packageName = SymbolUtils.pythonPackageName(inputFile.file(), this.context.fileSystem().baseDir());
            PythonScanner.this.packageNames.put(inputFile, packageName);
            PythonFile pythonFile = SonarQubePythonFile.create(inputFile);
            PythonScanner.this.projectLevelSymbolTable.addModule(astRoot, packageName, pythonFile);
        }

        @Override
        protected void processException(Exception e, InputFile file) {
            LOG.debug("Unable to construct project-level symbol table for file: " + file.toString());
            LOG.debug(e.getMessage());
        }
    }
}

