/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.hotspots;

import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.checks.AbstractCallExpressionCheck;

@Rule(key="S4823")
public class CommandLineArgsCheck
extends AbstractCallExpressionCheck {
    public static final String CHECK_KEY = "S4823";
    private static final String MESSAGE = "Make sure that command line arguments are used safely here.";
    private static final Set<String> questionableFunctions = CommandLineArgsCheck.immutableSet("argparse.ArgumentParser", "optparse.OptionParser");

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.NAME, CommandLineArgsCheck::checkSysArgNode);
        super.initialize(context);
    }

    private static void checkSysArgNode(SubscriptionContext ctx) {
        Name nameTree = (Name)ctx.syntaxNode();
        Tree parent = nameTree.parent();
        Symbol symbol = nameTree.symbol();
        if (symbol != null && "sys.argv".equals(symbol.fullyQualifiedName())) {
            if (CommandLineArgsCheck.isWithinImport(parent)) {
                return;
            }
            ctx.addIssue(nameTree, MESSAGE);
        }
    }

    @Override
    protected Set<String> functionsToCheck() {
        return questionableFunctions;
    }

    @Override
    protected String message() {
        return MESSAGE;
    }
}

