/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.hotspots;

import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Tree;

@Rule(key="S4787")
public class DataEncryptionCheck
extends PythonSubscriptionCheck {
    private static final List<String> FUNCTIONS_TO_CHECK = Arrays.asList("cryptography.fernet.Fernet", "cryptography.hazmat.primitives.ciphers.aead.ChaCha20Poly1305", "cryptography.hazmat.primitives.ciphers.aead.AESGCM", "cryptography.hazmat.primitives.ciphers.aead.AESCCM", "cryptography.hazmat.primitives.asymmetric.dh.generate_parameters", "cryptography.hazmat.primitives.ciphers.Cipher", "nacl.public.Box", "nacl.secret.SecretBox", "Crypto.Cipher.AES.new", "Crypto.Cipher.DES.new", "Crypto.Cipher.DES3.new", "Crypto.Cipher.ARC2.new", "Crypto.Cipher.ARC4.new", "Crypto.Cipher.Blowfish.new", "Crypto.Cipher.CAST.new", "Crypto.Cipher.PKCS1_v1_5.new", "Crypto.Cipher.PKCS1_OAEP.new", "Crypto.Cipher.XOR.new", "Crypto.Cipher.XOR.new", "Crypto.PublicKey.ElGamal.generate", "Cryptodome.Cipher.AES.new", "Cryptodome.Cipher.ChaCha20.new", "Cryptodome.Cipher.DES.new", "Cryptodome.Cipher.DES3.new", "Cryptodome.Cipher.ARC2.new", "Cryptodome.Cipher.ARC4.new", "Cryptodome.Cipher.Blowfish.new", "Cryptodome.Cipher.CAST.new", "Cryptodome.Cipher.PKCS1_v1_5.new", "Cryptodome.Cipher.PKCS1_OAEP.new", "Cryptodome.Cipher.ChaCha20_Poly1305.new", "Cryptodome.Cipher.Salsa20.new", "Cryptodome.PublicKey.ElGamal.generate");

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, ctx -> {
            CallExpression callExpression = (CallExpression)ctx.syntaxNode();
            Symbol symbol = callExpression.calleeSymbol();
            if (symbol != null && FUNCTIONS_TO_CHECK.contains(symbol.fullyQualifiedName())) {
                ctx.addIssue(callExpression, "Make sure that encrypting data is safe here.");
            }
        });
    }
}

