/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import javax.annotation.Nullable;
import org.sonar.api.config.Configuration;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.java.annotations.VisibleForTesting;

public class PerformanceMeasure {
    private static final Logger LOG = Loggers.get(PerformanceMeasure.class);
    private static final String ACTIVATION_PROPERTY = "sonar.java.performance.measure";
    private static final String FILE_PATH_PROPERTY = "sonar.java.performance.measure.path";
    private static final String DESTINATION_FILE = "sonar.java.performance.measure.json";
    private static PerformanceMeasure currentMeasure = null;
    private static Path performanceMeasureFile = null;
    private static final IgnoredDuration NO_OP_DURATION = new IgnoredDuration();
    @Nullable
    public final PerformanceMeasure parent;
    public final String name;
    public final Supplier<Long> nanoTimeSupplier;
    private long totalDurationNanos = 0L;
    private long callsCount = 0L;
    private Map<String, PerformanceMeasure> childrenMap = null;

    public static DurationReport start(Configuration config, String name, Supplier<Long> nanoTimeSupplier) {
        performanceMeasureFile = config.get(FILE_PATH_PROPERTY).filter(path -> !path.isEmpty()).map(path -> path.replace('\\', File.separatorChar).replace('/', File.separatorChar)).map(x$0 -> Paths.get(x$0, new String[0])).orElse(null);
        if (!config.get(ACTIVATION_PROPERTY).filter("true"::equals).isPresent()) {
            return NO_OP_DURATION;
        }
        currentMeasure = new PerformanceMeasure(currentMeasure, name, nanoTimeSupplier);
        return new RecordedDuration(currentMeasure);
    }

    public static Duration start(Object object) {
        if (currentMeasure == null) {
            return NO_OP_DURATION;
        }
        return PerformanceMeasure.start(object.getClass().getSimpleName());
    }

    public static Duration start(String name) {
        if (currentMeasure == null) {
            return NO_OP_DURATION;
        }
        if (PerformanceMeasure.currentMeasure.name.equals(name)) {
            return new RecordedDuration(currentMeasure);
        }
        currentMeasure = currentMeasure.getOrCreateChild(name);
        return new RecordedDuration(currentMeasure);
    }

    public static void setCurrent(@Nullable PerformanceMeasure measure) {
        currentMeasure = measure;
    }

    public PerformanceMeasure(@Nullable PerformanceMeasure parent, String name, Supplier<Long> nanoTimeSupplier) {
        this.parent = parent;
        this.name = name;
        this.nanoTimeSupplier = nanoTimeSupplier;
    }

    public final void add(long durationNanos) {
        this.totalDurationNanos += durationNanos;
        ++this.callsCount;
    }

    public Collection<PerformanceMeasure> children() {
        return this.childrenMap != null ? this.childrenMap.values() : Collections.emptyList();
    }

    private PerformanceMeasure getOrCreateChild(String name) {
        if (this.childrenMap == null) {
            this.childrenMap = new HashMap<String, PerformanceMeasure>();
        }
        return this.childrenMap.computeIfAbsent(name, n -> new PerformanceMeasure(this, (String)n, this.nanoTimeSupplier));
    }

    private PerformanceMeasure merge(PerformanceMeasure measure) throws IOException {
        if (!measure.name.equals(this.name)) {
            throw new IOException("Incompatible name '" + measure.name + "' and '" + this.name + "'");
        }
        this.totalDurationNanos += measure.totalDurationNanos;
        this.callsCount += measure.callsCount;
        for (PerformanceMeasure child : measure.children()) {
            this.getOrCreateChild(child.name).merge(child);
        }
        return this;
    }

    @VisibleForTesting
    static void ensureParentDirectoryExists(Path path) throws IOException {
        Path parentDirectory = path.getParent();
        if (parentDirectory != null && !Files.isDirectory(parentDirectory, new LinkOption[0])) {
            Files.createDirectory(parentDirectory, new FileAttribute[0]);
        }
    }

    private static class RecordedDuration
    implements Duration,
    DurationReport {
        private static final String PARENT_OF_THROWAWAY_MEASURES_TO_COMPUTE_OBSERVATION_COST = "#measures to compute observation cost";
        private static final int SAMPLING_COUNT_TO_EVALUATE_OBSERVATION_COST = 99;
        private static final Supplier<IntStream> SAMPLES = () -> IntStream.range(0, 99);
        private final PerformanceMeasure measure;
        private long startNanos;

        public RecordedDuration(PerformanceMeasure measure) {
            this.measure = measure;
            this.startNanos = measure.nanoTimeSupplier.get();
        }

        @Override
        public void stop() {
            if (this.startNanos != -1L) {
                this.measure.add(this.measure.nanoTimeSupplier.get() - this.startNanos);
                this.startNanos = -1L;
                PerformanceMeasure.setCurrent(this.measure.parent);
            }
        }

        @Override
        public void stopAndLog(@Nullable File workDir, boolean appendMeasurementCost) {
            if (appendMeasurementCost) {
                PerformanceMeasure.setCurrent(this.measure);
                RecordedDuration.appendMeasurementCost();
            }
            this.stop();
            RecordedDuration.saveToFile(workDir, this.measure);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Performance Measures:\n" + RecordedDuration.jsonFormat(RecordedDuration.toJson(this.measure)));
            }
        }

        private static void appendMeasurementCost() {
            String[] sampleNames = (String[])SAMPLES.get().mapToObj(i -> "m" + i).toArray(String[]::new);
            Duration totalDuration = PerformanceMeasure.start("#MeasurementCost_v1");
            PerformanceMeasure measurementCost = currentMeasure;
            Duration temporaryDuration = PerformanceMeasure.start(PARENT_OF_THROWAWAY_MEASURES_TO_COMPUTE_OBSERVATION_COST);
            measurementCost.getOrCreateChild("nanoTime").add(RecordedDuration.median(SAMPLES.get().mapToLong(i -> {
                long start = System.nanoTime();
                return System.nanoTime() - start;
            })));
            measurementCost.getOrCreateChild("createChild").add(RecordedDuration.median(SAMPLES.get().mapToLong(i -> {
                long start = System.nanoTime();
                PerformanceMeasure.start(sampleNames[i]).stop();
                return System.nanoTime() - start;
            })));
            measurementCost.getOrCreateChild("observationCost").add(RecordedDuration.median(Arrays.stream(sampleNames).map(n -> (PerformanceMeasure)currentMeasure.childrenMap.get(n)).mapToLong(m -> ((PerformanceMeasure)m).totalDurationNanos)));
            PerformanceMeasure.start("measure").stop();
            measurementCost.getOrCreateChild("incrementChild").add(RecordedDuration.median(SAMPLES.get().mapToLong(i -> {
                long start = System.nanoTime();
                PerformanceMeasure.start("measure").stop();
                return System.nanoTime() - start;
            })));
            temporaryDuration.stop();
            measurementCost.childrenMap.remove(PARENT_OF_THROWAWAY_MEASURES_TO_COMPUTE_OBSERVATION_COST);
            totalDuration.stop();
        }

        private static long median(LongStream measures) {
            long[] sortedMeasures = measures.sorted().toArray();
            return sortedMeasures[(sortedMeasures.length - 1) / 2];
        }

        private static void saveToFile(@Nullable File workDir, PerformanceMeasure measure) {
            Path performanceFile = performanceMeasureFile;
            if (performanceFile == null && workDir == null) {
                return;
            }
            try {
                PerformanceMeasure allMeasures;
                if (performanceFile == null) {
                    if (!workDir.exists()) {
                        throw new IOException("Directory does not exist: " + workDir.toString());
                    }
                    performanceFile = workDir.toPath().resolve(PerformanceMeasure.DESTINATION_FILE);
                }
                if (Files.exists(performanceFile, new LinkOption[0])) {
                    LOG.info("Adding performance measures into: " + performanceFile);
                    allMeasures = RecordedDuration.fromJson(performanceFile).merge(measure);
                } else {
                    LOG.info("Saving performance measures into: " + performanceFile);
                    allMeasures = measure;
                    PerformanceMeasure.ensureParentDirectoryExists(performanceFile);
                }
                Files.write(performanceFile, RecordedDuration.jsonFormat(RecordedDuration.toJson(allMeasures)).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            }
            catch (IOException e) {
                LOG.error("Can't save performance measure: " + e.getMessage());
            }
        }

        private static JsonObject toJson(PerformanceMeasure measure) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("name", measure.name);
            jsonObject.addProperty("calls", measure.callsCount);
            jsonObject.addProperty("durationNanos", measure.totalDurationNanos);
            Collection<PerformanceMeasure> children = measure.children();
            if (!children.isEmpty()) {
                jsonObject.add("children", children.stream().sorted(Comparator.comparing(e -> e.name)).map(RecordedDuration::toJson).collect(JsonArray::new, JsonArray::add, JsonArray::addAll));
            }
            return jsonObject;
        }

        private static PerformanceMeasure fromJson(Path performanceFile) throws IOException {
            JsonObject jsonObject = new Gson().fromJson(new String(Files.readAllBytes(performanceFile), StandardCharsets.UTF_8), JsonObject.class);
            return RecordedDuration.fromJson(jsonObject, null);
        }

        private static PerformanceMeasure fromJson(JsonObject jsonObject, @Nullable PerformanceMeasure parent) {
            String name = jsonObject.getAsJsonPrimitive("name").getAsString();
            PerformanceMeasure measure = parent != null ? parent.getOrCreateChild(name) : new PerformanceMeasure(null, name, System::nanoTime);
            measure.callsCount = jsonObject.getAsJsonPrimitive("calls").getAsLong();
            measure.totalDurationNanos = jsonObject.getAsJsonPrimitive("durationNanos").getAsLong();
            JsonArray children = jsonObject.getAsJsonArray("children");
            if (children != null) {
                children.forEach(jsonChild -> RecordedDuration.fromJson(jsonChild.getAsJsonObject(), measure));
            }
            return measure;
        }

        private static String jsonFormat(JsonObject jsonObject) {
            String json = new GsonBuilder().setPrettyPrinting().create().toJson(jsonObject);
            return json.replaceAll("\n *+(\"(?:name|calls|durationNanos|children)\":)", " $1").replaceAll("(\\d)\n *+\\}", "$1 }");
        }
    }

    private static final class IgnoredDuration
    implements Duration,
    DurationReport {
        private IgnoredDuration() {
        }

        @Override
        public void stop() {
        }

        @Override
        public void stopAndLog(@Nullable File workDir, boolean appendMeasurementCost) {
        }
    }

    public static interface DurationReport {
        public void stopAndLog(@Nullable File var1, boolean var2);
    }

    public static interface Duration {
        public void stop();
    }
}

