/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonarsource.analyzer.commons.annotations.DeprecatedRuleKey;

@DeprecatedRuleKey(ruleKey="ClassCyclomaticComplexity", repositoryKey="squid")
@Rule(key="S1311")
public class ClassComplexityCheck
extends IssuableSubscriptionVisitor {
    private static final int DEFAULT_MAX = 200;
    @RuleProperty(description="Maximum complexity allowed.", defaultValue="200")
    private int max = 200;

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.CLASS);
    }

    @Override
    public void visitNode(Tree tree) {
        int size = this.context.getComplexityNodes(tree).size();
        if (size > this.max) {
            ClassTree classTree = (ClassTree)tree;
            Tree report = classTree.simpleName() == null ? classTree.openBraceToken() : classTree.simpleName();
            this.reportIssue(report, "The Cyclomatic Complexity of this class is " + size + " which is greater than " + this.max + " authorized.", Collections.emptyList(), size - this.max);
        }
    }

    public void setMax(int max) {
        this.max = max;
    }
}

