/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import org.sonar.check.Rule;
import org.sonar.java.collections.MapBuilder;
import org.sonar.java.collections.SetUtils;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S2250")
public class CollectionMethodsWithLinearComplexityCheck
extends IssuableSubscriptionVisitor {
    private static final String ARRAY_LIST = "java.util.ArrayList";
    private static final String LINKED_LIST = "java.util.LinkedList";
    private static final String COPY_ON_WRITE_ARRAY_LIST = "java.util.concurrent.CopyOnWriteArrayList";
    private static final String COPY_ON_WRITE_ARRAY_SET = "java.util.concurrent.CopyOnWriteArraySet";
    private static final String CONCURRENT_LINKED_QUEUE = "java.util.concurrent.ConcurrentLinkedQueue";
    private static final String CONCURRENT_LINKED_DEQUE = "java.util.concurrent.ConcurrentLinkedDeque";
    private static final MethodMatchers.NameBuilder COLLECTION_METHOD_MATCHER = MethodMatchers.create().ofSubTypes("java.util.Collection");
    private static final Map<MethodMatchers, Set<String>> matcherActualTypeMap;

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD_INVOCATION);
    }

    @Override
    public void visitNode(Tree tree) {
        MethodInvocationTree mit = (MethodInvocationTree)tree;
        matcherActualTypeMap.forEach((methodMatcher, actualTypes) -> {
            Symbol target;
            if (methodMatcher.matches(mit) && CollectionMethodsWithLinearComplexityCheck.invocationInMethod(mit) && (target = CollectionMethodsWithLinearComplexityCheck.invocationTarget(mit)) != null && CollectionMethodsWithLinearComplexityCheck.isField(target) && CollectionMethodsWithLinearComplexityCheck.matchesActualType(target, actualTypes)) {
                IdentifierTree methodName = ExpressionUtils.methodName(mit);
                this.reportIssue(methodName, "This call to \"" + methodName.name() + "()\" may be a performance hot spot if the collection is large.");
            }
        });
    }

    private static boolean invocationInMethod(MethodInvocationTree mit) {
        Tree parent;
        for (parent = mit.parent(); parent != null && !parent.is(Tree.Kind.METHOD); parent = parent.parent()) {
        }
        return parent != null;
    }

    private static boolean isField(Symbol symbol) {
        return symbol.isVariableSymbol() && symbol.owner().isTypeSymbol() && !"this".equals(symbol.name()) && !"super".equals(symbol.name());
    }

    private static boolean matchesActualType(Symbol invocationTarget, Set<String> actualTypes) {
        Type declaredType = invocationTarget.type();
        if (actualTypes.contains(declaredType.fullyQualifiedName())) {
            return true;
        }
        if (invocationTarget.isPrivate() || invocationTarget.isFinal()) {
            Set<String> assignedTypes = CollectionMethodsWithLinearComplexityCheck.findAssignedTypes(invocationTarget);
            return !assignedTypes.isEmpty() && actualTypes.containsAll(assignedTypes);
        }
        return false;
    }

    @CheckForNull
    private static Symbol invocationTarget(MethodInvocationTree mit) {
        ExpressionTree methodSelect = mit.methodSelect();
        if (methodSelect.is(Tree.Kind.MEMBER_SELECT)) {
            ExpressionTree methodSelectExpression = ((MemberSelectExpressionTree)methodSelect).expression();
            if (methodSelectExpression.is(Tree.Kind.IDENTIFIER)) {
                return ((IdentifierTree)methodSelectExpression).symbol();
            }
        }
        return null;
    }

    private static Set<String> findAssignedTypes(Symbol symbol) {
        ExpressionTree initializer;
        HashSet<String> types = new HashSet<String>();
        Tree declaration = symbol.declaration();
        if (declaration != null && declaration.is(Tree.Kind.VARIABLE) && (initializer = ((VariableTree)declaration).initializer()) != null) {
            types.add(initializer.symbolType().fullyQualifiedName());
        }
        symbol.usages().stream().flatMap(CollectionMethodsWithLinearComplexityCheck::usageInAssignment).map(assignment -> assignment.expression().symbolType().fullyQualifiedName()).forEach(types::add);
        return types;
    }

    private static Stream<AssignmentExpressionTree> usageInAssignment(IdentifierTree usage) {
        AssignmentExpressionTree assignment;
        Tree parent;
        Tree prevParent = usage;
        for (parent = usage.parent(); parent != null && !parent.is(Tree.Kind.ASSIGNMENT) && parent.is(Tree.Kind.MEMBER_SELECT, Tree.Kind.IDENTIFIER); parent = parent.parent()) {
            prevParent = parent;
        }
        if (parent != null && parent.is(Tree.Kind.ASSIGNMENT) && (assignment = (AssignmentExpressionTree)parent).variable().equals(prevParent)) {
            return Stream.of(assignment);
        }
        return Stream.empty();
    }

    static {
        MapBuilder<MethodMatchers, Set<String>> builder = MapBuilder.newMap();
        MethodMatchers collectionContains = COLLECTION_METHOD_MATCHER.names("contains").addParametersMatcher("java.lang.Object").build();
        builder.put(collectionContains, SetUtils.immutableSetOf(ARRAY_LIST, LINKED_LIST, COPY_ON_WRITE_ARRAY_LIST, COPY_ON_WRITE_ARRAY_SET, CONCURRENT_LINKED_QUEUE, CONCURRENT_LINKED_DEQUE));
        MethodMatchers collectionSize = COLLECTION_METHOD_MATCHER.names("size").addWithoutParametersMatcher().build();
        builder.put(collectionSize, SetUtils.immutableSetOf(CONCURRENT_LINKED_QUEUE, CONCURRENT_LINKED_DEQUE));
        MethodMatchers collectionAdd = COLLECTION_METHOD_MATCHER.names("add").addParametersMatcher("*").build();
        builder.put(collectionAdd, SetUtils.immutableSetOf(COPY_ON_WRITE_ARRAY_SET, COPY_ON_WRITE_ARRAY_LIST));
        MethodMatchers collectionRemove = COLLECTION_METHOD_MATCHER.names("remove").addParametersMatcher("java.lang.Object").build();
        builder.put(collectionRemove, SetUtils.immutableSetOf(ARRAY_LIST, COPY_ON_WRITE_ARRAY_SET, COPY_ON_WRITE_ARRAY_LIST));
        MethodMatchers listGet = MethodMatchers.create().ofSubTypes("java.util.List").names("get").addParametersMatcher("int").build();
        builder.put(listGet, Collections.singleton(LINKED_LIST));
        matcherActualTypeMap = builder.build();
    }
}

