/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;

@Rule(key="S3331")
public class CookieDomainCheck
extends AbstractMethodDetection {
    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.or(MethodMatchers.create().ofTypes("javax.servlet.http.Cookie").names("setDomain").addParametersMatcher("java.lang.String").build(), MethodMatchers.create().ofTypes("java.net.HttpCookie").names("setDomain").addParametersMatcher("java.lang.String").build());
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        ExpressionTree arg = (ExpressionTree)mit.arguments().get(0);
        String domain = ExpressionsHelper.getConstantValueAsString(arg).value();
        if (domain != null && !domain.isEmpty() && !domain.substring(1).contains(".")) {
            this.reportIssue(arg, "Specify at least a second-level cookie domain.");
        }
    }
}

