/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonarsource.analyzer.commons.annotations.DeprecatedRuleKey;

@DeprecatedRuleKey(ruleKey="EmptyStatementUsageCheck", repositoryKey="squid")
@Rule(key="S1116")
public class EmptyStatementUsageCheck
extends IssuableSubscriptionVisitor {
    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.EMPTY_STATEMENT);
    }

    @Override
    public void visitNode(Tree tree) {
        if (EmptyStatementUsageCheck.usedForEmptyEnum(tree) || EmptyStatementUsageCheck.uniqueStatementOfLoop(tree)) {
            return;
        }
        this.reportIssue(tree, "Remove this empty statement.");
    }

    private static boolean usedForEmptyEnum(Tree tree) {
        Tree parent = tree.parent();
        if (parent.is(Tree.Kind.ENUM)) {
            return ((ClassTree)parent).members().indexOf(tree) == 0;
        }
        return false;
    }

    private static boolean uniqueStatementOfLoop(Tree tree) {
        return tree.parent().is(Tree.Kind.WHILE_STATEMENT, Tree.Kind.FOR_EACH_STATEMENT, Tree.Kind.FOR_STATEMENT, Tree.Kind.DO_STATEMENT);
    }
}

