/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2692")
public class IndexOfWithPositiveNumberCheck
extends IssuableSubscriptionVisitor {
    private static final String JAVA_LANG_STRING = "java.lang.String";
    private static final String INDEXOF = "indexOf";
    private static final MethodMatchers CHECKED_METHODS = MethodMatchers.or(MethodMatchers.create().ofTypes("java.lang.String").names("indexOf").addParametersMatcher("int").addParametersMatcher("java.lang.String").build(), MethodMatchers.create().ofSubTypes("java.util.List").names("indexOf").addParametersMatcher("java.lang.Object").build());

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.GREATER_THAN, Tree.Kind.LESS_THAN);
    }

    @Override
    public void visitNode(Tree tree) {
        BinaryExpressionTree binaryTree = (BinaryExpressionTree)tree;
        if (tree.is(Tree.Kind.GREATER_THAN)) {
            this.checkForIssue(tree, binaryTree.leftOperand(), LiteralUtils.longLiteralValue(binaryTree.rightOperand()));
        } else {
            this.checkForIssue(tree, binaryTree.rightOperand(), LiteralUtils.longLiteralValue(binaryTree.leftOperand()));
        }
    }

    private void checkForIssue(Tree tree, ExpressionTree operand, @Nullable Long constant) {
        if (constant != null && constant == 0L && IndexOfWithPositiveNumberCheck.isIndexOfOnArrayOrString(operand)) {
            this.reportIssue(tree, "0 is a valid index, but is ignored by this check.");
        }
    }

    private static boolean isIndexOfOnArrayOrString(Tree tree) {
        return tree.is(Tree.Kind.METHOD_INVOCATION) && CHECKED_METHODS.matches((MethodInvocationTree)tree);
    }
}

