/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.cfg.CFG;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.BreakStatementTree;
import org.sonar.plugins.java.api.tree.ContinueStatementTree;
import org.sonar.plugins.java.api.tree.DoWhileStatementTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.ForEachStatement;
import org.sonar.plugins.java.api.tree.ForStatementTree;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.ThrowStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.WhileStatementTree;

@Rule(key="S1751")
public class LoopExecutingAtMostOnceCheck
extends IssuableSubscriptionVisitor {
    private static final MethodMatchers NEXT_ELEMENT = MethodMatchers.or(MethodMatchers.create().ofSubTypes("java.util.Enumeration").names("hasMoreElements").addWithoutParametersMatcher().build(), MethodMatchers.create().ofSubTypes("java.util.Iterator").names("hasNext").addWithoutParametersMatcher().build());
    private static final Tree.Kind[] LOOP_KINDS = new Tree.Kind[]{Tree.Kind.DO_STATEMENT, Tree.Kind.WHILE_STATEMENT, Tree.Kind.FOR_STATEMENT, Tree.Kind.FOR_EACH_STATEMENT};

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.BREAK_STATEMENT, Tree.Kind.RETURN_STATEMENT, Tree.Kind.THROW_STATEMENT);
    }

    @Override
    public void visitNode(Tree tree) {
        Tree parent = tree.parent();
        while (parent.is(Tree.Kind.BLOCK)) {
            parent = parent.parent();
        }
        if (!parent.is(LOOP_KINDS)) {
            return;
        }
        if (!LoopExecutingAtMostOnceCheck.isWhileNextElementLoop(parent) && !LoopExecutingAtMostOnceCheck.isEmptyConditionLoop(parent) && LoopExecutingAtMostOnceCheck.executeUnconditionnally(parent)) {
            SyntaxToken jumpKeyword = LoopExecutingAtMostOnceCheck.jumpKeyword(tree);
            this.reportIssue(jumpKeyword, String.format("Remove this \"%s\" statement or make it conditional.", jumpKeyword.text()));
        }
    }

    private static boolean isEmptyConditionLoop(Tree loopTree) {
        switch (loopTree.kind()) {
            case FOR_STATEMENT: {
                ForStatementTree fst = (ForStatementTree)loopTree;
                return fst.initializer().isEmpty() && fst.condition() == null && fst.update().isEmpty();
            }
            case WHILE_STATEMENT: {
                return LoopExecutingAtMostOnceCheck.isTrue(((WhileStatementTree)loopTree).condition());
            }
            case DO_STATEMENT: {
                return LoopExecutingAtMostOnceCheck.isTrue(((DoWhileStatementTree)loopTree).condition());
            }
        }
        return false;
    }

    private static boolean isTrue(ExpressionTree expressionTree) {
        ExpressionTree expr = ExpressionUtils.skipParentheses(expressionTree);
        return LiteralUtils.isTrue(expr);
    }

    private static boolean isWhileNextElementLoop(Tree loopTree) {
        if (loopTree.is(Tree.Kind.WHILE_STATEMENT)) {
            ExpressionTree condition = ExpressionUtils.skipParentheses(((WhileStatementTree)loopTree).condition());
            return condition.is(Tree.Kind.METHOD_INVOCATION) && NEXT_ELEMENT.matches((MethodInvocationTree)condition);
        }
        return false;
    }

    private static boolean executeUnconditionnally(Tree loopTree) {
        CFG cfg = LoopExecutingAtMostOnceCheck.getCFG(loopTree);
        CFG.Block loopBlock = LoopExecutingAtMostOnceCheck.getLoopBlock(cfg, loopTree);
        return !LoopExecutingAtMostOnceCheck.hasPredecessorInBlock(loopBlock, loopTree);
    }

    private static CFG.Block getLoopBlock(CFG cfg, Tree loopTree) {
        return cfg.blocks().stream().filter(block -> loopTree.equals(block.terminator())).findFirst().orElseThrow(() -> new IllegalStateException("CFG necessarily contains the loop block."));
    }

    private static boolean hasPredecessorInBlock(CFG.Block block, Tree loop) {
        for (CFG.Block predecessor : block.predecessors()) {
            List<Tree> predecessorElements = predecessor.elements();
            if (predecessorElements.isEmpty()) {
                return LoopExecutingAtMostOnceCheck.hasPredecessorInBlock(predecessor, loop);
            }
            Tree predecessorFirstElement = predecessorElements.get(0);
            if (LoopExecutingAtMostOnceCheck.isForStatementInitializer(predecessorFirstElement, loop)) continue;
            if (LoopExecutingAtMostOnceCheck.isForStatementUpdate(predecessorFirstElement, loop)) {
                return !predecessor.predecessors().isEmpty();
            }
            if (!LoopExecutingAtMostOnceCheck.isDescendant(predecessorFirstElement, loop)) continue;
            return true;
        }
        return false;
    }

    private static boolean isForStatementInitializer(Tree lastElement, Tree loop) {
        if (loop.is(Tree.Kind.FOR_STATEMENT)) {
            return LoopExecutingAtMostOnceCheck.isDescendant(lastElement, ((ForStatementTree)loop).initializer());
        }
        return loop.is(Tree.Kind.FOR_EACH_STATEMENT) && LoopExecutingAtMostOnceCheck.isDescendant(lastElement, ((ForEachStatement)loop).expression());
    }

    private static boolean isForStatementUpdate(Tree lastElement, Tree loop) {
        return loop.is(Tree.Kind.FOR_STATEMENT) && LoopExecutingAtMostOnceCheck.isDescendant(lastElement, ((ForStatementTree)loop).update());
    }

    private static boolean isDescendant(Tree descendant, Tree target) {
        for (Tree parent = descendant; parent != null; parent = parent.parent()) {
            if (!parent.equals(target)) continue;
            return true;
        }
        return false;
    }

    private static SyntaxToken jumpKeyword(Tree jumpStatement) {
        switch (jumpStatement.kind()) {
            case BREAK_STATEMENT: {
                return ((BreakStatementTree)jumpStatement).breakKeyword();
            }
            case CONTINUE_STATEMENT: {
                return ((ContinueStatementTree)jumpStatement).continueKeyword();
            }
            case RETURN_STATEMENT: {
                return ((ReturnStatementTree)jumpStatement).returnKeyword();
            }
            case THROW_STATEMENT: {
                return ((ThrowStatementTree)jumpStatement).throwKeyword();
            }
        }
        throw new IllegalStateException("Unexpected jump statement.");
    }

    private static CFG getCFG(Tree loop) {
        Tree currentTree = loop;
        do {
            currentTree = currentTree.parent();
        } while (!currentTree.is(Tree.Kind.METHOD, Tree.Kind.CONSTRUCTOR, Tree.Kind.LAMBDA_EXPRESSION, Tree.Kind.INITIALIZER, Tree.Kind.STATIC_INITIALIZER));
        if (currentTree.is(Tree.Kind.METHOD, Tree.Kind.CONSTRUCTOR)) {
            return CFG.build((MethodTree)currentTree);
        }
        if (currentTree.is(Tree.Kind.LAMBDA_EXPRESSION)) {
            currentTree = ((LambdaExpressionTree)currentTree).body();
            if (!currentTree.is(Tree.Kind.BLOCK)) {
                throw new IllegalStateException("Block statement was expected");
            }
        }
        return CFG.buildCFG(((BlockTree)currentTree).body());
    }
}

