/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import org.sonar.check.Rule;
import org.sonar.java.ast.visitors.SubscriptionVisitor;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.java.model.JUtils;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.ArrayTypeTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.CompilationUnitTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.ImportClauseTree;
import org.sonar.plugins.java.api.tree.ImportTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.SyntaxTrivia;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeCastTree;
import org.sonarsource.analyzer.commons.annotations.DeprecatedRuleKey;

@DeprecatedRuleKey(ruleKey="UselessImportCheck", repositoryKey="squid")
@Rule(key="S1128")
public class UselessImportCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final Pattern NON_WORDS_CHARACTERS = Pattern.compile("\\W+");
    private final Map<String, ImportTree> lineByImportReference = new HashMap<String, ImportTree>();
    private final Set<String> pendingImports = new HashSet<String>();
    private final Set<String> pendingReferences = new HashSet<String>();
    private String currentPackage;
    private JavaFileScannerContext context;

    @Override
    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        CompilationUnitTree cut = context.getTree();
        if (cut.moduleDeclaration() != null) {
            return;
        }
        ExpressionTree packageName = UselessImportCheck.getPackageName(cut);
        this.pendingReferences.clear();
        this.lineByImportReference.clear();
        this.pendingImports.clear();
        this.currentPackage = ExpressionsHelper.concatenate(packageName);
        for (ImportClauseTree importClauseTree : cut.imports()) {
            ImportTree importTree = null;
            if (importClauseTree.is(Tree.Kind.IMPORT)) {
                importTree = (ImportTree)importClauseTree;
            }
            if (importTree == null) continue;
            this.reportIssue(importTree);
        }
        this.scan(cut);
        new CommentVisitor().checkImportsFromComments(cut);
        this.leaveFile();
    }

    private void reportIssue(ImportTree importTree) {
        String importName = ExpressionsHelper.concatenate((ExpressionTree)importTree.qualifiedIdentifier());
        if ("java.lang.*".equals(importName)) {
            this.context.reportIssue(this, importTree, "Remove this unnecessary import: java.lang classes are always implicitly imported.");
        } else if (this.isImportFromSamePackage(importName)) {
            this.context.reportIssue(this, importTree, "Remove this unnecessary import: same package classes are always implicitly imported.");
        } else if (!UselessImportCheck.isImportOnDemand(importName)) {
            if (UselessImportCheck.isJavaLangImport(importName)) {
                this.context.reportIssue(this, importTree, "Remove this unnecessary import: java.lang classes are always implicitly imported.");
            } else if (this.isDuplicatedImport(importName)) {
                this.context.reportIssue(this, importTree, "Remove this duplicated import.");
            } else if (importTree.isStatic()) {
                this.checkSymbolUsage(importTree, importName);
            } else {
                this.lineByImportReference.put(importName, importTree);
                this.pendingImports.add(importName);
            }
        }
    }

    private void checkSymbolUsage(ImportTree importTree, String importName) {
        Symbol symbol;
        IdentifierTree id = null;
        if (importTree.qualifiedIdentifier().is(Tree.Kind.IDENTIFIER)) {
            id = (IdentifierTree)importTree.qualifiedIdentifier();
        } else if (importTree.qualifiedIdentifier().is(Tree.Kind.MEMBER_SELECT)) {
            id = ((MemberSelectExpressionTree)importTree.qualifiedIdentifier()).identifier();
        }
        if (id != null && this.context.getSemanticModel() != null && (symbol = JUtils.importTreeSymbol(importTree)) != null) {
            Symbol owner = symbol.owner();
            if (symbol.isVariableSymbol() && symbol.usages().stream().allMatch(identifierTree -> UselessImportCheck.enclosingClass(identifierTree) == owner)) {
                this.context.reportIssue(this, importTree, "Remove this unused import '" + importName + "'.");
            }
        }
    }

    @CheckForNull
    private static Symbol enclosingClass(Tree t) {
        while (t != null && !UselessImportCheck.isClassAnnotation(t)) {
            if (t.is(Tree.Kind.CLASS, Tree.Kind.ENUM, Tree.Kind.INTERFACE, Tree.Kind.ANNOTATION_TYPE)) {
                return ((ClassTree)t).symbol();
            }
            t = t.parent();
        }
        return null;
    }

    private static boolean isClassAnnotation(Tree t) {
        return t.is(Tree.Kind.ANNOTATION) && t.parent().parent().is(Tree.Kind.CLASS, Tree.Kind.ENUM, Tree.Kind.INTERFACE, Tree.Kind.ANNOTATION_TYPE);
    }

    private static ExpressionTree getPackageName(CompilationUnitTree cut) {
        return cut.packageDeclaration() != null ? cut.packageDeclaration().packageName() : null;
    }

    private static boolean isImportOnDemand(String name) {
        return name.endsWith("*");
    }

    @Override
    public void visitCompilationUnit(CompilationUnitTree tree) {
        if (tree.packageDeclaration() != null) {
            this.scan(tree.packageDeclaration().annotations());
        }
        this.scan(tree.types());
    }

    @Override
    public void visitIdentifier(IdentifierTree tree) {
        this.scan(tree.annotations());
        this.pendingReferences.add(tree.name());
    }

    @Override
    public void visitArrayType(ArrayTypeTree tree) {
        this.scan(tree.annotations());
        super.visitArrayType(tree);
    }

    @Override
    public void visitTypeCast(TypeCastTree tree) {
        this.scan(tree.bounds());
        super.visitTypeCast(tree);
    }

    @Override
    public void visitMemberSelectExpression(MemberSelectExpressionTree tree) {
        this.scan(tree.annotations());
        this.scan(tree.identifier().annotations());
        this.pendingReferences.add(ExpressionsHelper.concatenate(tree));
        if (!tree.expression().is(Tree.Kind.IDENTIFIER)) {
            this.scan(tree.expression());
        }
    }

    private boolean isImportFromSamePackage(String reference) {
        String importName = reference;
        if (UselessImportCheck.isImportOnDemand(reference)) {
            importName = reference.substring(0, reference.length() - 2);
        }
        return !this.currentPackage.isEmpty() && (importName.equals(this.currentPackage) || reference.startsWith(this.currentPackage) && reference.charAt(this.currentPackage.length()) == '.' && reference.indexOf(46, this.currentPackage.length() + 1) == -1);
    }

    private boolean isDuplicatedImport(String reference) {
        return this.pendingImports.contains(reference);
    }

    private static boolean isJavaLangImport(String reference) {
        return reference.startsWith("java.lang.") && reference.indexOf(46, "java.lang.".length()) == -1;
    }

    public void leaveFile() {
        for (String reference : this.pendingReferences) {
            this.updatePendingImports(reference);
        }
        for (String pendingImport : this.pendingImports) {
            this.context.reportIssue(this, this.lineByImportReference.get(pendingImport), "Remove this unused import '" + pendingImport + "'.");
        }
    }

    private void updatePendingImports(String reference) {
        String firstClassReference = reference;
        if (UselessImportCheck.isFullyQualified(firstClassReference)) {
            firstClassReference = UselessImportCheck.extractFirstClassName(firstClassReference);
        }
        Iterator<String> it = this.pendingImports.iterator();
        while (it.hasNext()) {
            String pendingImport = it.next();
            if (!pendingImport.endsWith("." + firstClassReference)) continue;
            it.remove();
        }
    }

    private static boolean isFullyQualified(String reference) {
        return reference.indexOf(46) != -1;
    }

    private static String extractFirstClassName(String reference) {
        int firstIndexOfDot = reference.indexOf(46);
        return firstIndexOfDot == -1 ? reference : reference.substring(0, firstIndexOfDot);
    }

    private class CommentVisitor
    extends SubscriptionVisitor {
        private CommentVisitor() {
        }

        @Override
        public List<Tree.Kind> nodesToVisit() {
            return Collections.singletonList(Tree.Kind.TRIVIA);
        }

        public void checkImportsFromComments(CompilationUnitTree cut) {
            this.scanTree(cut);
        }

        @Override
        public void visitTrivia(SyntaxTrivia syntaxTrivia) {
            this.updatePendingImportsForComments(syntaxTrivia.comment());
        }

        private void updatePendingImportsForComments(String comment) {
            Set words = NON_WORDS_CHARACTERS.splitAsStream(comment).filter(w -> !w.isEmpty()).collect(Collectors.toSet());
            if (!words.isEmpty()) {
                UselessImportCheck.this.pendingImports.removeIf(pendingImport -> words.contains(this.extractLastClassName((String)pendingImport)));
            }
        }

        private String extractLastClassName(String reference) {
            int lastIndexOfDot = reference.lastIndexOf(46);
            return lastIndexOfDot == -1 ? reference : reference.substring(lastIndexOfDot + 1);
        }
    }
}

