/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S4510")
public class XmlDeserializationCheck
extends AbstractMethodDetection {
    private static final MethodMatchers READ_OBJECT = MethodMatchers.create().ofTypes("java.beans.XMLDecoder").names("readObject").withAnyParameters().build();
    private static final String MESSAGE = "Make sure deserializing with XMLDecoder is safe here.";

    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.create().ofTypes("java.beans.XMLDecoder").constructor().withAnyParameters().build();
    }

    @Override
    protected void onConstructorFound(NewClassTree newClassTree) {
        List<JavaFileScannerContext.Location> secondaries = XmlDeserializationCheck.collectSecondaryLocations(newClassTree);
        this.reportIssue(newClassTree.identifier(), MESSAGE, secondaries, null);
    }

    private static List<JavaFileScannerContext.Location> collectSecondaryLocations(NewClassTree newClassTree) {
        Tree parentMethodOrClass = XmlDeserializationCheck.parentMethod(newClassTree);
        if (parentMethodOrClass == null) {
            return Collections.emptyList();
        }
        final ArrayList<JavaFileScannerContext.Location> secondaries = new ArrayList<JavaFileScannerContext.Location>();
        parentMethodOrClass.accept(new BaseTreeVisitor(){

            @Override
            public void visitMethodInvocation(MethodInvocationTree tree) {
                if (READ_OBJECT.matches(tree)) {
                    secondaries.add(new JavaFileScannerContext.Location("Possible data execution", tree));
                }
            }
        });
        return secondaries;
    }

    @CheckForNull
    private static Tree parentMethod(NewClassTree newClassTree) {
        Tree parent;
        for (parent = newClassTree.parent(); parent != null && !parent.is(Tree.Kind.METHOD, Tree.Kind.CLASS); parent = parent.parent()) {
        }
        return parent;
    }
}

