/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.regex;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.IntersectAutomataChecker;
import org.sonar.java.checks.helpers.RegexReachabilityChecker;
import org.sonar.java.checks.helpers.RegexTreeHelper;
import org.sonar.java.checks.helpers.SimplifiedRegexCharacterClass;
import org.sonar.java.checks.helpers.SubAutomaton;
import org.sonar.java.checks.regex.AbstractRegexCheckTrackingMatchType;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonarsource.analyzer.commons.regex.RegexParseResult;
import org.sonarsource.analyzer.commons.regex.ast.AtomicGroupTree;
import org.sonarsource.analyzer.commons.regex.ast.AutomatonState;
import org.sonarsource.analyzer.commons.regex.ast.BackReferenceTree;
import org.sonarsource.analyzer.commons.regex.ast.CharacterClassElementTree;
import org.sonarsource.analyzer.commons.regex.ast.DisjunctionTree;
import org.sonarsource.analyzer.commons.regex.ast.DotTree;
import org.sonarsource.analyzer.commons.regex.ast.GroupTree;
import org.sonarsource.analyzer.commons.regex.ast.RegexBaseVisitor;
import org.sonarsource.analyzer.commons.regex.ast.RegexTree;
import org.sonarsource.analyzer.commons.regex.ast.RepetitionTree;

@Rule(key="S5852")
public class RedosCheck
extends AbstractRegexCheckTrackingMatchType {
    private static final String MESSAGE = "Make sure the regex used here, which is vulnerable to %s runtime due to backtracking, cannot lead to denial of service%s.";
    private static final String JAVA8_MESSAGE = " or make sure the code is only run using Java 9 or later";
    private static final String EXP = "exponential";
    private static final String POLY = "polynomial";
    private static final int MAX_TRACKED_REPETITIONS = 10;
    private static final int MAX_REGEX_LENGTH = 1000;
    private boolean regexContainsBackReference;
    private BacktrackingType foundBacktrackingType;
    private final RegexReachabilityChecker reachabilityChecker = new RegexReachabilityChecker(false);
    private final IntersectAutomataChecker intersectionChecker = new IntersectAutomataChecker(false);

    private boolean isJava9OrHigher() {
        return this.context.getJavaVersion().isNotSet() || this.context.getJavaVersion().asInt() >= 9;
    }

    private Optional<String> message() {
        boolean canBeOptimized = !this.regexContainsBackReference;
        boolean optimized = this.isJava9OrHigher() && canBeOptimized;
        switch (this.foundBacktrackingType) {
            case ALWAYS_EXPONENTIAL: {
                return Optional.of(String.format(MESSAGE, EXP, ""));
            }
            case QUADRATIC_WHEN_OPTIMIZED: {
                return Optional.of(String.format(MESSAGE, optimized ? POLY : EXP, ""));
            }
            case LINEAR_WHEN_OPTIMIZED: {
                if (optimized) {
                    return Optional.empty();
                }
                return Optional.of(String.format(MESSAGE, EXP, canBeOptimized ? JAVA8_MESSAGE : ""));
            }
            case ALWAYS_QUADRATIC: {
                return Optional.of(String.format(MESSAGE, POLY, ""));
            }
            case NO_ISSUE: {
                return Optional.empty();
            }
        }
        throw new IllegalStateException("This line is not actually reachable");
    }

    @Override
    public void checkRegex(RegexParseResult regexForLiterals, ExpressionTree methodInvocationOrAnnotation, AbstractRegexCheckTrackingMatchType.MatchType matchType) {
        if (regexForLiterals.getResult().getText().length() > 1000) {
            return;
        }
        this.regexContainsBackReference = false;
        this.foundBacktrackingType = BacktrackingType.NO_ISSUE;
        this.reachabilityChecker.clearCache();
        this.intersectionChecker.clearCache();
        boolean isUsedForFullMatch = matchType == AbstractRegexCheckTrackingMatchType.MatchType.FULL || matchType == AbstractRegexCheckTrackingMatchType.MatchType.BOTH;
        boolean isUsedForPartialMatch = matchType == AbstractRegexCheckTrackingMatchType.MatchType.PARTIAL || matchType == AbstractRegexCheckTrackingMatchType.MatchType.BOTH;
        RedosFinder visitor = new RedosFinder(regexForLiterals.getStartState(), regexForLiterals.getFinalState(), isUsedForFullMatch, isUsedForPartialMatch);
        visitor.visit(regexForLiterals);
        this.message().ifPresent(message -> this.reportIssue(this.methodOrAnnotationName(methodInvocationOrAnnotation), (String)message, null, Collections.emptyList()));
    }

    private void addBacktracking(BacktrackingType newBacktrackingType) {
        if (newBacktrackingType.ordinal() < this.foundBacktrackingType.ordinal()) {
            this.foundBacktrackingType = newBacktrackingType;
        }
    }

    private class BacktrackingFinder
    extends RegexBaseVisitor {
        private final boolean isReluctant;
        private final AutomatonState endOfLoop;

        public BacktrackingFinder(boolean isReluctant, AutomatonState endOfLoop) {
            this.isReluctant = isReluctant;
            this.endOfLoop = endOfLoop;
        }

        @Override
        public void visitAtomicGroup(AtomicGroupTree tree) {
            new RedosFinder(tree, tree.continuation(), false, false).visit(tree);
        }

        @Override
        public void visitRepetition(RepetitionTree tree) {
            if (tree.isPossessive()) {
                new RedosFinder(tree, tree.continuation(), false, false).visit(tree);
            } else if (this.containsIntersections(Arrays.asList(tree.getElement(), tree.continuation()))) {
                BacktrackingType greedyComplexity = tree.getQuantifier().isOpenEnded() ? BacktrackingType.QUADRATIC_WHEN_OPTIMIZED : BacktrackingType.LINEAR_WHEN_OPTIMIZED;
                RedosCheck.this.addBacktracking(this.isReluctant ? BacktrackingType.ALWAYS_EXPONENTIAL : greedyComplexity);
                super.visitRepetition(tree);
            } else {
                super.visitRepetition(tree);
            }
        }

        @Override
        public void visitDisjunction(DisjunctionTree tree) {
            if (this.containsIntersections(tree.getAlternatives())) {
                RedosCheck.this.addBacktracking(this.isReluctant ? BacktrackingType.ALWAYS_EXPONENTIAL : BacktrackingType.LINEAR_WHEN_OPTIMIZED);
            } else {
                super.visitDisjunction(tree);
            }
        }

        @Override
        public void visitBackReference(BackReferenceTree tree) {
            RedosCheck.this.regexContainsBackReference = true;
        }

        boolean containsIntersections(List<? extends AutomatonState> alternatives) {
            for (int i = 0; i < alternatives.size() - 1; ++i) {
                AutomatonState state1 = alternatives.get(i);
                for (int j = i + 1; j < alternatives.size(); ++j) {
                    AutomatonState state2 = alternatives.get(j);
                    SubAutomaton auto1 = new SubAutomaton(state1, this.endOfLoop, false);
                    SubAutomaton auto2 = new SubAutomaton(state2, this.endOfLoop, false);
                    if (!RedosCheck.this.intersectionChecker.check(auto1, auto2)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private class RedosFinder
    extends RegexBaseVisitor {
        private final Deque<RepetitionTree> nonPossessiveRepetitions = new ArrayDeque<RepetitionTree>();
        private final Map<AutomatonState, Boolean> canFailCache = new HashMap<AutomatonState, Boolean>();
        private final AutomatonState startOfRegex;
        private final AutomatonState endOfRegex;
        private final boolean isUsedForFullMatch;
        private final boolean isUsedForPartialMatch;

        public RedosFinder(AutomatonState startOfRegex, AutomatonState endOfRegex, boolean isUsedForFullMatch, boolean isUsedForPartialMatch) {
            this.startOfRegex = startOfRegex;
            this.endOfRegex = endOfRegex;
            this.isUsedForFullMatch = isUsedForFullMatch;
            this.isUsedForPartialMatch = isUsedForPartialMatch;
        }

        @Override
        public void visitRepetition(RepetitionTree tree) {
            if (this.canFail(tree.continuation())) {
                if (!tree.isPossessive() && tree.getQuantifier().isOpenEnded()) {
                    new BacktrackingFinder(tree.isReluctant(), tree.continuation()).visit(tree.getElement());
                } else {
                    super.visitRepetition(tree);
                }
                this.checkForOverlappingRepetitions(tree);
            }
        }

        private void checkForOverlappingRepetitions(RepetitionTree tree) {
            if (tree.getQuantifier().isOpenEnded() && this.canFail(tree)) {
                for (RepetitionTree repetition : this.nonPossessiveRepetitions) {
                    if (!RedosCheck.this.reachabilityChecker.canReach(repetition, tree)) continue;
                    SubAutomaton repetitionAuto = new SubAutomaton(repetition.getElement(), repetition.continuation(), false);
                    SubAutomaton continuationAuto = new SubAutomaton(repetition.continuation(), tree, false);
                    SubAutomaton treeAuto = new SubAutomaton(tree.getElement(), tree.continuation(), false);
                    if (!this.subAutomatonCanConsume(repetitionAuto, continuationAuto) || !this.automatonIsEmptyOrIntersects(continuationAuto, treeAuto) || !RedosCheck.this.intersectionChecker.check(repetitionAuto, treeAuto)) continue;
                    RedosCheck.this.addBacktracking(BacktrackingType.ALWAYS_QUADRATIC);
                }
                if (this.overlapsWithImplicitMatchAlls(tree)) {
                    RedosCheck.this.addBacktracking(BacktrackingType.ALWAYS_QUADRATIC);
                }
                this.addIfNonPossessive(tree);
            }
        }

        private boolean subAutomatonCanConsume(SubAutomaton auto1, SubAutomaton auto2) {
            return RegexTreeHelper.canReachWithoutConsumingInputOrGoingThroughBoundaries(auto1.end, auto2.end) || RedosCheck.this.intersectionChecker.check(auto1, auto2);
        }

        private boolean automatonIsEmptyOrIntersects(SubAutomaton auto1, SubAutomaton auto2) {
            return RegexTreeHelper.canReachWithoutConsumingInputOrGoingThroughBoundaries(auto1.start, auto1.end) || RedosCheck.this.intersectionChecker.check(auto1, auto2);
        }

        private void addIfNonPossessive(RepetitionTree tree) {
            if (!tree.isPossessive()) {
                this.nonPossessiveRepetitions.add(tree);
                if (this.nonPossessiveRepetitions.size() > 10) {
                    this.nonPossessiveRepetitions.removeFirst();
                }
            }
        }

        private boolean overlapsWithImplicitMatchAlls(RepetitionTree tree) {
            return this.isUsedForPartialMatch && RegexTreeHelper.canReachWithoutConsumingInputOrGoingThroughBoundaries(this.startOfRegex, tree);
        }

        @Override
        public void visitBackReference(BackReferenceTree tree) {
            RedosCheck.this.regexContainsBackReference = true;
        }

        private boolean canFail(AutomatonState state) {
            return this.canFail(state, !this.isUsedForFullMatch && !RegexTreeHelper.isAnchoredAtEnd(state));
        }

        private boolean canFail(AutomatonState state, boolean succeedOnEnd) {
            if (this.canFailCache.containsKey(state)) {
                return this.canFailCache.get(state);
            }
            this.canFailCache.put(state, true);
            if (state.incomingTransitionType() != AutomatonState.TransitionType.EPSILON) {
                return true;
            }
            if (this.canMatchAnything(state)) {
                succeedOnEnd = true;
                state = state.continuation();
            }
            if (succeedOnEnd && RegexTreeHelper.canReachWithoutConsumingInput(state, this.endOfRegex)) {
                this.canFailCache.put(state, false);
                return false;
            }
            for (AutomatonState automatonState : state.successors()) {
                if (this.canFail(automatonState, succeedOnEnd)) continue;
                this.canFailCache.put(state, false);
                return false;
            }
            return true;
        }

        private boolean canMatchAnything(AutomatonState state) {
            if (!(state instanceof RepetitionTree)) {
                return false;
            }
            RepetitionTree repetition = (RepetitionTree)state;
            return repetition.getQuantifier().getMinimumRepetitions() == 0 && repetition.getQuantifier().isOpenEnded() && this.canMatchAnyCharacter(repetition.getElement());
        }

        private boolean canMatchAnyCharacter(RegexTree tree) {
            SimplifiedRegexCharacterClass characterClass = new SimplifiedRegexCharacterClass();
            for (RegexTree singleCharacter : this.collectSingleCharacters(tree, new ArrayList<RegexTree>())) {
                if (singleCharacter.is(RegexTree.Kind.DOT)) {
                    characterClass.add((DotTree)singleCharacter);
                    continue;
                }
                characterClass.add((CharacterClassElementTree)((Object)singleCharacter));
            }
            return characterClass.matchesAnyCharacter();
        }

        private List<RegexTree> collectSingleCharacters(@Nullable RegexTree tree, List<RegexTree> accumulator) {
            RepetitionTree repetition;
            if (tree == null) {
                return accumulator;
            }
            if (tree instanceof CharacterClassElementTree || tree.is(RegexTree.Kind.DOT)) {
                accumulator.add(tree);
            } else if (tree.is(RegexTree.Kind.DISJUNCTION)) {
                for (RegexTree alternative : ((DisjunctionTree)tree).getAlternatives()) {
                    this.collectSingleCharacters(alternative, accumulator);
                }
            } else if (tree instanceof GroupTree) {
                this.collectSingleCharacters(((GroupTree)tree).getElement(), accumulator);
            } else if (tree.is(RegexTree.Kind.REPETITION) && (repetition = (RepetitionTree)tree).getQuantifier().getMinimumRepetitions() <= 1) {
                this.collectSingleCharacters(repetition.getElement(), accumulator);
            }
            return accumulator;
        }
    }

    static enum BacktrackingType {
        ALWAYS_EXPONENTIAL,
        QUADRATIC_WHEN_OPTIMIZED,
        ALWAYS_QUADRATIC,
        LINEAR_WHEN_OPTIMIZED,
        NO_ISSUE;

    }
}

