/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.tests;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.sonar.java.checks.helpers.UnitTestUtils;
import org.sonar.java.checks.tests.AssertJChainSimplificationCheck;
import org.sonar.java.checks.tests.AssertJChainSimplificationHelper;
import org.sonar.java.collections.MapBuilder;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.UnaryExpressionTree;

public class AssertJChainSimplificationIndex {
    private static final String JAVA_LANG_STRING = "java.lang.String";
    private static final String JAVA_UTIL_MAP = "java.util.Map";
    private static final String JAVA_UTIL_COLLECTION = "java.util.Collection";
    private static final String JAVA_IO_FILE = "java.io.File";
    private static final String JAVA_NIO_FILE_PATH = "java.nio.file.Path";
    private static final String JAVA_UTIL_OPTIONAL = "java.util.Optional";
    private static final String CONTAINS = "contains";
    private static final String CONTAINS_KEY = "containsKey";
    private static final String CONTAINS_VALUE = "containsValue";
    private static final String DOES_NOT_CONTAIN = "doesNotContain";
    private static final String DOES_NOT_START_WITH = "doesNotStartWith";
    private static final String HAS_SIZE = "hasSize";
    private static final String IS_BLANK = "isBlank";
    private static final String IS_EMPTY = "isEmpty";
    private static final String IS_EQUAL_TO = "isEqualTo";
    private static final String IS_EQUAL_TO_IGNORING_CASE = "isEqualToIgnoringCase";
    private static final String IS_FALSE = "isFalse";
    private static final String IS_GREATER_THAN = "isGreaterThan";
    private static final String IS_GREATER_THAN_OR_EQUAL_TO = "isGreaterThanOrEqualTo";
    private static final String IS_LESS_THAN = "isLessThan";
    private static final String IS_LESS_THAN_OR_EQUAL_TO = "isLessThanOrEqualTo";
    private static final String IS_NEGATIVE = "isNegative";
    private static final String IS_NOT_BLANK = "isNotBlank";
    private static final String IS_NOT_EMPTY = "isNotEmpty";
    private static final String IS_NOT_EQUAL_TO = "isNotEqualTo";
    private static final String IS_NOT_EQUAL_TO_IGNORING_CASE = "isNotEqualToIgnoringCase";
    private static final String IS_NOT_NEGATIVE = "isNotNegative";
    private static final String IS_NOT_NULL = "isNotNull";
    private static final String IS_NOT_POSITIVE = "isNotPositive";
    private static final String IS_NOT_PRESENT = "isNotPresent";
    private static final String IS_NOT_ZERO = "isNotZero";
    private static final String IS_POSITIVE = "isPositive";
    private static final String IS_PRESENT = "isPresent";
    private static final String IS_SAME_AS = "isSameAs";
    private static final String IS_TRUE = "isTrue";
    private static final String IS_ZERO = "isZero";
    private static final String IS_NULL = "isNull";
    private static final String STARTS_WITH = "startsWith";
    private static final String ENDS_WITH = "endsWith";
    private static final String HAS_SAME_SIZE_AS = "hasSameSizeAs";
    private static final String LENGTH = "length";
    private static final String OPTIONAL_PRESENT_REPLACEMENT = AssertJChainSimplificationHelper.msgWithActual("isPresent");
    private static final String OPTIONAL_EMPTY_REPLACEMENT = String.format("%s or %s", AssertJChainSimplificationHelper.msgWithActual("isNotPresent"), AssertJChainSimplificationHelper.msgWithActual("isEmpty"));
    static final Map<String, List<AssertJChainSimplificationCheck.SimplifierWithoutContext>> CONTEXT_FREE_SIMPLIFIERS = MapBuilder.newMap().put("hasSize", Collections.singletonList(PredicateSimplifierWithoutContext.withSingleArg(LiteralUtils::isZero, "isEmpty()"))).put("isEqualTo", Collections.singletonList(PredicateSimplifierWithoutContext.withSingleArg(ExpressionUtils::isNullLiteral, "isNull()"))).put("isGreaterThan", Arrays.asList(PredicateSimplifierWithoutContext.withSingleArg(AssertJChainSimplificationIndex::isNegOneIntOrLong, "isNotNegative()"), PredicateSimplifierWithoutContext.withSingleArg(AssertJChainSimplificationIndex::isZeroIntOrLong, "isPositive()"))).put("isGreaterThanOrEqualTo", Arrays.asList(PredicateSimplifierWithoutContext.withSingleArg(AssertJChainSimplificationIndex::isZeroIntOrLong, "isNotNegative()"), PredicateSimplifierWithoutContext.withSingleArg(AssertJChainSimplificationIndex::isOneIntOrLong, "isPositive()"))).put("isLessThan", Arrays.asList(PredicateSimplifierWithoutContext.withSingleArg(AssertJChainSimplificationIndex::isZeroIntOrLong, "isNegative()"), PredicateSimplifierWithoutContext.withSingleArg(AssertJChainSimplificationIndex::isOneIntOrLong, "isNotPositive()"))).put("isLessThanOrEqualTo", Arrays.asList(PredicateSimplifierWithoutContext.withSingleArg(AssertJChainSimplificationIndex::isNegOneIntOrLong, "isNegative()"), PredicateSimplifierWithoutContext.withSingleArg(AssertJChainSimplificationIndex::isZeroIntOrLong, "isNotPositive()"))).put("isNotEqualTo", Collections.singletonList(PredicateSimplifierWithoutContext.withSingleArg(subject -> ExpressionUtils.isNullLiteral(subject) && !UnitTestUtils.isInUnitTestRelatedToObjectMethods(subject), "isNotNull()"))).build();
    static final Map<String, List<AssertJChainSimplificationCheck.SimplifierWithContext>> SIMPLIFIERS_WITH_CONTEXT = MapBuilder.newMap().put("isEqualTo", Arrays.asList(PredicateSimplifierWithContext.withSubjectArgumentCondition(LiteralUtils::isTrue, AssertJChainSimplificationIndex::isNotObject, "isTrue()"), PredicateSimplifierWithContext.withSubjectArgumentCondition(LiteralUtils::isFalse, AssertJChainSimplificationIndex::isNotObject, "isFalse()"), PredicateSimplifierWithContext.withSubjectArgumentCondition(LiteralUtils::isEmptyString, AssertJChainSimplificationIndex::isNotObject, "isEmpty()"), PredicateSimplifierWithContext.withSubjectArgumentCondition(AssertJChainSimplificationIndex::isZeroIntOrLong, AssertJChainSimplificationIndex::isNotObject, "isZero()"), PredicateSimplifierWithContext.methodCallInSubject(Matchers.TO_STRING, AssertJChainSimplificationHelper.msgWithActualCustom("hasToString", "expectedString")), PredicateSimplifierWithContext.methodCallInSubject(predicateArg -> AssertJChainSimplificationHelper.hasMethodCallAsArg(predicateArg, Matchers.HASH_CODE), Matchers.HASH_CODE, AssertJChainSimplificationHelper.msgWithActualExpected("hasSameHashCodeAs")), AssertJChainSimplificationIndex.compareToSimplifier(LiteralUtils::isZero, AssertJChainSimplificationHelper.msgWithActualExpected("isEqualByComparingTo")), PredicateSimplifierWithContext.methodCallInSubject(LiteralUtils::isZero, Matchers.COMPARE_TO_IGNORE_CASE, AssertJChainSimplificationHelper.msgWithActualExpected("isEqualToIgnoringCase")), AssertJChainSimplificationIndex.indexOfSimplifier(LiteralUtils::isZero, "startsWith"), AssertJChainSimplificationIndex.indexOfSimplifier(LiteralUtils::isNegOne, "doesNotContain"), PredicateSimplifierWithContext.methodCallInSubject(LiteralUtils::isZero, Matchers.STRING_LENGTH, AssertJChainSimplificationHelper.msgWithActual("isEmpty")), PredicateSimplifierWithContext.methodCallInSubject(predicateArg -> AssertJChainSimplificationHelper.hasMethodCallAsArg(predicateArg, Matchers.STRING_LENGTH), Matchers.STRING_LENGTH, AssertJChainSimplificationHelper.msgWithActualExpected("hasSameSizeAs")), PredicateSimplifierWithContext.methodCallInSubject(predicateArg -> AssertJChainSimplificationHelper.hasMethodCallAsArg(predicateArg, Matchers.COLLECTION_SIZE), Matchers.COLLECTION_SIZE, AssertJChainSimplificationHelper.msgWithActualExpected("hasSameSizeAs")), PredicateSimplifierWithContext.withSubjectArgumentCondition(AssertJChainSimplificationIndex::isArrayLength, AssertJChainSimplificationIndex::isArrayLength, AssertJChainSimplificationHelper.msgWithActualExpected("hasSameSizeAs")), AssertJChainSimplificationIndex.arrayLengthSimplifier(AssertJChainSimplificationHelper.msgWithActualExpected("hasSize")), PredicateSimplifierWithContext.methodCallInSubject(MethodMatchers.or(Matchers.STRING_LENGTH, Matchers.COLLECTION_SIZE), AssertJChainSimplificationHelper.msgWithActualExpected("hasSize")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.FILE_LENGTH, AssertJChainSimplificationHelper.msgWithActualExpected("hasSize")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.FILE_GET_NAME, AssertJChainSimplificationHelper.msgWithActualExpected("hasName")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.FILE_GET_PARENT_AND_PARENT_FILE, AssertJChainSimplificationHelper.msgWithActualExpected("hasParent")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.PATH_GET_PARENT_AND_PARENT_FILE, AssertJChainSimplificationHelper.msgWithActualExpected("hasParentRaw")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.MAP_GET, AssertJChainSimplificationHelper.msgWithActualCustom("containsEntry", "key, value")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.PATH_GET_PARENT_AND_PARENT_FILE, AssertJChainSimplificationHelper.msgWithActualExpected("hasParentRaw")), PredicateSimplifierWithContext.withSubjectArgumentCondition(predicateArg -> AssertJChainSimplificationHelper.hasMethodCallAsArg(predicateArg, Matchers.EMPTY), subjectArg -> subjectArg.symbolType().is(JAVA_UTIL_OPTIONAL), OPTIONAL_EMPTY_REPLACEMENT), PredicateSimplifierWithContext.methodCallInSubject(Matchers.GET, AssertJChainSimplificationHelper.msgWithActualExpected("contains")))).put("isFalse", Arrays.asList(PredicateSimplifierWithContext.methodCallInSubject(Matchers.EQUALS_METHOD, AssertJChainSimplificationHelper.msgWithActualExpected("isNotEqualTo")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.CONTENT_EQUALS, AssertJChainSimplificationHelper.msgWithActualExpected("isNotEqualTo")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.EQUALS_IGNORE_CASE, AssertJChainSimplificationHelper.msgWithActualExpected("isNotEqualToIgnoringCase")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.CONTAINS, AssertJChainSimplificationHelper.msgWithActualExpected("doesNotContain")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.STARTS_WITH, AssertJChainSimplificationHelper.msgWithActualExpected("doesNotStartWith")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.ENDS_WITH, AssertJChainSimplificationHelper.msgWithActualExpected("doesNotEndWith")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.MATCHES, AssertJChainSimplificationHelper.msgWithActualExpected("doesNotMatch")), PredicateSimplifierWithContext.withSubjectArgumentCondition(arg -> AssertJChainSimplificationHelper.ArgumentHelper.equalsTo(arg, ExpressionUtils::isNullLiteral), AssertJChainSimplificationHelper.msgWithActual("isNotNull")), PredicateSimplifierWithContext.withSubjectArgumentCondition(arg -> AssertJChainSimplificationHelper.ArgumentHelper.notEqualsTo(arg, ExpressionUtils::isNullLiteral), AssertJChainSimplificationHelper.msgWithActual("isNull")), PredicateSimplifierWithContext.withSubjectArgumentCondition(arg -> arg.is(Tree.Kind.EQUAL_TO), AssertJChainSimplificationHelper.msgWithActualExpected("isNotSameAs")), PredicateSimplifierWithContext.withSubjectArgumentCondition(arg -> arg.is(Tree.Kind.NOT_EQUAL_TO), AssertJChainSimplificationHelper.msgWithActualExpected("isSameAs")), PredicateSimplifierWithContext.withSubjectArgumentCondition(arg -> arg.is(Tree.Kind.INSTANCE_OF), AssertJChainSimplificationHelper.msgWithActualCustom("isNotInstanceOf", "ExpectedClass.class")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.IS_BLANK, AssertJChainSimplificationHelper.msgWithActual("isNotBlank")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.IS_EMPTY_GENERIC, AssertJChainSimplificationHelper.msgWithActual("isNotEmpty")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.FILE_EXISTS, AssertJChainSimplificationHelper.msgWithActual("doesNotExist")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.FILE_AND_PATH_IS_ABSOLUTE, AssertJChainSimplificationHelper.msgWithActual("isRelative")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.IS_PRESENT, OPTIONAL_EMPTY_REPLACEMENT), PredicateSimplifierWithContext.methodCallInSubject(Matchers.IS_EMPTY_OPTIONAL, OPTIONAL_PRESENT_REPLACEMENT))).put("isNegative", Arrays.asList(AssertJChainSimplificationIndex.compareToSimplifier(AssertJChainSimplificationHelper.msgWithActualExpected("isLessThan")), AssertJChainSimplificationIndex.indexOfSimplifier("doesNotContain"))).put("isEmpty", Collections.singletonList(PredicateSimplifierWithContext.methodCallInSubject(Matchers.FILE_LIST_AND_LIST_FILE, AssertJChainSimplificationHelper.msgWithActual("isEmptyDirectory")))).put("isNotEmpty", Arrays.asList(PredicateSimplifierWithContext.methodCallInSubject(Matchers.TRIM, AssertJChainSimplificationHelper.msgWithActual("isNotBlank")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.FILE_LIST_AND_LIST_FILE, AssertJChainSimplificationHelper.msgWithActual("isNotEmptyDirectory")))).put("isNotEqualTo", Arrays.asList(PredicateSimplifierWithContext.withSubjectArgumentCondition(AssertJChainSimplificationIndex::isZeroIntOrLong, AssertJChainSimplificationIndex::isNotObject, "isNotZero()"), AssertJChainSimplificationIndex.compareToSimplifier(LiteralUtils::isZero, AssertJChainSimplificationHelper.msgWithActualExpected("isNotEqualByComparingTo")), PredicateSimplifierWithContext.methodCallInSubject(LiteralUtils::isZero, Matchers.COMPARE_TO_IGNORE_CASE, AssertJChainSimplificationHelper.msgWithActualExpected("isNotEqualToIgnoringCase")), AssertJChainSimplificationIndex.indexOfSimplifier(LiteralUtils::isZero, "doesNotStartWith"), PredicateSimplifierWithContext.methodCallInSubject(LiteralUtils::isEmptyString, Matchers.TRIM, AssertJChainSimplificationHelper.msgWithActual("isNotBlank")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.MAP_GET, AssertJChainSimplificationHelper.msgWithActualCustom("doesNotContainEntry", "key, value")), PredicateSimplifierWithContext.methodCallInSubject(LiteralUtils::isEmptyString, Matchers.TRIM, AssertJChainSimplificationHelper.msgWithActual("isNotBlank")), PredicateSimplifierWithContext.withSubjectArgumentCondition(predicateArg -> AssertJChainSimplificationHelper.hasMethodCallAsArg(predicateArg, Matchers.EMPTY), subjectArg -> subjectArg.symbolType().is(JAVA_UTIL_OPTIONAL), OPTIONAL_PRESENT_REPLACEMENT))).put("isNotNegative", Arrays.asList(AssertJChainSimplificationIndex.compareToSimplifier(AssertJChainSimplificationHelper.msgWithActualExpected("isGreaterThanOrEqualTo")), AssertJChainSimplificationIndex.indexOfSimplifier("contains"))).put("isNotNull", Collections.singletonList(PredicateSimplifierWithContext.withSubjectArgumentCondition(subjectArg -> AssertJChainSimplificationHelper.hasMethodCallAsArg(subjectArg, Matchers.OR_ELSE) && ExpressionUtils.isNullLiteral((ExpressionTree)((MethodInvocationTree)subjectArg).arguments().get(0)), OPTIONAL_PRESENT_REPLACEMENT))).put("isNotPositive", Arrays.asList(AssertJChainSimplificationIndex.compareToSimplifier(AssertJChainSimplificationHelper.msgWithActualExpected("isLessThanOrEqualTo")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.STRING_LENGTH, AssertJChainSimplificationHelper.msgWithActual("isEmpty")))).put("isNotZero", Arrays.asList(AssertJChainSimplificationIndex.compareToSimplifier(AssertJChainSimplificationHelper.msgWithActualExpected("isNotEqualByComparingTo")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.COMPARE_TO_IGNORE_CASE, AssertJChainSimplificationHelper.msgWithActualExpected("isNotEqualToIgnoringCase")), AssertJChainSimplificationIndex.indexOfSimplifier("doesNotStartWith"), PredicateSimplifierWithContext.methodCallInSubject(Matchers.STRING_LENGTH, AssertJChainSimplificationHelper.msgWithActual("isNotEmpty")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.FILE_LENGTH, AssertJChainSimplificationHelper.msgWithActual("isNotEmpty")), AssertJChainSimplificationIndex.arrayLengthSimplifier(AssertJChainSimplificationHelper.msgWithActual("isNotEmpty")))).put("isPositive", Arrays.asList(AssertJChainSimplificationIndex.compareToSimplifier(AssertJChainSimplificationHelper.msgWithActualExpected("isGreaterThan")), AssertJChainSimplificationIndex.arrayLengthSimplifier(AssertJChainSimplificationHelper.msgWithActual("isNotEmpty")))).put("isSameAs", Collections.singletonList(PredicateSimplifierWithContext.methodCallInSubject(Matchers.GET, AssertJChainSimplificationHelper.msgWithActualExpected("containsSame")))).put("isTrue", Arrays.asList(PredicateSimplifierWithContext.methodCallInSubject(Matchers.EQUALS_METHOD, AssertJChainSimplificationHelper.msgWithActualExpected("isEqualTo")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.CONTENT_EQUALS, AssertJChainSimplificationHelper.msgWithActualExpected("isEqualTo")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.EQUALS_IGNORE_CASE, AssertJChainSimplificationHelper.msgWithActualExpected("isEqualToIgnoringCase")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.CONTAINS, AssertJChainSimplificationHelper.msgWithActualExpected("contains")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.COLLECTION_CONTAINS_ALL, AssertJChainSimplificationHelper.msgWithActualExpected("containsAll")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.STARTS_WITH, AssertJChainSimplificationHelper.msgWithActualExpected("startsWith")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.ENDS_WITH, AssertJChainSimplificationHelper.msgWithActualExpected("endsWith")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.MATCHES, AssertJChainSimplificationHelper.msgWithActualExpected("matches")), PredicateSimplifierWithContext.withSubjectArgumentCondition(arg -> AssertJChainSimplificationHelper.ArgumentHelper.equalsTo(arg, ExpressionUtils::isNullLiteral), AssertJChainSimplificationHelper.msgWithActual("isNull")), PredicateSimplifierWithContext.withSubjectArgumentCondition(arg -> AssertJChainSimplificationHelper.ArgumentHelper.notEqualsTo(arg, ExpressionUtils::isNullLiteral), AssertJChainSimplificationHelper.msgWithActual("isNotNull")), PredicateSimplifierWithContext.withSubjectArgumentCondition(arg -> arg.is(Tree.Kind.EQUAL_TO), AssertJChainSimplificationHelper.msgWithActualExpected("isSameAs")), PredicateSimplifierWithContext.withSubjectArgumentCondition(arg -> arg.is(Tree.Kind.NOT_EQUAL_TO), AssertJChainSimplificationHelper.msgWithActualExpected("isNotSameAs")), PredicateSimplifierWithContext.withSubjectArgumentCondition(arg -> arg.is(Tree.Kind.INSTANCE_OF), AssertJChainSimplificationHelper.msgWithActualCustom("isInstanceOf", "ExpectedClass.class")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.IS_BLANK, AssertJChainSimplificationHelper.msgWithActual("isBlank")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.IS_EMPTY_GENERIC, AssertJChainSimplificationHelper.msgWithActual("isEmpty")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.FILE_CAN_READ, AssertJChainSimplificationHelper.msgWithActual("canRead")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.FILE_CAN_WRITE, AssertJChainSimplificationHelper.msgWithActual("canWrite")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.FILE_EXISTS, AssertJChainSimplificationHelper.msgWithActual("exists")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.FILE_AND_PATH_IS_ABSOLUTE, AssertJChainSimplificationHelper.msgWithActual("isAbsolute")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.FILE_IS_DIRECTORY, AssertJChainSimplificationHelper.msgWithActual("isDirectory")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.FILE_IS_FILE, AssertJChainSimplificationHelper.msgWithActual("isFile")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.PATH_STARTS_WITH, AssertJChainSimplificationHelper.msgWithActualExpected("startsWithRaw")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.PATH_ENDS_WITH, AssertJChainSimplificationHelper.msgWithActualExpected("endsWithRaw")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.IS_EMPTY_GENERIC, AssertJChainSimplificationHelper.msgWithActual("isEmpty")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.MAP_CONTAINS_KEY, AssertJChainSimplificationHelper.msgWithActualExpected("containsKey")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.MAP_CONTAINS_VALUE, AssertJChainSimplificationHelper.msgWithActualExpected("containsValue")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.IS_PRESENT, OPTIONAL_PRESENT_REPLACEMENT), PredicateSimplifierWithContext.methodCallInSubject(Matchers.IS_EMPTY_OPTIONAL, OPTIONAL_EMPTY_REPLACEMENT))).put("isZero", Arrays.asList(AssertJChainSimplificationIndex.compareToSimplifier(AssertJChainSimplificationHelper.msgWithActualExpected("isEqualByComparingTo")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.COMPARE_TO_IGNORE_CASE, AssertJChainSimplificationHelper.msgWithActualExpected("isEqualToIgnoringCase")), AssertJChainSimplificationIndex.indexOfSimplifier("startsWith"), PredicateSimplifierWithContext.methodCallInSubject(Matchers.STRING_LENGTH, AssertJChainSimplificationHelper.msgWithActual("isEmpty")), PredicateSimplifierWithContext.methodCallInSubject(MethodMatchers.or(Matchers.STRING_LENGTH, Matchers.COLLECTION_SIZE), AssertJChainSimplificationHelper.msgWithActual("isEmpty")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.FILE_LENGTH, AssertJChainSimplificationHelper.msgWithActual("isEmpty")), AssertJChainSimplificationIndex.arrayLengthSimplifier(AssertJChainSimplificationHelper.msgWithActual("isEmpty")))).put("isNull", Arrays.asList(PredicateSimplifierWithContext.methodCallInSubject(Matchers.FILE_GET_PARENT_AND_PARENT_FILE, AssertJChainSimplificationHelper.msgWithActual("hasNoParent")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.PATH_GET_PARENT_AND_PARENT_FILE, AssertJChainSimplificationHelper.msgWithActual("hasNoParentRaw")), PredicateSimplifierWithContext.withSubjectArgumentCondition(subjectArg -> AssertJChainSimplificationHelper.hasMethodCallAsArg(subjectArg, Matchers.OR_ELSE) && ExpressionUtils.isNullLiteral((ExpressionTree)((MethodInvocationTree)subjectArg).arguments().get(0)), OPTIONAL_EMPTY_REPLACEMENT))).put("isLessThanOrEqualTo", Arrays.asList(PredicateSimplifierWithContext.methodCallInSubject(Matchers.COLLECTION_SIZE, AssertJChainSimplificationHelper.msgWithActualExpected("hasSizeLessThanOrEqualTo")), AssertJChainSimplificationIndex.arrayLengthSimplifier(AssertJChainSimplificationHelper.msgWithActualExpected("hasSizeLessThanOrEqualTo")))).put("isLessThan", Arrays.asList(PredicateSimplifierWithContext.methodCallInSubject(Matchers.COLLECTION_SIZE, AssertJChainSimplificationHelper.msgWithActualExpected("hasSizeLessThan")), AssertJChainSimplificationIndex.arrayLengthSimplifier(AssertJChainSimplificationHelper.msgWithActualExpected("hasSizeLessThan")))).put("isGreaterThanOrEqualTo", Arrays.asList(PredicateSimplifierWithContext.methodCallInSubject(Matchers.COLLECTION_SIZE, AssertJChainSimplificationHelper.msgWithActualExpected("hasSizeGreaterThanOrEqualTo")), AssertJChainSimplificationIndex.arrayLengthSimplifier(AssertJChainSimplificationHelper.msgWithActualExpected("hasSizeGreaterThanOrEqualTo")))).put("isGreaterThan", Arrays.asList(PredicateSimplifierWithContext.methodCallInSubject(Matchers.COLLECTION_SIZE, AssertJChainSimplificationHelper.msgWithActualExpected("hasSizeGreaterThan")), AssertJChainSimplificationIndex.arrayLengthSimplifier(AssertJChainSimplificationHelper.msgWithActualExpected("hasSizeGreaterThan")))).put("contains", Arrays.asList(PredicateSimplifierWithContext.methodCallInSubject(Matchers.MAP_KEY_SET, AssertJChainSimplificationHelper.msgWithActualExpected("containsKey")), PredicateSimplifierWithContext.methodCallInSubject(Matchers.MAP_VALUES, AssertJChainSimplificationHelper.msgWithActualExpected("containsValue")))).put("containsOnly", Collections.singletonList(PredicateSimplifierWithContext.methodCallInSubject(Matchers.MAP_KEY_SET, AssertJChainSimplificationHelper.msgWithActualExpected("containsOnlyKeys")))).build();

    private AssertJChainSimplificationIndex() {
    }

    private static PredicateSimplifierWithContext compareToSimplifier(Predicate<ExpressionTree> predicateArgCondition, String simplification) {
        return PredicateSimplifierWithContext.methodCallInSubject(predicateArgCondition, Matchers.COMPARE_TO, simplification);
    }

    private static PredicateSimplifierWithContext compareToSimplifier(String simplification) {
        return PredicateSimplifierWithContext.methodCallInSubject(Matchers.COMPARE_TO, simplification);
    }

    private static PredicateSimplifierWithContext indexOfSimplifier(Predicate<ExpressionTree> predicateArgCondition, String simplification) {
        return PredicateSimplifierWithContext.methodCallInSubject(predicateArgCondition, Matchers.INDEX_OF_STRING, AssertJChainSimplificationHelper.msgWithActualExpected(simplification));
    }

    private static PredicateSimplifierWithContext indexOfSimplifier(String simplification) {
        return PredicateSimplifierWithContext.methodCallInSubject(Matchers.INDEX_OF_STRING, AssertJChainSimplificationHelper.msgWithActualExpected(simplification));
    }

    private static PredicateSimplifierWithContext arrayLengthSimplifier(String simplification) {
        return PredicateSimplifierWithContext.withSubjectArgumentCondition(AssertJChainSimplificationIndex::isArrayLength, simplification);
    }

    public static boolean isZeroIntOrLong(ExpressionTree tree) {
        if (tree.is(Tree.Kind.LONG_LITERAL)) {
            String value = ((LiteralTree)tree).value();
            return "0L".equals(value) || "0l".equals(value);
        }
        return LiteralUtils.isZero(tree);
    }

    public static boolean isOneIntOrLong(ExpressionTree tree) {
        if (tree.is(Tree.Kind.LONG_LITERAL)) {
            String value = ((LiteralTree)tree).value();
            return "1L".equals(value) || "1l".equals(value);
        }
        return LiteralUtils.isOne(tree);
    }

    public static boolean isNegOneIntOrLong(ExpressionTree tree) {
        return tree.is(Tree.Kind.UNARY_MINUS) && AssertJChainSimplificationIndex.isOneIntOrLong(((UnaryExpressionTree)tree).expression());
    }

    private static boolean isArrayLength(ExpressionTree expression) {
        if (expression.is(Tree.Kind.MEMBER_SELECT)) {
            MemberSelectExpressionTree memberSelectExpressionTree = (MemberSelectExpressionTree)expression;
            return memberSelectExpressionTree.expression().symbolType().isArray() && LENGTH.equals(memberSelectExpressionTree.identifier().name());
        }
        return false;
    }

    private static boolean isNotObject(ExpressionTree expression) {
        return !expression.symbolType().is("java.lang.Object");
    }

    static class PredicateSimplifierWithContext
    implements AssertJChainSimplificationCheck.SimplifierWithContext {
        private final Predicate<MethodInvocationTree> predicateCondition;
        private final Predicate<MethodInvocationTree> subjectCondition;
        private final String simplification;

        public PredicateSimplifierWithContext(Predicate<MethodInvocationTree> predicateCondition, Predicate<MethodInvocationTree> subjectCondition, String simplification) {
            this.predicateCondition = predicateCondition;
            this.subjectCondition = subjectCondition;
            this.simplification = simplification;
        }

        public static PredicateSimplifierWithContext withSubjectArgumentCondition(Predicate<ExpressionTree> predicateArgumentCondition, Predicate<ExpressionTree> subjectArgumentCondition, String simplification) {
            return new PredicateSimplifierWithContext(predicateMit -> predicateMit.arguments().size() == 1 && predicateArgumentCondition.test(ExpressionUtils.skipParentheses((ExpressionTree)predicateMit.arguments().get(0))), subjectMit -> subjectMit.arguments().size() == 1 && subjectArgumentCondition.test(ExpressionUtils.skipParentheses((ExpressionTree)subjectMit.arguments().get(0))), simplification);
        }

        public static PredicateSimplifierWithContext withSubjectArgumentCondition(Predicate<ExpressionTree> subjectArgumentCondition, String simplification) {
            return new PredicateSimplifierWithContext(x -> true, subjectMit -> subjectMit.arguments().size() == 1 && subjectArgumentCondition.test(ExpressionUtils.skipParentheses((ExpressionTree)subjectMit.arguments().get(0))), simplification);
        }

        public static PredicateSimplifierWithContext methodCallInSubject(MethodMatchers methodCallMatcher, String simplification) {
            return PredicateSimplifierWithContext.withSubjectArgumentCondition(arg -> AssertJChainSimplificationHelper.hasMethodCallAsArg(arg, methodCallMatcher), simplification);
        }

        public static PredicateSimplifierWithContext methodCallInSubject(Predicate<ExpressionTree> predicateArgumentCondition, MethodMatchers methodCallMatcher, String simplification) {
            return PredicateSimplifierWithContext.withSubjectArgumentCondition(predicateArgumentCondition, arg -> AssertJChainSimplificationHelper.hasMethodCallAsArg(arg, methodCallMatcher), simplification);
        }

        @Override
        public Optional<String> simplify(MethodInvocationTree subject, MethodInvocationTree predicate) {
            if (this.predicateCondition.test(predicate) && this.subjectCondition.test(subject)) {
                return Optional.of(this.simplification);
            }
            return Optional.empty();
        }
    }

    private static class PredicateSimplifierWithoutContext
    implements AssertJChainSimplificationCheck.SimplifierWithoutContext {
        private final Predicate<MethodInvocationTree> mitPredicate;
        private final String simplification;

        public PredicateSimplifierWithoutContext(Predicate<MethodInvocationTree> mitPredicate, String simplification) {
            this.mitPredicate = mitPredicate;
            this.simplification = simplification;
        }

        public static PredicateSimplifierWithoutContext withSingleArg(Predicate<ExpressionTree> argumentPredicate, String simplified) {
            return new PredicateSimplifierWithoutContext(mit -> {
                Arguments arguments = mit.arguments();
                return arguments.size() == 1 && argumentPredicate.test((ExpressionTree)arguments.get(0));
            }, simplified);
        }

        @Override
        public Optional<String> simplify(MethodInvocationTree predicate) {
            if (this.mitPredicate.test(predicate)) {
                return Optional.of(this.simplification);
            }
            return Optional.empty();
        }
    }

    private static class Matchers {
        public static final MethodMatchers COMPARE_TO = MethodMatchers.create().ofSubTypes("java.lang.Comparable").names("compareTo").addParametersMatcher("*").build();
        public static final MethodMatchers COMPARE_TO_IGNORE_CASE = MethodMatchers.create().ofSubTypes("java.lang.String").names("compareToIgnoreCase").addParametersMatcher("*").build();
        public static final MethodMatchers CONTAINS = MethodMatchers.create().ofTypes("java.lang.String", "java.util.Collection").names("contains").addParametersMatcher("*").build();
        public static final MethodMatchers CONTENT_EQUALS = MethodMatchers.create().ofTypes("java.lang.String").names("contentEquals").addParametersMatcher("*").build();
        public static final MethodMatchers EMPTY = MethodMatchers.create().ofTypes("java.util.Optional").names("empty").addWithoutParametersMatcher().build();
        public static final MethodMatchers ENDS_WITH = MethodMatchers.create().ofTypes("java.lang.String").names("endsWith").addParametersMatcher("*").build();
        public static final MethodMatchers EQUALS_IGNORE_CASE = MethodMatchers.create().ofTypes("java.lang.String").names("equalsIgnoreCase").addParametersMatcher("*").build();
        public static final MethodMatchers EQUALS_METHOD = MethodMatchers.create().ofAnyType().names("equals").addParametersMatcher("*").build();
        public static final MethodMatchers HASH_CODE = MethodMatchers.create().ofAnyType().names("hashCode").addWithoutParametersMatcher().build();
        public static final MethodMatchers INDEX_OF_STRING = MethodMatchers.create().ofTypes("java.lang.String").names("indexOf").addParametersMatcher("java.lang.String").build();
        public static final MethodMatchers IS_BLANK = MethodMatchers.create().ofTypes("java.lang.String").names("isBlank").addWithoutParametersMatcher().build();
        public static final MethodMatchers IS_EMPTY_GENERIC = MethodMatchers.create().ofTypes("java.lang.String", "java.util.Collection", "java.util.Map").names("isEmpty").addWithoutParametersMatcher().build();
        public static final MethodMatchers IS_EMPTY_OPTIONAL = MethodMatchers.create().ofTypes("java.util.Optional").names("isEmpty").addWithoutParametersMatcher().build();
        public static final MethodMatchers IS_PRESENT = MethodMatchers.create().ofTypes("java.util.Optional").names("isPresent").addWithoutParametersMatcher().build();
        public static final MethodMatchers STRING_LENGTH = MethodMatchers.create().ofTypes("java.lang.String").names("length").addWithoutParametersMatcher().build();
        public static final MethodMatchers FILE_LENGTH = MethodMatchers.create().ofTypes("java.io.File").names("length").addWithoutParametersMatcher().build();
        public static final MethodMatchers MATCHES = MethodMatchers.create().ofTypes("java.lang.String").names("matches").addParametersMatcher("*").build();
        public static final MethodMatchers STARTS_WITH = MethodMatchers.create().ofTypes("java.lang.String").names("startsWith").addParametersMatcher("*").build();
        public static final MethodMatchers TO_STRING = MethodMatchers.create().ofAnyType().names("toString").addWithoutParametersMatcher().build();
        public static final MethodMatchers TRIM = MethodMatchers.create().ofTypes("java.lang.String").names("trim").addWithoutParametersMatcher().build();
        public static final MethodMatchers FILE_CAN_READ = MethodMatchers.create().ofTypes("java.io.File").names("canRead").addWithoutParametersMatcher().build();
        public static final MethodMatchers FILE_CAN_WRITE = MethodMatchers.create().ofTypes("java.io.File").names("canWrite").addWithoutParametersMatcher().build();
        public static final MethodMatchers FILE_EXISTS = MethodMatchers.create().ofTypes("java.io.File").names("exists").addWithoutParametersMatcher().build();
        public static final MethodMatchers FILE_GET_NAME = MethodMatchers.create().ofTypes("java.io.File").names("getName").addWithoutParametersMatcher().build();
        public static final MethodMatchers FILE_GET_PARENT_AND_PARENT_FILE = MethodMatchers.create().ofTypes("java.io.File").names("getParent", "getParentFile").addWithoutParametersMatcher().build();
        public static final MethodMatchers FILE_AND_PATH_IS_ABSOLUTE = MethodMatchers.create().ofTypes("java.io.File", "java.nio.file.Path").names("isAbsolute").addWithoutParametersMatcher().build();
        public static final MethodMatchers FILE_IS_DIRECTORY = MethodMatchers.create().ofTypes("java.io.File").names("isDirectory").addWithoutParametersMatcher().build();
        public static final MethodMatchers FILE_IS_FILE = MethodMatchers.create().ofTypes("java.io.File").names("isFile").addWithoutParametersMatcher().build();
        public static final MethodMatchers FILE_LIST_AND_LIST_FILE = MethodMatchers.create().ofTypes("java.io.File").names("list", "listFiles").addWithoutParametersMatcher().build();
        public static final MethodMatchers GET = MethodMatchers.create().ofTypes("java.util.Optional").names("get").addWithoutParametersMatcher().build();
        public static final MethodMatchers OR_ELSE = MethodMatchers.create().ofTypes("java.util.Optional").names("orElse").addParametersMatcher("*").build();
        public static final MethodMatchers PATH_GET_PARENT_AND_PARENT_FILE = MethodMatchers.create().ofTypes("java.nio.file.Path").names("getParent").addWithoutParametersMatcher().build();
        public static final MethodMatchers PATH_STARTS_WITH = MethodMatchers.create().ofTypes("java.nio.file.Path").names("startsWith").addParametersMatcher("java.lang.String").build();
        public static final MethodMatchers PATH_ENDS_WITH = MethodMatchers.create().ofTypes("java.nio.file.Path").names("endsWith").addParametersMatcher("java.lang.String").build();
        public static final MethodMatchers COLLECTION_SIZE = MethodMatchers.create().ofTypes("java.util.Collection", "java.util.Map").names("size").addWithoutParametersMatcher().build();
        public static final MethodMatchers COLLECTION_CONTAINS_ALL = MethodMatchers.create().ofTypes("java.util.Collection").names("containsAll").addParametersMatcher("*").build();
        public static final MethodMatchers MAP_CONTAINS_KEY = MethodMatchers.create().ofTypes("java.util.Map").names("containsKey").addParametersMatcher("*").build();
        public static final MethodMatchers MAP_CONTAINS_VALUE = MethodMatchers.create().ofTypes("java.util.Map").names("containsValue").addParametersMatcher("*").build();
        public static final MethodMatchers MAP_GET = MethodMatchers.create().ofTypes("java.util.Map").names("get").addParametersMatcher("*").build();
        public static final MethodMatchers MAP_KEY_SET = MethodMatchers.create().ofTypes("java.util.Map").names("keySet").addWithoutParametersMatcher().build();
        public static final MethodMatchers MAP_VALUES = MethodMatchers.create().ofTypes("java.util.Map").names("values").addWithoutParametersMatcher().build();

        private Matchers() {
        }
    }
}

