/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.filters;

import java.util.Set;
import org.sonar.java.checks.ClassVariableVisibilityCheck;
import org.sonar.java.checks.PublicStaticFieldShouldBeFinalCheck;
import org.sonar.java.collections.SetUtils;
import org.sonar.java.filters.BaseTreeVisitorIssueFilter;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.Tree;

public class EclipseI18NFilter
extends BaseTreeVisitorIssueFilter {
    private static final Set<Class<? extends JavaCheck>> FILTERED_RULES = SetUtils.immutableSetOf(PublicStaticFieldShouldBeFinalCheck.class, ClassVariableVisibilityCheck.class);

    @Override
    public Set<Class<? extends JavaCheck>> filteredRules() {
        return FILTERED_RULES;
    }

    @Override
    public void visitClass(ClassTree tree) {
        if (tree.symbol().type().isSubtypeOf("org.eclipse.osgi.util.NLS")) {
            this.excludeLines((Tree)tree, FILTERED_RULES);
        } else {
            this.acceptLines((Tree)tree, FILTERED_RULES);
        }
        super.visitClass(tree);
    }
}

