/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.java;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.server.profile.BuiltInQualityProfilesDefinition;
import org.sonar.api.utils.AnnotationUtils;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.check.Rule;
import org.sonar.java.RspecKey;
import org.sonar.java.annotations.VisibleForTesting;
import org.sonar.java.checks.CheckList;
import org.sonarsource.api.sonarlint.SonarLintSide;

@SonarLintSide
public class JavaSonarWayProfile
implements BuiltInQualityProfilesDefinition {
    private static final Logger LOG = Loggers.get(JavaSonarWayProfile.class);

    public void define(BuiltInQualityProfilesDefinition.Context context) {
        BuiltInQualityProfilesDefinition.NewBuiltInQualityProfile sonarWay = context.createBuiltInQualityProfile("Sonar way", "java");
        sonarWay.activateRule("common-java", "DuplicatedBlocks");
        Profile jsonProfile = JavaSonarWayProfile.readProfile();
        Map<String, String> keys = JavaSonarWayProfile.legacyKeys();
        for (String key2 : jsonProfile.ruleKeys) {
            sonarWay.activateRule("java", keys.get(key2));
        }
        JavaSonarWayProfile.getSecurityRuleKeys(JavaSonarWayProfile.isSonarSecurityBefore78()).forEach(key -> sonarWay.activateRule(key.repository(), key.rule()));
        sonarWay.done();
    }

    private static Map<String, String> legacyKeys() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Class<?> checkClass : CheckList.getChecks()) {
            Rule ruleAnnotation = (Rule)AnnotationUtils.getAnnotation(checkClass, Rule.class);
            String key = ruleAnnotation.key();
            RspecKey rspecKeyAnnotation = (RspecKey)AnnotationUtils.getAnnotation(checkClass, RspecKey.class);
            String rspecKey = key;
            if (rspecKeyAnnotation != null) {
                rspecKey = rspecKeyAnnotation.value();
            }
            result.put(rspecKey, key);
        }
        return result;
    }

    static Profile readProfile() {
        URL resource = JavaSonarWayProfile.class.getResource("/org/sonar/l10n/java/rules/java/Sonar_way_profile.json");
        return new Gson().fromJson(JavaSonarWayProfile.readResource(resource), Profile.class);
    }

    private static String readResource(URL resource) {
        String string;
        BufferedReader reader = new BufferedReader(new InputStreamReader(resource.openStream(), StandardCharsets.UTF_8));
        try {
            string = reader.lines().collect(Collectors.joining("\n"));
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to read: " + resource, e);
            }
        }
        reader.close();
        return string;
    }

    @VisibleForTesting
    static Set<RuleKey> getSecurityRuleKeys(boolean sonarSecurityBefore78) {
        try {
            String repositoryKey;
            Class<?> javaRulesClass = Class.forName("com.sonar.plugins.security.api.JavaRules");
            String ruleKeysMethod = sonarSecurityBefore78 ? "getRuleKeys" : "getSecurityRuleKeys";
            Method getRuleKeysMethod = javaRulesClass.getMethod(ruleKeysMethod, new Class[0]);
            Set ruleKeys = (Set)getRuleKeysMethod.invoke(null, new Object[0]);
            if (sonarSecurityBefore78) {
                repositoryKey = "java";
            } else {
                Method getRepositoryKeyMethod = javaRulesClass.getMethod("getRepositoryKey", new Class[0]);
                repositoryKey = (String)getRepositoryKeyMethod.invoke(null, new Object[0]);
            }
            return ruleKeys.stream().map(k -> RuleKey.of((String)repositoryKey, (String)k)).collect(Collectors.toSet());
        }
        catch (ClassNotFoundException e) {
            LOG.debug("com.sonar.plugins.security.api.JavaRules is not found, no security rules added to Sonar way java profile: " + e.getMessage());
        }
        catch (NoSuchMethodException e) {
            LOG.debug("Method is not found, no security rules added to Sonar way java profile: " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            LOG.debug("[IllegalAccessException] no security rules added to Sonar way java profile: " + e.getMessage());
        }
        catch (InvocationTargetException e) {
            LOG.debug("[InvocationTargetException] no security rules added to Sonar way java profile: " + e.getMessage());
        }
        return new HashSet<RuleKey>();
    }

    private static boolean isSonarSecurityBefore78() {
        try {
            Class<?> javaRulesClass = Class.forName("com.sonar.plugins.security.api.JavaRules");
            javaRulesClass.getMethod("getRepositoryKey", new Class[0]);
            return false;
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            return true;
        }
    }

    static class Profile {
        String name;
        Set<String> ruleKeys;

        Profile() {
        }
    }
}

