/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.html.checks.attributes;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.html.checks.AbstractPageCheck;
import org.sonar.plugins.html.node.Node;
import org.sonar.plugins.html.node.TagNode;

@Rule(key="RequiredAttributeCheck")
public class RequiredAttributeCheck
extends AbstractPageCheck {
    private static final String DEFAULT_ATTRIBUTES = "";
    @RuleProperty(key="attributes", description="Comma-separated list of tag.attributes that are required. E.G. specify img.alt to require an \"alt\" attribute in an \"img\" tag.", defaultValue="")
    public String attributes = "";
    private final List<RequiredAttribute> attributesList = new ArrayList<RequiredAttribute>();

    @Override
    public void startDocument(List<Node> nodes) {
        this.attributesList.clear();
        for (String item : this.trimSplitCommaSeparatedList(this.attributes)) {
            String[] pair = StringUtils.split(item, ".");
            if (pair.length <= 1) continue;
            RequiredAttribute a = new RequiredAttribute();
            a.elementName = pair[0];
            a.attributeName = pair[1];
            this.attributesList.add(a);
        }
    }

    @Override
    public void startElement(TagNode node) {
        for (RequiredAttribute attribute : this.attributesList) {
            String attributeName = attribute.attributeName;
            String elementName = attribute.elementName;
            if (!node.equalsElementName(elementName) || node.hasProperty(attributeName)) continue;
            this.createViolation(node.getStartLinePosition(), "Add the missing \"" + attributeName + "\" to element \"" + elementName + "\".");
        }
    }

    private static final class RequiredAttribute {
        private String elementName;
        private String attributeName;

        private RequiredAttribute() {
        }
    }
}

