/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.html.checks.sonar;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import org.sonar.check.Rule;
import org.sonar.plugins.html.checks.AbstractPageCheck;
import org.sonar.plugins.html.node.Node;
import org.sonar.plugins.html.node.TagNode;

@Rule(key="InputWithoutLabelCheck")
public class InputWithoutLabelCheck
extends AbstractPageCheck {
    private static final Set<String> EXCLUDED_TYPES = new HashSet<String>(Arrays.asList("SUBMIT", "BUTTON", "IMAGE", "HIDDEN"));
    private final Set<String> labelFor = new HashSet<String>();
    private final Map<String, TagNode> inputIdToNode = new HashMap<String, TagNode>();
    private Deque<TagNode> elementStack;
    private Set<String> ids;
    private Map<TagNode, Set<String>> expectedIds;

    @Override
    public void startDocument(List<Node> nodes) {
        this.labelFor.clear();
        this.inputIdToNode.clear();
        this.elementStack = new ArrayDeque<TagNode>();
        this.ids = new HashSet<String>();
        this.expectedIds = new HashMap<TagNode, Set<String>>();
    }

    @Override
    public void startElement(TagNode node) {
        if (InputWithoutLabelCheck.isLabel(node) || this.insideLabelNode()) {
            this.elementStack.push(node);
        }
        if (InputWithoutLabelCheck.getNodeId(node) != null) {
            this.ids.add(InputWithoutLabelCheck.getNodeId(node));
        }
        if (InputWithoutLabelCheck.isInputRequiredLabel(node) || InputWithoutLabelCheck.isSelect(node) || InputWithoutLabelCheck.isTextarea(node)) {
            if (node.getPropertyValue("aria-label") != null || this.insideLabelNode()) {
                return;
            }
            if (node.getPropertyValue("aria-labelledby") != null) {
                this.expectedIds.put(node, Arrays.stream(node.getPropertyValue("aria-labelledby").split(" ")).collect(Collectors.toSet()));
                return;
            }
            String id = InputWithoutLabelCheck.getNodeId(node);
            if (id == null) {
                this.createViolation(node, "Add an \"id\" attribute to this input field and associate it with a label.");
            } else {
                this.inputIdToNode.put(id, node);
            }
        } else if (InputWithoutLabelCheck.isLabel(node) && node.getAttribute("for") != null) {
            this.labelFor.add(node.getAttribute("for"));
        }
    }

    @Override
    public void endElement(TagNode node) {
        if (this.insideLabelNode()) {
            TagNode pop = this.elementStack.pop();
            while (!pop.equalsElementName(node.getNodeName()) && !this.elementStack.isEmpty()) {
                pop = this.elementStack.pop();
            }
        }
    }

    private boolean insideLabelNode() {
        return !this.elementStack.isEmpty();
    }

    private static boolean isSelect(TagNode node) {
        return InputWithoutLabelCheck.isType(node, "SELECT");
    }

    private static boolean isTextarea(TagNode node) {
        return InputWithoutLabelCheck.isType(node, "TEXTAREA");
    }

    private static boolean isInputRequiredLabel(TagNode node) {
        return InputWithoutLabelCheck.isType(node, "INPUT") && !InputWithoutLabelCheck.hasExcludedType(node);
    }

    private static boolean isType(TagNode node, String type) {
        return type.equalsIgnoreCase(node.getNodeName());
    }

    private static boolean hasExcludedType(TagNode node) {
        String type = node.getAttribute("type");
        return type == null || EXCLUDED_TYPES.contains(type.toUpperCase(Locale.ENGLISH));
    }

    private static boolean isLabel(TagNode node) {
        return "LABEL".equalsIgnoreCase(node.getNodeName());
    }

    @Override
    public void endDocument() {
        for (Map.Entry<String, TagNode> entry : this.inputIdToNode.entrySet()) {
            if (this.labelFor.contains(entry.getKey())) continue;
            this.createViolation(entry.getValue(), "Associate a valid label to this input field.");
        }
        this.expectedIds.forEach((node, expected) -> {
            if (!this.ids.containsAll((Collection<?>)expected)) {
                String missingIds = expected.stream().filter(id -> !this.ids.contains(id)).map(s -> "\"" + s + "\"").collect(Collectors.joining(","));
                this.createViolation((Node)node, "Use valid ids in \"aria-labelledby\" attribute. Following ids were not found: " + missingIds + ".");
            }
        });
    }

    @CheckForNull
    private static String getNodeId(TagNode node) {
        return node.getPropertyValue("ID");
    }
}

