/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.html.checks.sonar;

import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.html.checks.AbstractPageCheck;
import org.sonar.plugins.html.node.TagNode;

@Rule(key="TableWithoutCaptionCheck")
public class TableWithoutCaptionCheck
extends AbstractPageCheck {
    @Override
    public void startElement(TagNode node) {
        if (TableWithoutCaptionCheck.isTable(node) && !TableWithoutCaptionCheck.isIgnored(node) && !TableWithoutCaptionCheck.hasDescription(node)) {
            this.createViolation(node, "Add a description to this table.");
        }
    }

    private static boolean isIgnored(TagNode node) {
        return TableWithoutCaptionCheck.isLayout(node) || TableWithoutCaptionCheck.isHidden(node);
    }

    private static boolean hasDescription(TagNode node) {
        return TableWithoutCaptionCheck.hasSummary(node) || TableWithoutCaptionCheck.hasAriaDescription(node) || TableWithoutCaptionCheck.hasCaption(node) || TableWithoutCaptionCheck.isEmbeddedInFigureWithCaption(node.getParent());
    }

    private static boolean isTable(TagNode node) {
        return "TABLE".equalsIgnoreCase(node.getNodeName());
    }

    private static boolean isCaption(TagNode node) {
        return "CAPTION".equalsIgnoreCase(node.getNodeName());
    }

    private static boolean isFigure(TagNode node) {
        return "FIGURE".equalsIgnoreCase(node.getNodeName());
    }

    private static boolean isFigCaption(TagNode node) {
        return "FIGCAPTION".equalsIgnoreCase(node.getNodeName());
    }

    private static boolean isLayout(TagNode node) {
        String role = node.getAttribute("ROLE");
        return "PRESENTATION".equalsIgnoreCase(role) || "NONE".equalsIgnoreCase(role);
    }

    private static boolean isHidden(TagNode node) {
        return "TRUE".equalsIgnoreCase(node.getAttribute("ARIA-HIDDEN"));
    }

    private static boolean isEmbeddedInFigureWithCaption(@Nullable TagNode node) {
        if (node == null || TableWithoutCaptionCheck.isTable(node)) {
            return false;
        }
        if (TableWithoutCaptionCheck.isFigure(node) && TableWithoutCaptionCheck.hasFigCaption(node)) {
            return true;
        }
        return TableWithoutCaptionCheck.isEmbeddedInFigureWithCaption(node.getParent());
    }

    private static boolean hasSummary(TagNode node) {
        return node.hasProperty("SUMMARY");
    }

    private static boolean hasAriaDescription(TagNode node) {
        return node.hasProperty("ARIA-LABEL") || node.hasProperty("ARIA-LABELLEDBY") || node.hasProperty("ARIA-DESCRIBEDBY");
    }

    private static boolean hasCaption(TagNode node) {
        return !node.getChildren().isEmpty() && TableWithoutCaptionCheck.isCaption(node.getChildren().get(0));
    }

    private static boolean hasFigCaption(TagNode node) {
        return TableWithoutCaptionCheck.isFigCaption(node.getChildren().get(0)) || TableWithoutCaptionCheck.isFigCaption(node.getChildren().get(node.getChildren().size() - 1));
    }
}

