/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.snapshots.restore;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.snapshots.SnapshotsService;

public class RestoreSnapshotRequest
extends MasterNodeRequest<RestoreSnapshotRequest>
implements ToXContentObject {
    private static final DeprecationLogger DEPRECATION_LOGGER = DeprecationLogger.getLogger(RestoreSnapshotRequest.class);
    private String snapshot;
    private String repository;
    private String[] indices = Strings.EMPTY_ARRAY;
    private IndicesOptions indicesOptions = IndicesOptions.strictExpandOpen();
    private String[] featureStates = Strings.EMPTY_ARRAY;
    private String renamePattern;
    private String renameReplacement;
    private boolean waitForCompletion;
    private boolean includeGlobalState = false;
    private boolean partial = false;
    private boolean includeAliases = true;
    private Settings indexSettings = Settings.Builder.EMPTY_SETTINGS;
    private String[] ignoreIndexSettings = Strings.EMPTY_ARRAY;
    private boolean skipOperatorOnlyState = false;
    @Nullable
    private String snapshotUuid;

    public RestoreSnapshotRequest() {
    }

    public RestoreSnapshotRequest(String repository, String snapshot) {
        this.snapshot = snapshot;
        this.repository = repository;
    }

    public RestoreSnapshotRequest(StreamInput in) throws IOException {
        super(in);
        this.snapshot = in.readString();
        this.repository = in.readString();
        this.indices = in.readStringArray();
        this.indicesOptions = IndicesOptions.readIndicesOptions(in);
        if (in.getVersion().onOrAfter(SnapshotsService.FEATURE_STATES_VERSION)) {
            this.featureStates = in.readStringArray();
        }
        this.renamePattern = in.readOptionalString();
        this.renameReplacement = in.readOptionalString();
        this.waitForCompletion = in.readBoolean();
        this.includeGlobalState = in.readBoolean();
        this.partial = in.readBoolean();
        this.includeAliases = in.readBoolean();
        if (in.getVersion().before(Version.V_7_7_0)) {
            Settings.readSettingsFromStream(in);
        }
        this.indexSettings = Settings.readSettingsFromStream(in);
        this.ignoreIndexSettings = in.readStringArray();
        if (in.getVersion().onOrAfter(Version.V_7_10_0)) {
            this.snapshotUuid = in.readOptionalString();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.snapshot);
        out.writeString(this.repository);
        out.writeStringArray(this.indices);
        this.indicesOptions.writeIndicesOptions(out);
        if (out.getVersion().onOrAfter(SnapshotsService.FEATURE_STATES_VERSION)) {
            out.writeStringArray(this.featureStates);
        }
        out.writeOptionalString(this.renamePattern);
        out.writeOptionalString(this.renameReplacement);
        out.writeBoolean(this.waitForCompletion);
        out.writeBoolean(this.includeGlobalState);
        out.writeBoolean(this.partial);
        out.writeBoolean(this.includeAliases);
        if (out.getVersion().before(Version.V_7_7_0)) {
            Settings.writeSettingsToStream(Settings.EMPTY, out);
        }
        Settings.writeSettingsToStream(this.indexSettings, out);
        out.writeStringArray(this.ignoreIndexSettings);
        if (out.getVersion().onOrAfter(Version.V_7_10_0)) {
            out.writeOptionalString(this.snapshotUuid);
        } else if (this.snapshotUuid != null) {
            throw new IllegalStateException("restricting the snapshot UUID is forbidden in a cluster with version [" + out.getVersion() + "] nodes");
        }
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.snapshot == null) {
            validationException = ValidateActions.addValidationError("name is missing", validationException);
        }
        if (this.repository == null) {
            validationException = ValidateActions.addValidationError("repository is missing", validationException);
        }
        if (this.indices == null) {
            validationException = ValidateActions.addValidationError("indices are missing", validationException);
        }
        if (this.indicesOptions == null) {
            validationException = ValidateActions.addValidationError("indicesOptions is missing", validationException);
        }
        if (this.featureStates == null) {
            validationException = ValidateActions.addValidationError("featureStates is missing", validationException);
        }
        if (this.indexSettings == null) {
            validationException = ValidateActions.addValidationError("indexSettings are missing", validationException);
        }
        if (this.ignoreIndexSettings == null) {
            validationException = ValidateActions.addValidationError("ignoreIndexSettings are missing", validationException);
        }
        return validationException;
    }

    public RestoreSnapshotRequest snapshot(String snapshot) {
        this.snapshot = snapshot;
        return this;
    }

    public String snapshot() {
        return this.snapshot;
    }

    public RestoreSnapshotRequest repository(String repository) {
        this.repository = repository;
        return this;
    }

    public String repository() {
        return this.repository;
    }

    public RestoreSnapshotRequest indices(String ... indices) {
        this.indices = indices;
        return this;
    }

    public RestoreSnapshotRequest indices(List<String> indices) {
        this.indices = indices.toArray(new String[indices.size()]);
        return this;
    }

    public String[] indices() {
        return this.indices;
    }

    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public RestoreSnapshotRequest indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
        return this;
    }

    public RestoreSnapshotRequest renamePattern(String renamePattern) {
        this.renamePattern = renamePattern;
        return this;
    }

    public String renamePattern() {
        return this.renamePattern;
    }

    public RestoreSnapshotRequest renameReplacement(String renameReplacement) {
        this.renameReplacement = renameReplacement;
        return this;
    }

    public String renameReplacement() {
        return this.renameReplacement;
    }

    public RestoreSnapshotRequest waitForCompletion(boolean waitForCompletion) {
        this.waitForCompletion = waitForCompletion;
        return this;
    }

    public boolean waitForCompletion() {
        return this.waitForCompletion;
    }

    public boolean partial() {
        return this.partial;
    }

    public RestoreSnapshotRequest partial(boolean partial) {
        this.partial = partial;
        return this;
    }

    public RestoreSnapshotRequest ignoreIndexSettings(String ... ignoreIndexSettings) {
        this.ignoreIndexSettings = ignoreIndexSettings;
        return this;
    }

    public RestoreSnapshotRequest ignoreIndexSettings(List<String> ignoreIndexSettings) {
        this.ignoreIndexSettings = ignoreIndexSettings.toArray(new String[ignoreIndexSettings.size()]);
        return this;
    }

    public String[] ignoreIndexSettings() {
        return this.ignoreIndexSettings;
    }

    public RestoreSnapshotRequest includeGlobalState(boolean includeGlobalState) {
        this.includeGlobalState = includeGlobalState;
        return this;
    }

    public boolean includeGlobalState() {
        return this.includeGlobalState;
    }

    public RestoreSnapshotRequest includeAliases(boolean includeAliases) {
        this.includeAliases = includeAliases;
        return this;
    }

    public boolean includeAliases() {
        return this.includeAliases;
    }

    public RestoreSnapshotRequest indexSettings(Settings settings) {
        this.indexSettings = settings;
        return this;
    }

    public RestoreSnapshotRequest indexSettings(Settings.Builder settings) {
        this.indexSettings = settings.build();
        return this;
    }

    public RestoreSnapshotRequest indexSettings(String source, XContentType xContentType) {
        this.indexSettings = Settings.builder().loadFromSource(source, xContentType).build();
        return this;
    }

    public RestoreSnapshotRequest indexSettings(Map<String, Object> source) {
        this.indexSettings = Settings.builder().loadFromMap(source).build();
        return this;
    }

    public Settings indexSettings() {
        return this.indexSettings;
    }

    public RestoreSnapshotRequest snapshotUuid(String snapshotUuid) {
        this.snapshotUuid = snapshotUuid;
        return this;
    }

    @Nullable
    public String snapshotUuid() {
        return this.snapshotUuid;
    }

    public boolean skipOperatorOnlyState() {
        return this.skipOperatorOnlyState;
    }

    public void skipOperatorOnlyState(boolean skipOperatorOnlyState) {
        this.skipOperatorOnlyState = skipOperatorOnlyState;
    }

    @Nullable
    public String[] featureStates() {
        return this.featureStates;
    }

    public RestoreSnapshotRequest featureStates(String[] featureStates) {
        this.featureStates = featureStates;
        return this;
    }

    public RestoreSnapshotRequest featureStates(List<String> featureStates) {
        return this.featureStates(featureStates.toArray(Strings.EMPTY_ARRAY));
    }

    public RestoreSnapshotRequest source(Map<String, Object> source) {
        for (Map.Entry<String, Object> entry : source.entrySet()) {
            String name = entry.getKey();
            if (name.equals("indices")) {
                if (entry.getValue() instanceof String) {
                    this.indices(Strings.splitStringByCommaToArray((String)entry.getValue()));
                    continue;
                }
                if (entry.getValue() instanceof ArrayList) {
                    this.indices((ArrayList)entry.getValue());
                    continue;
                }
                throw new IllegalArgumentException("malformed indices section, should be an array of strings");
            }
            if (name.equals("feature_states")) {
                if (entry.getValue() instanceof List) {
                    this.featureStates((List)entry.getValue());
                    continue;
                }
                throw new IllegalArgumentException("malformed feature_states section, should be an array of strings");
            }
            if (name.equals("partial")) {
                this.partial(XContentMapValues.nodeBooleanValue(entry.getValue(), "partial"));
                continue;
            }
            if (name.equals("settings")) {
                if (!(entry.getValue() instanceof Map)) {
                    throw new IllegalArgumentException("malformed settings section");
                }
                DEPRECATION_LOGGER.deprecate(DeprecationCategory.API, "RestoreSnapshotRequest#settings", "specifying [settings] when restoring a snapshot has no effect and will not be supported in a future version", new Object[0]);
                continue;
            }
            if (name.equals("include_global_state")) {
                this.includeGlobalState = XContentMapValues.nodeBooleanValue(entry.getValue(), "include_global_state");
                continue;
            }
            if (name.equals("include_aliases")) {
                this.includeAliases = XContentMapValues.nodeBooleanValue(entry.getValue(), "include_aliases");
                continue;
            }
            if (name.equals("rename_pattern")) {
                if (entry.getValue() instanceof String) {
                    this.renamePattern((String)entry.getValue());
                    continue;
                }
                throw new IllegalArgumentException("malformed rename_pattern");
            }
            if (name.equals("rename_replacement")) {
                if (entry.getValue() instanceof String) {
                    this.renameReplacement((String)entry.getValue());
                    continue;
                }
                throw new IllegalArgumentException("malformed rename_replacement");
            }
            if (name.equals("index_settings")) {
                if (!(entry.getValue() instanceof Map)) {
                    throw new IllegalArgumentException("malformed index_settings section");
                }
                this.indexSettings((Map)entry.getValue());
                continue;
            }
            if (name.equals("ignore_index_settings")) {
                if (entry.getValue() instanceof String) {
                    this.ignoreIndexSettings(Strings.splitStringByCommaToArray((String)entry.getValue()));
                    continue;
                }
                if (entry.getValue() instanceof List) {
                    this.ignoreIndexSettings((List)entry.getValue());
                    continue;
                }
                throw new IllegalArgumentException("malformed ignore_index_settings section, should be an array of strings");
            }
            if (IndicesOptions.isIndicesOptions(name)) continue;
            throw new IllegalArgumentException("Unknown parameter " + name);
        }
        this.indicesOptions(IndicesOptions.fromMap(source, this.indicesOptions));
        return this;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.toXContentFragment(builder, params);
        builder.endObject();
        return builder;
    }

    private void toXContentFragment(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray("indices");
        for (String index : this.indices) {
            builder.value(index);
        }
        builder.endArray();
        if (this.indicesOptions != null) {
            this.indicesOptions.toXContent(builder, params);
        }
        if (this.renamePattern != null) {
            builder.field("rename_pattern", this.renamePattern);
        }
        if (this.renameReplacement != null) {
            builder.field("rename_replacement", this.renameReplacement);
        }
        if (this.featureStates != null && this.featureStates.length > 0) {
            builder.startArray("feature_states");
            for (String plugin : this.featureStates) {
                builder.value(plugin);
            }
            builder.endArray();
        }
        builder.field("include_global_state", this.includeGlobalState);
        builder.field("partial", this.partial);
        builder.field("include_aliases", this.includeAliases);
        if (this.indexSettings != null) {
            builder.startObject("index_settings");
            if (!this.indexSettings.isEmpty()) {
                this.indexSettings.toXContent(builder, params);
            }
            builder.endObject();
        }
        builder.startArray("ignore_index_settings");
        for (String ignoreIndexSetting : this.ignoreIndexSettings) {
            builder.value(ignoreIndexSetting);
        }
        builder.endArray();
    }

    @Override
    public String getDescription() {
        return "snapshot [" + this.repository + ":" + this.snapshot + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RestoreSnapshotRequest that = (RestoreSnapshotRequest)o;
        return this.waitForCompletion == that.waitForCompletion && this.includeGlobalState == that.includeGlobalState && this.partial == that.partial && this.includeAliases == that.includeAliases && Objects.equals(this.snapshot, that.snapshot) && Objects.equals(this.repository, that.repository) && Arrays.equals(this.indices, that.indices) && Objects.equals(this.indicesOptions, that.indicesOptions) && Arrays.equals(this.featureStates, that.featureStates) && Objects.equals(this.renamePattern, that.renamePattern) && Objects.equals(this.renameReplacement, that.renameReplacement) && Objects.equals(this.indexSettings, that.indexSettings) && Arrays.equals(this.ignoreIndexSettings, that.ignoreIndexSettings) && Objects.equals(this.snapshotUuid, that.snapshotUuid) && this.skipOperatorOnlyState == that.skipOperatorOnlyState;
    }

    public int hashCode() {
        int result = Objects.hash(this.snapshot, this.repository, this.indicesOptions, this.renamePattern, this.renameReplacement, this.waitForCompletion, this.includeGlobalState, this.partial, this.includeAliases, this.indexSettings, this.snapshotUuid, this.skipOperatorOnlyState);
        result = 31 * result + Arrays.hashCode(this.indices);
        result = 31 * result + Arrays.hashCode(this.ignoreIndexSettings);
        result = 31 * result + Arrays.hashCode(this.featureStates);
        return result;
    }

    public String toString() {
        return Strings.toString((builder, params) -> {
            builder.startObject();
            this.toXContentFragment(builder, params);
            builder.field("skipOperatorOnlyState", this.skipOperatorOnlyState);
            builder.endObject();
            return builder;
        });
    }
}

