/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.template.put;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.cluster.metadata.ComposableIndexTemplate;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.regex.Regex;

public class PutComposableIndexTemplateAction
extends ActionType<AcknowledgedResponse> {
    public static final PutComposableIndexTemplateAction INSTANCE = new PutComposableIndexTemplateAction();
    public static final String NAME = "indices:admin/index_template/put";

    private PutComposableIndexTemplateAction() {
        super(NAME, AcknowledgedResponse::readFrom);
    }

    public static class Request
    extends MasterNodeRequest<Request>
    implements IndicesRequest {
        private final String name;
        @Nullable
        private String cause;
        private boolean create;
        private ComposableIndexTemplate indexTemplate;

        public Request(StreamInput in) throws IOException {
            super(in);
            this.name = in.readString();
            this.cause = in.readOptionalString();
            this.create = in.readBoolean();
            this.indexTemplate = new ComposableIndexTemplate(in);
        }

        public Request(String name) {
            this.name = name;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.name);
            out.writeOptionalString(this.cause);
            out.writeBoolean(this.create);
            this.indexTemplate.writeTo(out);
        }

        @Override
        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (this.name == null || !Strings.hasText(this.name)) {
                validationException = ValidateActions.addValidationError("name is missing", validationException);
            }
            validationException = this.validateIndexTemplate(validationException);
            return validationException;
        }

        public ActionRequestValidationException validateIndexTemplate(@Nullable ActionRequestValidationException validationException) {
            if (this.indexTemplate == null) {
                validationException = ValidateActions.addValidationError("an index template is required", validationException);
            } else {
                if (this.indexTemplate.template() != null && this.indexTemplate.indexPatterns().stream().anyMatch(Regex::isMatchAllPattern) && this.indexTemplate.template().settings() != null && IndexMetadata.INDEX_HIDDEN_SETTING.exists(this.indexTemplate.template().settings())) {
                    validationException = ValidateActions.addValidationError("global composable templates may not specify the setting " + IndexMetadata.INDEX_HIDDEN_SETTING.getKey(), validationException);
                }
                if (this.indexTemplate.priority() != null && this.indexTemplate.priority() < 0L) {
                    validationException = ValidateActions.addValidationError("index template priority must be >= 0", validationException);
                }
            }
            return validationException;
        }

        public String name() {
            return this.name;
        }

        public Request create(boolean create) {
            this.create = create;
            return this;
        }

        public boolean create() {
            return this.create;
        }

        public Request cause(@Nullable String cause) {
            this.cause = cause;
            return this;
        }

        @Nullable
        public String cause() {
            return this.cause;
        }

        public Request indexTemplate(ComposableIndexTemplate template) {
            this.indexTemplate = template;
            return this;
        }

        public ComposableIndexTemplate indexTemplate() {
            return this.indexTemplate;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("PutTemplateV2Request[");
            sb.append("name=").append(this.name);
            sb.append(", cause=").append(this.cause);
            sb.append(", create=").append(this.create);
            sb.append(", index_template=").append(this.indexTemplate);
            sb.append("]");
            return sb.toString();
        }

        @Override
        public String[] indices() {
            return this.indexTemplate.indexPatterns().toArray(Strings.EMPTY_ARRAY);
        }

        @Override
        public IndicesOptions indicesOptions() {
            return IndicesOptions.strictExpand();
        }

        public int hashCode() {
            return Objects.hash(this.name, this.cause, this.create, this.indexTemplate);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)obj;
            return Objects.equals(this.name, other.name) && Objects.equals(this.cause, other.cause) && Objects.equals(this.indexTemplate, other.indexTemplate) && this.create == other.create;
        }
    }
}

