/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.bytes;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.FutureArrays;
import org.apache.lucene.util.FutureObjects;
import org.elasticsearch.common.bytes.AbstractBytesReference;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;

public final class BytesArray
extends AbstractBytesReference {
    public static final BytesArray EMPTY = new BytesArray(BytesRef.EMPTY_BYTES, 0, 0);
    private final byte[] bytes;
    private final int offset;
    private final int length;

    public BytesArray(String bytes) {
        this(new BytesRef(bytes));
    }

    public BytesArray(BytesRef bytesRef) {
        this(bytesRef, false);
    }

    public BytesArray(BytesRef bytesRef, boolean deepCopy) {
        if (deepCopy) {
            bytesRef = BytesRef.deepCopyOf(bytesRef);
        }
        this.bytes = bytesRef.bytes;
        this.offset = bytesRef.offset;
        this.length = bytesRef.length;
    }

    public BytesArray(byte[] bytes) {
        this(bytes, 0, bytes.length);
    }

    public BytesArray(byte[] bytes, int offset, int length) {
        this.bytes = bytes;
        this.offset = offset;
        this.length = length;
    }

    @Override
    public byte get(int index) {
        return this.bytes[this.offset + index];
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof BytesArray) {
            BytesArray that = (BytesArray)other;
            return FutureArrays.equals(this.bytes, this.offset, this.offset + this.length, that.bytes, that.offset, that.offset + that.length);
        }
        return super.equals(other);
    }

    @Override
    public BytesReference slice(int from, int length) {
        if (from == 0 && this.length == length) {
            return this;
        }
        FutureObjects.checkFromIndexSize(from, length, this.length);
        return new BytesArray(this.bytes, this.offset + from, length);
    }

    public byte[] array() {
        return this.bytes;
    }

    public int offset() {
        return this.offset;
    }

    @Override
    public BytesRef toBytesRef() {
        return new BytesRef(this.bytes, this.offset, this.length);
    }

    @Override
    public long ramBytesUsed() {
        return this.bytes.length;
    }

    @Override
    public StreamInput streamInput() {
        return StreamInput.wrap(this.bytes, this.offset, this.length);
    }

    @Override
    public void writeTo(OutputStream os) throws IOException {
        os.write(this.bytes, this.offset, this.length);
    }
}

