/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.Assertions;

public class Maps {
    public static <K, V> boolean deepEquals(Map<K, V> left, Map<K, V> right) {
        if (left == right) {
            return true;
        }
        if (left == null || right == null || left.size() != right.size()) {
            return false;
        }
        return left.entrySet().stream().allMatch(e -> right.containsKey(e.getKey()) && Objects.deepEquals(e.getValue(), right.get(e.getKey())));
    }

    public static <K, V> Map<K, V> copyMapWithRemovedEntry(Map<K, V> map, K key) {
        Objects.requireNonNull(map);
        Objects.requireNonNull(key);
        Maps.assertImmutableMap(map, key, map.get(key));
        return map.entrySet().stream().filter(k -> !key.equals(k.getKey())).collect(Collectors.collectingAndThen(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue), Collections::unmodifiableMap));
    }

    private static <K, V> void assertImmutableMap(Map<K, V> map, K key, V value) {
        if (Assertions.ENABLED) {
            boolean immutable;
            try {
                map.put(key, value);
                immutable = false;
            }
            catch (UnsupportedOperationException e) {
                immutable = true;
            }
            assert (immutable) : "expected an immutable map but was [" + map.getClass() + "]";
        }
    }
}

