/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.LeafMetaData;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.Terms;
import org.apache.lucene.store.ByteBuffersDirectory;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Bits;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.index.engine.EngineException;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.ParsedDocument;
import org.elasticsearch.index.mapper.SourceToParse;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.translog.Translog;

final class SingleDocDirectoryReader
extends DirectoryReader {
    private final SingleDocLeafReader leafReader;

    SingleDocDirectoryReader(ShardId shardId, Translog.Index operation, DocumentMapper mapper, Analyzer analyzer) throws IOException {
        this(new SingleDocLeafReader(shardId, operation, mapper, analyzer));
    }

    private SingleDocDirectoryReader(SingleDocLeafReader leafReader) throws IOException {
        super(leafReader.directory, new LeafReader[]{leafReader});
        this.leafReader = leafReader;
    }

    boolean assertMemorySegmentStatus(boolean loaded) {
        return this.leafReader.assertMemorySegmentStatus(loaded);
    }

    private static UnsupportedOperationException unsupported() {
        assert (false) : "unsupported operation";
        return new UnsupportedOperationException();
    }

    @Override
    protected DirectoryReader doOpenIfChanged() {
        throw SingleDocDirectoryReader.unsupported();
    }

    @Override
    protected DirectoryReader doOpenIfChanged(IndexCommit commit) {
        throw SingleDocDirectoryReader.unsupported();
    }

    @Override
    protected DirectoryReader doOpenIfChanged(IndexWriter writer, boolean applyAllDeletes) {
        throw SingleDocDirectoryReader.unsupported();
    }

    @Override
    public long getVersion() {
        throw SingleDocDirectoryReader.unsupported();
    }

    @Override
    public boolean isCurrent() {
        throw SingleDocDirectoryReader.unsupported();
    }

    @Override
    public IndexCommit getIndexCommit() {
        throw SingleDocDirectoryReader.unsupported();
    }

    @Override
    protected void doClose() throws IOException {
        this.leafReader.close();
    }

    @Override
    public IndexReader.CacheHelper getReaderCacheHelper() {
        return this.leafReader.getReaderCacheHelper();
    }

    private static class SingleDocLeafReader
    extends LeafReader {
        private final ShardId shardId;
        private final Translog.Index operation;
        private final DocumentMapper mapper;
        private final Analyzer analyzer;
        private final Directory directory;
        private final AtomicReference<LeafReader> delegate = new AtomicReference();

        SingleDocLeafReader(ShardId shardId, Translog.Index operation, DocumentMapper mapper, Analyzer analyzer) {
            this.shardId = shardId;
            this.operation = operation;
            this.mapper = mapper;
            this.analyzer = analyzer;
            this.directory = new ByteBuffersDirectory();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private LeafReader getDelegate() {
            this.ensureOpen();
            LeafReader reader = this.delegate.get();
            if (reader == null) {
                SingleDocLeafReader singleDocLeafReader = this;
                synchronized (singleDocLeafReader) {
                    reader = this.delegate.get();
                    if (reader == null) {
                        reader = this.createInMemoryLeafReader();
                        LeafReader existing = this.delegate.getAndSet(reader);
                        assert (existing == null);
                    }
                }
            }
            return reader;
        }

        private LeafReader createInMemoryLeafReader() {
            LeafReader leafReader;
            assert (Thread.holdsLock(this));
            ParsedDocument parsedDocs = this.mapper.parse(new SourceToParse(this.shardId.getIndexName(), this.operation.type(), this.operation.id(), this.operation.source(), XContentHelper.xContentType(this.operation.source()), this.operation.routing()));
            parsedDocs.updateSeqID(this.operation.seqNo(), this.operation.primaryTerm());
            parsedDocs.version().setLongValue(this.operation.version());
            IndexWriterConfig writeConfig = new IndexWriterConfig(this.analyzer).setOpenMode(IndexWriterConfig.OpenMode.CREATE);
            IndexWriter writer = new IndexWriter(this.directory, writeConfig);
            try {
                writer.addDocument(parsedDocs.rootDoc());
                DirectoryReader reader = DirectoryReader.open(writer);
                if (reader.leaves().size() != 1 || reader.leaves().get(0).reader().numDocs() != 1) {
                    reader.close();
                    throw new IllegalStateException("Expected a single document segment; but [" + reader.leaves().size() + " segments with " + reader.leaves().get(0).reader().numDocs() + " documents");
                }
                leafReader = reader.leaves().get(0).reader();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new EngineException(this.shardId, "failed to create an in-memory segment for get [" + this.operation.id() + "]", e, new Object[0]);
                }
            }
            writer.close();
            return leafReader;
        }

        @Override
        public IndexReader.CacheHelper getCoreCacheHelper() {
            return this.getDelegate().getCoreCacheHelper();
        }

        @Override
        public IndexReader.CacheHelper getReaderCacheHelper() {
            return this.getDelegate().getReaderCacheHelper();
        }

        @Override
        public Terms terms(String field) throws IOException {
            return this.getDelegate().terms(field);
        }

        @Override
        public NumericDocValues getNumericDocValues(String field) throws IOException {
            return this.getDelegate().getNumericDocValues(field);
        }

        @Override
        public BinaryDocValues getBinaryDocValues(String field) throws IOException {
            return this.getDelegate().getBinaryDocValues(field);
        }

        @Override
        public SortedDocValues getSortedDocValues(String field) throws IOException {
            return this.getDelegate().getSortedDocValues(field);
        }

        @Override
        public SortedNumericDocValues getSortedNumericDocValues(String field) throws IOException {
            return this.getDelegate().getSortedNumericDocValues(field);
        }

        @Override
        public SortedSetDocValues getSortedSetDocValues(String field) throws IOException {
            return this.getDelegate().getSortedSetDocValues(field);
        }

        @Override
        public NumericDocValues getNormValues(String field) throws IOException {
            return this.getDelegate().getNormValues(field);
        }

        @Override
        public FieldInfos getFieldInfos() {
            return this.getDelegate().getFieldInfos();
        }

        @Override
        public Bits getLiveDocs() {
            return this.getDelegate().getLiveDocs();
        }

        @Override
        public PointValues getPointValues(String field) throws IOException {
            return this.getDelegate().getPointValues(field);
        }

        @Override
        public void checkIntegrity() throws IOException {
        }

        @Override
        public LeafMetaData getMetaData() {
            return this.getDelegate().getMetaData();
        }

        @Override
        public Fields getTermVectors(int docID) throws IOException {
            return this.getDelegate().getTermVectors(docID);
        }

        @Override
        public int numDocs() {
            return 1;
        }

        @Override
        public int maxDoc() {
            return 1;
        }

        synchronized boolean assertMemorySegmentStatus(boolean loaded) {
            if (loaded) {
                assert (this.delegate.get() != null) : "Expected an in memory segment was loaded; but it wasn't. Please check the reader wrapper implementation";
            } else assert (this.delegate.get() == null) : "Expected an in memory segment wasn't loaded; but it was. Please check the reader wrapper implementation";
            return true;
        }

        @Override
        public void document(int docID, StoredFieldVisitor visitor) throws IOException {
            assert (this.assertMemorySegmentStatus(true));
            this.getDelegate().document(docID, visitor);
        }

        @Override
        protected void doClose() throws IOException {
            IOUtils.close(this.delegate.get(), this.directory);
        }
    }
}

