/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.DelegatingAnalyzerWrapper;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.CheckedFunction;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.TriFunction;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.IndexSortConfig;
import org.elasticsearch.index.analysis.IndexAnalyzers;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.cache.bitset.BitsetFilterCache;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.mapper.ObjectMapper;
import org.elasticsearch.index.mapper.ParsedDocument;
import org.elasticsearch.index.mapper.RuntimeFieldType;
import org.elasticsearch.index.mapper.SourceToParse;
import org.elasticsearch.index.mapper.TextFieldMapper;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.ParsedQuery;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.QueryShardException;
import org.elasticsearch.index.query.Rewriteable;
import org.elasticsearch.index.query.support.NestedScope;
import org.elasticsearch.index.similarity.SimilarityService;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptFactory;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.NestedDocuments;
import org.elasticsearch.search.aggregations.support.ValuesSourceRegistry;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.transport.RemoteClusterAware;

public class SearchExecutionContext
extends QueryRewriteContext {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(SearchExecutionContext.class);
    private final ScriptService scriptService;
    private final IndexSettings indexSettings;
    private final MapperService mapperService;
    private final MappingLookup mappingLookup;
    private final SimilarityService similarityService;
    private final BitsetFilterCache bitsetFilterCache;
    private final TriFunction<MappedFieldType, String, Supplier<SearchLookup>, IndexFieldData<?>> indexFieldDataService;
    private SearchLookup lookup = null;
    private final int shardId;
    private final int shardRequestIndex;
    private final IndexSearcher searcher;
    private String[] types = Strings.EMPTY_ARRAY;
    private boolean cacheable = true;
    private final SetOnce<Boolean> frozen = new SetOnce();
    private final Index fullyQualifiedIndex;
    private final Predicate<String> indexNameMatcher;
    private final BooleanSupplier allowExpensiveQueries;
    private final Map<String, Query> namedQueries = new HashMap<String, Query>();
    private boolean allowUnmappedFields;
    private boolean mapUnmappedFieldAsString;
    private NestedScope nestedScope;
    private final ValuesSourceRegistry valuesSourceRegistry;
    private final Map<String, RuntimeFieldType> runtimeMappings;

    public void setTypes(String ... types) {
        this.types = types;
    }

    public String[] getTypes() {
        return this.types;
    }

    public SearchExecutionContext(int shardId, int shardRequestIndex, IndexSettings indexSettings, BitsetFilterCache bitsetFilterCache, TriFunction<MappedFieldType, String, Supplier<SearchLookup>, IndexFieldData<?>> indexFieldDataLookup, MapperService mapperService, MappingLookup mappingLookup, SimilarityService similarityService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, NamedWriteableRegistry namedWriteableRegistry, Client client, IndexSearcher searcher, LongSupplier nowInMillis, String clusterAlias, Predicate<String> indexNameMatcher, BooleanSupplier allowExpensiveQueries, ValuesSourceRegistry valuesSourceRegistry, Map<String, Object> runtimeMappings) {
        this(shardId, shardRequestIndex, indexSettings, bitsetFilterCache, indexFieldDataLookup, mapperService, mappingLookup, similarityService, scriptService, xContentRegistry, namedWriteableRegistry, client, searcher, nowInMillis, indexNameMatcher, new Index(RemoteClusterAware.buildRemoteIndexName(clusterAlias, indexSettings.getIndex().getName()), indexSettings.getIndex().getUUID()), allowExpensiveQueries, valuesSourceRegistry, SearchExecutionContext.parseRuntimeMappings(runtimeMappings, mapperService));
    }

    public SearchExecutionContext(SearchExecutionContext source) {
        this(source.shardId, source.shardRequestIndex, source.indexSettings, source.bitsetFilterCache, source.indexFieldDataService, source.mapperService, source.mappingLookup, source.similarityService, source.scriptService, source.getXContentRegistry(), source.getWriteableRegistry(), source.client, source.searcher, source.nowInMillis, source.indexNameMatcher, source.fullyQualifiedIndex, source.allowExpensiveQueries, source.valuesSourceRegistry, source.runtimeMappings);
    }

    private SearchExecutionContext(int shardId, int shardRequestIndex, IndexSettings indexSettings, BitsetFilterCache bitsetFilterCache, TriFunction<MappedFieldType, String, Supplier<SearchLookup>, IndexFieldData<?>> indexFieldDataLookup, MapperService mapperService, MappingLookup mappingLookup, SimilarityService similarityService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, NamedWriteableRegistry namedWriteableRegistry, Client client, IndexSearcher searcher, LongSupplier nowInMillis, Predicate<String> indexNameMatcher, Index fullyQualifiedIndex, BooleanSupplier allowExpensiveQueries, ValuesSourceRegistry valuesSourceRegistry, Map<String, RuntimeFieldType> runtimeMappings) {
        super(xContentRegistry, namedWriteableRegistry, client, nowInMillis);
        this.shardId = shardId;
        this.shardRequestIndex = shardRequestIndex;
        this.similarityService = similarityService;
        this.mapperService = mapperService;
        this.mappingLookup = mappingLookup;
        this.bitsetFilterCache = bitsetFilterCache;
        this.indexFieldDataService = indexFieldDataLookup;
        this.allowUnmappedFields = indexSettings.isDefaultAllowUnmappedFields();
        this.nestedScope = new NestedScope();
        this.scriptService = scriptService;
        this.indexSettings = indexSettings;
        this.searcher = searcher;
        this.indexNameMatcher = indexNameMatcher;
        this.fullyQualifiedIndex = fullyQualifiedIndex;
        this.allowExpensiveQueries = allowExpensiveQueries;
        this.valuesSourceRegistry = valuesSourceRegistry;
        this.runtimeMappings = runtimeMappings;
    }

    private void reset() {
        this.allowUnmappedFields = this.indexSettings.isDefaultAllowUnmappedFields();
        this.lookup = null;
        this.namedQueries.clear();
        this.nestedScope = new NestedScope();
    }

    public Similarity getSearchSimilarity() {
        return this.similarityService != null ? this.similarityService.similarity(this::fieldType) : null;
    }

    public List<String> defaultFields() {
        return this.indexSettings.getDefaultFields();
    }

    public boolean queryStringLenient() {
        return this.indexSettings.isQueryStringLenient();
    }

    public boolean queryStringAnalyzeWildcard() {
        return this.indexSettings.isQueryStringAnalyzeWildcard();
    }

    public boolean queryStringAllowLeadingWildcard() {
        return this.indexSettings.isQueryStringAllowLeadingWildcard();
    }

    public BitSetProducer bitsetFilter(Query filter) {
        return this.bitsetFilterCache.getBitSetProducer(filter);
    }

    public boolean allowExpensiveQueries() {
        return this.allowExpensiveQueries.getAsBoolean();
    }

    public <IFD extends IndexFieldData<?>> IFD getForField(MappedFieldType fieldType) {
        return (IFD)this.indexFieldDataService.apply(fieldType, this.fullyQualifiedIndex.getName(), () -> this.lookup().forkAndTrackFieldReferences(fieldType.name()));
    }

    public void addNamedQuery(String name, Query query) {
        if (query != null) {
            this.namedQueries.put(name, query);
        }
    }

    public Map<String, Query> copyNamedQueries() {
        return Collections.unmodifiableMap(new HashMap<String, Query>(this.namedQueries));
    }

    public ParsedDocument parseDocument(SourceToParse source) throws MapperParsingException {
        return this.mappingLookup.parseDocument(source);
    }

    public boolean hasNested() {
        return this.mappingLookup.hasNested();
    }

    public boolean hasMappings() {
        return this.mappingLookup.hasMappings();
    }

    public List<ObjectMapper> nestedMappings() {
        return this.mappingLookup.getNestedMappers();
    }

    public Set<String> simpleMatchToIndexNames(String pattern) {
        if (this.runtimeMappings.isEmpty()) {
            return this.mappingLookup.simpleMatchToFullName(pattern);
        }
        if (!Regex.isSimpleMatchPattern(pattern)) {
            return Collections.singleton(pattern);
        }
        HashSet<String> matches = new HashSet<String>(this.mappingLookup.simpleMatchToFullName(pattern));
        for (String name : this.runtimeMappings.keySet()) {
            if (!Regex.simpleMatch(pattern, name)) continue;
            matches.add(name);
        }
        return matches;
    }

    public MappedFieldType getFieldType(String name) {
        return this.failIfFieldMappingNotFound(name, this.fieldType(name));
    }

    public Collection<MappedFieldType> getFieldTypes() {
        ArrayList<MappedFieldType> fields = new ArrayList<MappedFieldType>(this.mappingLookup.fieldTypes());
        fields.addAll(this.runtimeMappings.values());
        return fields;
    }

    public boolean isFieldMapped(String name) {
        return this.fieldType(name) != null;
    }

    private MappedFieldType fieldType(String name) {
        MappedFieldType fieldType = this.runtimeMappings.get(name);
        return fieldType == null ? this.mappingLookup.getFieldType(name) : fieldType;
    }

    public ObjectMapper getObjectMapper(String name) {
        return this.mappingLookup.objectMappers().get(name);
    }

    public boolean isMetadataField(String field) {
        return this.mapperService.isMetadataField(field);
    }

    public Set<String> sourcePath(String fullName) {
        return this.mappingLookup.sourcePaths(fullName);
    }

    public boolean isSourceEnabled() {
        return this.mappingLookup.isSourceEnabled();
    }

    public DocumentMapper documentMapper(String type) {
        return this.mapperService.documentMapper(type);
    }

    public MappedFieldType buildAnonymousFieldType(String type) {
        Mapper.TypeParser.ParserContext parserContext;
        Mapper.TypeParser typeParser;
        if (type.equals("string")) {
            deprecationLogger.deprecate(DeprecationCategory.MAPPINGS, "unmapped_type_string", "[unmapped_type:string] should be replaced with [unmapped_type:keyword]", new Object[0]);
            type = "keyword";
        }
        if ((typeParser = (parserContext = this.mapperService.parserContext()).typeParser(type)) == null) {
            throw new IllegalArgumentException("No mapper found for type [" + type + "]");
        }
        Mapper.Builder builder = typeParser.parse("__anonymous_", Collections.emptyMap(), parserContext);
        Mapper mapper = builder.build(new ContentPath(0));
        if (mapper instanceof FieldMapper) {
            return ((FieldMapper)mapper).fieldType();
        }
        throw new IllegalArgumentException("Mapper for type [" + type + "] must be a leaf field");
    }

    public IndexAnalyzers getIndexAnalyzers() {
        return this.mapperService.getIndexAnalyzers();
    }

    public Analyzer getIndexAnalyzer(final Function<String, NamedAnalyzer> unindexedFieldAnalyzer) {
        return new DelegatingAnalyzerWrapper(Analyzer.PER_FIELD_REUSE_STRATEGY){

            @Override
            protected Analyzer getWrappedAnalyzer(String fieldName) {
                return SearchExecutionContext.this.mappingLookup.indexAnalyzer(fieldName, unindexedFieldAnalyzer);
            }
        };
    }

    public ValuesSourceRegistry getValuesSourceRegistry() {
        return this.valuesSourceRegistry;
    }

    public void setAllowUnmappedFields(boolean allowUnmappedFields) {
        this.allowUnmappedFields = allowUnmappedFields;
    }

    public void setMapUnmappedFieldAsString(boolean mapUnmappedFieldAsString) {
        this.mapUnmappedFieldAsString = mapUnmappedFieldAsString;
    }

    MappedFieldType failIfFieldMappingNotFound(String name, MappedFieldType fieldMapping) {
        if (fieldMapping != null || this.allowUnmappedFields) {
            return fieldMapping;
        }
        if (this.mapUnmappedFieldAsString) {
            TextFieldMapper.Builder builder = new TextFieldMapper.Builder(name, this.getIndexAnalyzers());
            return builder.build(new ContentPath(1)).fieldType();
        }
        throw new QueryShardException(this, "No field mapping can be found for the field with name [{}]", name);
    }

    public Collection<String> queryTypes() {
        String[] types = this.getTypes();
        if (types == null || types.length == 0 || types.length == 1 && types[0].equals("_all")) {
            DocumentMapper mapper = this.mapperService.documentMapper();
            return mapper == null ? Collections.emptyList() : Collections.singleton(mapper.type());
        }
        return Arrays.asList(types);
    }

    public boolean containsBrokenAnalysis(String field) {
        NamedAnalyzer a = this.mappingLookup.indexAnalyzer(field, f -> null);
        return a == null ? false : a.containsBrokenAnalysis();
    }

    public SearchLookup lookup() {
        if (this.lookup == null) {
            this.lookup = new SearchLookup(this::getFieldType, (fieldType, searchLookup) -> this.indexFieldDataService.apply((MappedFieldType)fieldType, this.fullyQualifiedIndex.getName(), (Supplier<SearchLookup>)searchLookup));
        }
        return this.lookup;
    }

    public NestedScope nestedScope() {
        return this.nestedScope;
    }

    public Version indexVersionCreated() {
        return this.indexSettings.getIndexVersionCreated();
    }

    public boolean indexMatches(String pattern) {
        return this.indexNameMatcher.test(pattern);
    }

    public boolean indexSortedOnField(String field) {
        IndexSortConfig indexSortConfig = this.indexSettings.getIndexSortConfig();
        return indexSortConfig.hasPrimarySortOnField(field);
    }

    public ParsedQuery toQuery(QueryBuilder queryBuilder) {
        return this.toQuery(queryBuilder, q -> {
            Query query = q.toQuery(this);
            if (query == null) {
                query = Queries.newMatchNoDocsQuery("No query left after rewrite.");
            }
            return query;
        });
    }

    private ParsedQuery toQuery(QueryBuilder queryBuilder, CheckedFunction<QueryBuilder, Query, IOException> filterOrQuery) {
        this.reset();
        try {
            QueryBuilder rewriteQuery = Rewriteable.rewrite(queryBuilder, this, true);
            ParsedQuery parsedQuery = new ParsedQuery(filterOrQuery.apply(rewriteQuery), this.copyNamedQueries());
            return parsedQuery;
        }
        catch (ParsingException | QueryShardException e) {
            throw e;
        }
        catch (Exception e) {
            throw new QueryShardException(this, "failed to create query: {}", (Throwable)e, e.getMessage());
        }
        finally {
            this.reset();
        }
    }

    public Index index() {
        return this.indexSettings.getIndex();
    }

    public <FactoryType> FactoryType compile(Script script, ScriptContext<FactoryType> context) {
        FactoryType factory = this.scriptService.compile(script, context);
        if (factory instanceof ScriptFactory && !((ScriptFactory)factory).isResultDeterministic()) {
            this.failIfFrozen();
        }
        return factory;
    }

    public final void freezeContext() {
        this.frozen.set(Boolean.TRUE);
    }

    protected final void failIfFrozen() {
        this.cacheable = false;
        if (this.frozen.get() == Boolean.TRUE) {
            throw new IllegalArgumentException("features that prevent cachability are disabled on this context");
        }
        assert (this.frozen.get() == null) : this.frozen.get();
    }

    @Override
    public void registerAsyncAction(BiConsumer<Client, ActionListener<?>> asyncAction) {
        this.failIfFrozen();
        super.registerAsyncAction(asyncAction);
    }

    @Override
    public void executeAsyncActions(ActionListener listener) {
        this.failIfFrozen();
        super.executeAsyncActions(listener);
    }

    public final boolean isCacheable() {
        return this.cacheable;
    }

    public int getShardId() {
        return this.shardId;
    }

    public int getShardRequestIndex() {
        return this.shardRequestIndex;
    }

    @Override
    public final long nowInMillis() {
        this.failIfFrozen();
        return super.nowInMillis();
    }

    public Client getClient() {
        this.failIfFrozen();
        return this.client;
    }

    public QueryBuilder parseInnerQueryBuilder(XContentParser parser) throws IOException {
        return AbstractQueryBuilder.parseInnerQueryBuilder(parser);
    }

    @Override
    public final SearchExecutionContext convertToSearchExecutionContext() {
        return this;
    }

    public IndexSettings getIndexSettings() {
        return this.indexSettings;
    }

    public String getType() {
        return this.mappingLookup.getType();
    }

    public IndexReader getIndexReader() {
        return this.searcher == null ? null : this.searcher.getIndexReader();
    }

    public IndexSearcher searcher() {
        return this.searcher;
    }

    public Index getFullyQualifiedIndex() {
        return this.fullyQualifiedIndex;
    }

    private static Map<String, RuntimeFieldType> parseRuntimeMappings(Map<String, Object> runtimeMappings, MapperService mapperService) {
        if (runtimeMappings.isEmpty()) {
            return Collections.emptyMap();
        }
        return RuntimeFieldType.parseRuntimeFields(new HashMap<String, Object>(runtimeMappings), mapperService.parserContext(), false);
    }

    public MappingLookup.CacheKey mappingCacheKey() {
        return this.mappingLookup.cacheKey();
    }

    public String getNestedParent(String nestedPath) {
        return this.mappingLookup.getNestedParent(nestedPath);
    }

    public NestedDocuments getNestedDocuments() {
        return new NestedDocuments(this.mappingLookup, this.indexVersionCreated(), this.bitsetFilterCache::getBitSetProducer);
    }
}

