/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.hash;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;

public class SourceLineHashesComputer {
    private final MessageDigest md5Digest = DigestUtils.getMd5Digest();
    private final List<String> lineHashes;

    public SourceLineHashesComputer() {
        this.lineHashes = new ArrayList<String>();
    }

    public SourceLineHashesComputer(int expectedLineCount) {
        this.lineHashes = new ArrayList<String>(expectedLineCount);
    }

    public void addLine(String line) {
        Objects.requireNonNull(line, "line can not be null");
        this.lineHashes.add(this.computeHash(line));
    }

    public List<String> getLineHashes() {
        return Collections.unmodifiableList(this.lineHashes);
    }

    private String computeHash(String line) {
        String reducedLine = StringUtils.replaceChars(line, "\t ", "");
        if (reducedLine.isEmpty()) {
            return "";
        }
        return Hex.encodeHexString(this.md5Digest.digest(reducedLine.getBytes(StandardCharsets.UTF_8)));
    }
}

