/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.issue;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.sonar.api.issue.Issue;
import org.sonar.api.issue.IssueComment;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rule.Severity;
import org.sonar.api.rules.RuleType;
import org.sonar.api.utils.DateUtils;
import org.sonar.api.utils.Duration;
import org.sonar.core.issue.DefaultIssueComment;
import org.sonar.core.issue.FieldDiffs;
import org.sonar.core.issue.IssueChangeContext;
import org.sonar.core.issue.tracking.Trackable;

public class DefaultIssue
implements Issue,
Trackable,
org.sonar.api.ce.measure.Issue {
    private String key;
    private RuleType type;
    private String componentUuid;
    private String componentKey;
    private String moduleUuid;
    private String moduleUuidPath;
    private String projectUuid;
    private String projectKey;
    private RuleKey ruleKey;
    private String language;
    private String severity;
    private boolean manualSeverity = false;
    private String message;
    private Integer line;
    private Double gap;
    private Duration effort;
    private String status;
    private String resolution;
    private String assigneeUuid;
    private String checksum;
    private Map<String, String> attributes = null;
    private String authorLogin = null;
    private List<DefaultIssueComment> comments = null;
    private Set<String> tags = null;
    private Object locations = null;
    private boolean isFromExternalRuleEngine;
    private Date creationDate;
    private Date updateDate;
    private Date closeDate;
    private FieldDiffs currentChange = null;
    private List<FieldDiffs> changes = null;
    private boolean isNew = true;
    private boolean isCopied = false;
    private boolean beingClosed = false;
    private boolean onDisabledRule = false;
    private boolean isChanged = false;
    private boolean sendNotifications = false;
    private Long selectedAt;

    @Override
    public String key() {
        return this.key;
    }

    public DefaultIssue setKey(String key) {
        this.key = key;
        return this;
    }

    @Override
    public RuleType type() {
        return this.type;
    }

    public DefaultIssue setType(RuleType type) {
        this.type = type;
        return this;
    }

    @Override
    @CheckForNull
    public String componentUuid() {
        return this.componentUuid;
    }

    public DefaultIssue setComponentUuid(@Nullable String s) {
        this.componentUuid = s;
        return this;
    }

    @Override
    public String componentKey() {
        return this.componentKey;
    }

    public DefaultIssue setComponentKey(String s) {
        this.componentKey = s;
        return this;
    }

    @CheckForNull
    public String moduleUuid() {
        return this.moduleUuid;
    }

    public DefaultIssue setModuleUuid(@Nullable String moduleUuid) {
        this.moduleUuid = moduleUuid;
        return this;
    }

    @CheckForNull
    public String moduleUuidPath() {
        return this.moduleUuidPath;
    }

    public DefaultIssue setModuleUuidPath(@Nullable String moduleUuidPath) {
        this.moduleUuidPath = moduleUuidPath;
        return this;
    }

    @Override
    public String projectUuid() {
        return this.projectUuid;
    }

    public DefaultIssue setProjectUuid(String s) {
        this.projectUuid = s;
        return this;
    }

    @Override
    public String projectKey() {
        return this.projectKey;
    }

    public DefaultIssue setProjectKey(String projectKey) {
        this.projectKey = projectKey;
        return this;
    }

    @Override
    public RuleKey ruleKey() {
        return this.ruleKey;
    }

    public DefaultIssue setRuleKey(RuleKey k) {
        this.ruleKey = k;
        return this;
    }

    @Override
    @CheckForNull
    public String language() {
        return this.language;
    }

    public DefaultIssue setLanguage(@Nullable String l) {
        this.language = l;
        return this;
    }

    @Override
    public String severity() {
        return this.severity;
    }

    public DefaultIssue setSeverity(@Nullable String s) {
        Preconditions.checkArgument(s == null || Severity.ALL.contains(s), "Not a valid severity: " + s);
        this.severity = s;
        return this;
    }

    public boolean manualSeverity() {
        return this.manualSeverity;
    }

    public DefaultIssue setManualSeverity(boolean b) {
        this.manualSeverity = b;
        return this;
    }

    public boolean isFromExternalRuleEngine() {
        return this.isFromExternalRuleEngine;
    }

    public DefaultIssue setIsFromExternalRuleEngine(boolean isFromExternalRuleEngine) {
        this.isFromExternalRuleEngine = isFromExternalRuleEngine;
        return this;
    }

    @Override
    @CheckForNull
    public String message() {
        return this.message;
    }

    public DefaultIssue setMessage(@Nullable String s) {
        this.message = StringUtils.abbreviate(StringUtils.trim(s), 1333);
        return this;
    }

    @Override
    @CheckForNull
    public Integer line() {
        return this.line;
    }

    public DefaultIssue setLine(@Nullable Integer l) {
        Preconditions.checkArgument(l == null || l > 0, "Line must be null or greater than zero (got %s)", (Object)l);
        this.line = l;
        return this;
    }

    @Override
    @CheckForNull
    public Double gap() {
        return this.gap;
    }

    public DefaultIssue setGap(@Nullable Double d) {
        Preconditions.checkArgument(d == null || d >= 0.0, "Gap must be greater than or equal 0 (got %s)", (Object)d);
        this.gap = d;
        return this;
    }

    @Override
    @CheckForNull
    public Duration effort() {
        return this.effort;
    }

    @CheckForNull
    public Long effortInMinutes() {
        return this.effort != null ? Long.valueOf(this.effort.toMinutes()) : null;
    }

    public DefaultIssue setEffort(@Nullable Duration t) {
        this.effort = t;
        return this;
    }

    @Override
    public String status() {
        return this.status;
    }

    public DefaultIssue setStatus(String s) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(s), "Status must be set");
        this.status = s;
        return this;
    }

    @Override
    @CheckForNull
    public String resolution() {
        return this.resolution;
    }

    public DefaultIssue setResolution(@Nullable String s) {
        this.resolution = s;
        return this;
    }

    @Override
    @CheckForNull
    public String assignee() {
        return this.assigneeUuid;
    }

    public DefaultIssue setAssigneeUuid(@Nullable String s) {
        this.assigneeUuid = s;
        return this;
    }

    @Override
    public Date creationDate() {
        return this.creationDate;
    }

    public DefaultIssue setCreationDate(Date d) {
        this.creationDate = DateUtils.truncateToSeconds(d);
        return this;
    }

    @Override
    @CheckForNull
    public Date updateDate() {
        return this.updateDate;
    }

    public DefaultIssue setUpdateDate(@Nullable Date d) {
        this.updateDate = DateUtils.truncateToSeconds(d);
        return this;
    }

    @Override
    @CheckForNull
    public Date closeDate() {
        return this.closeDate;
    }

    public DefaultIssue setCloseDate(@Nullable Date d) {
        this.closeDate = DateUtils.truncateToSeconds(d);
        return this;
    }

    @CheckForNull
    public String checksum() {
        return this.checksum;
    }

    public DefaultIssue setChecksum(@Nullable String s) {
        this.checksum = s;
        return this;
    }

    @Override
    public boolean isNew() {
        return this.isNew;
    }

    @Override
    public boolean isCopied() {
        return this.isCopied;
    }

    public DefaultIssue setCopied(boolean b) {
        this.isCopied = b;
        return this;
    }

    public DefaultIssue setNew(boolean b) {
        this.isNew = b;
        return this;
    }

    public boolean isBeingClosed() {
        return this.beingClosed;
    }

    public DefaultIssue setBeingClosed(boolean b) {
        this.beingClosed = b;
        return this;
    }

    public boolean isOnDisabledRule() {
        return this.onDisabledRule;
    }

    public DefaultIssue setOnDisabledRule(boolean b) {
        this.onDisabledRule = b;
        return this;
    }

    public boolean isChanged() {
        return this.isChanged;
    }

    public DefaultIssue setChanged(boolean b) {
        this.isChanged = b;
        return this;
    }

    public boolean mustSendNotifications() {
        return this.sendNotifications;
    }

    public DefaultIssue setSendNotifications(boolean b) {
        this.sendNotifications = b;
        return this;
    }

    @Override
    @CheckForNull
    public String attribute(String key) {
        return this.attributes == null ? null : this.attributes.get(key);
    }

    public DefaultIssue setAttribute(String key, @Nullable String value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, String>();
        }
        if (value == null) {
            this.attributes.remove(key);
        } else {
            this.attributes.put(key, value);
        }
        return this;
    }

    @Override
    public Map<String, String> attributes() {
        return this.attributes == null ? Collections.emptyMap() : ImmutableMap.copyOf(this.attributes);
    }

    public DefaultIssue setAttributes(@Nullable Map<String, String> map) {
        if (map != null) {
            if (this.attributes == null) {
                this.attributes = new HashMap<String, String>();
            }
            this.attributes.putAll(map);
        }
        return this;
    }

    @Override
    @CheckForNull
    public String authorLogin() {
        return this.authorLogin;
    }

    public DefaultIssue setAuthorLogin(@Nullable String s) {
        this.authorLogin = s;
        return this;
    }

    public DefaultIssue setFieldChange(IssueChangeContext context, String field, @Nullable Serializable oldValue, @Nullable Serializable newValue) {
        if (!Objects.equals(oldValue, newValue)) {
            if (this.currentChange == null) {
                this.currentChange = new FieldDiffs();
                this.currentChange.setUserUuid(context.userUuid());
                this.currentChange.setCreationDate(context.date());
            }
            this.currentChange.setDiff(field, oldValue, newValue);
        }
        this.addChange(this.currentChange);
        return this;
    }

    public DefaultIssue setCurrentChange(FieldDiffs currentChange) {
        this.currentChange = currentChange;
        this.addChange(currentChange);
        return this;
    }

    public DefaultIssue setCurrentChangeWithoutAddChange(@Nullable FieldDiffs currentChange) {
        this.currentChange = currentChange;
        return this;
    }

    @CheckForNull
    public FieldDiffs currentChange() {
        return this.currentChange;
    }

    public DefaultIssue addChange(@Nullable FieldDiffs change) {
        if (change == null) {
            return this;
        }
        if (this.changes == null) {
            this.changes = new ArrayList<FieldDiffs>();
        }
        this.changes.add(change);
        return this;
    }

    public List<FieldDiffs> changes() {
        if (this.changes == null) {
            return Collections.emptyList();
        }
        return ImmutableList.copyOf(this.changes);
    }

    public DefaultIssue addComment(DefaultIssueComment comment) {
        if (this.comments == null) {
            this.comments = new ArrayList<DefaultIssueComment>();
        }
        this.comments.add(comment);
        return this;
    }

    @Override
    @Deprecated
    public List<IssueComment> comments() {
        return Collections.emptyList();
    }

    public List<DefaultIssueComment> defaultIssueComments() {
        if (this.comments == null) {
            return Collections.emptyList();
        }
        return ImmutableList.copyOf(this.comments);
    }

    @CheckForNull
    public Long selectedAt() {
        return this.selectedAt;
    }

    public DefaultIssue setSelectedAt(@Nullable Long d) {
        this.selectedAt = d;
        return this;
    }

    @CheckForNull
    public <T> T getLocations() {
        return (T)this.locations;
    }

    public DefaultIssue setLocations(@Nullable Object locations) {
        this.locations = locations;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultIssue that = (DefaultIssue)o;
        return Objects.equals(this.key, that.key);
    }

    public int hashCode() {
        return this.key != null ? this.key.hashCode() : 0;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public Set<String> tags() {
        if (this.tags == null) {
            return ImmutableSet.of();
        }
        return ImmutableSet.copyOf(this.tags);
    }

    public DefaultIssue setTags(Collection<String> tags) {
        this.tags = new LinkedHashSet<String>(tags);
        return this;
    }

    @Override
    public Integer getLine() {
        return this.line;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public String getLineHash() {
        return this.checksum;
    }

    @Override
    public RuleKey getRuleKey() {
        return this.ruleKey;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public Date getUpdateDate() {
        return this.updateDate;
    }
}

