/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.platform;

import java.io.Closeable;
import java.io.Serializable;
import java.util.Arrays;
import java.util.stream.Stream;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.LifecycleStrategy;
import org.sonar.api.Startable;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;

public class StartableCloseableSafeLifecyleStrategy
implements LifecycleStrategy,
Serializable {
    private static final Class<?>[] TYPES_WITH_LIFECYCLE = new Class[]{org.picocontainer.Startable.class, Startable.class, Closeable.class, AutoCloseable.class};
    private static final Logger LOG = Loggers.get(StartableCloseableSafeLifecyleStrategy.class);

    @Override
    public void start(Object component) {
        if (component instanceof org.picocontainer.Startable) {
            ((org.picocontainer.Startable)component).start();
        } else if (component instanceof Startable) {
            ((Startable)component).start();
        }
    }

    @Override
    public void stop(Object component) {
        try {
            if (component instanceof org.picocontainer.Startable) {
                ((org.picocontainer.Startable)component).stop();
            } else if (component instanceof Startable) {
                ((Startable)component).stop();
            }
        }
        catch (Error | RuntimeException e) {
            Loggers.get(StartableCloseableSafeLifecyleStrategy.class).warn("Stopping of component {} failed", (Object)component.getClass().getCanonicalName(), (Object)e);
        }
    }

    @Override
    public void dispose(Object component) {
        try {
            if (component instanceof Closeable) {
                ((Closeable)component).close();
            } else if (component instanceof AutoCloseable) {
                ((AutoCloseable)component).close();
            }
        }
        catch (Exception e) {
            Loggers.get(StartableCloseableSafeLifecyleStrategy.class).warn("Dispose of component {} failed", (Object)component.getClass().getCanonicalName(), (Object)e);
        }
    }

    @Override
    public boolean hasLifecycle(Class<?> type) {
        if (Arrays.stream(TYPES_WITH_LIFECYCLE).anyMatch(t1 -> t1.isAssignableFrom(type))) {
            return true;
        }
        if (Stream.of("start", "stop").anyMatch(t -> StartableCloseableSafeLifecyleStrategy.hasMethod(type, t))) {
            LOG.warn("Component of type {} defines methods start() and/or stop(). Neither will be invoked to start/stop the component. Please implement either {} or {}", type, org.picocontainer.Startable.class.getName(), Startable.class.getName());
        }
        if (StartableCloseableSafeLifecyleStrategy.hasMethod(type, "close")) {
            LOG.warn("Component of type {} defines method close(). It won't be invoked to dispose the component. Please implement either {} or {}", type, Closeable.class.getName(), AutoCloseable.class.getName());
        }
        return false;
    }

    private static boolean hasMethod(Class<?> type, String methodName) {
        try {
            return type.getMethod(methodName, new Class[0]) != null;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    @Override
    public boolean isLazy(ComponentAdapter<?> adapter) {
        return false;
    }
}

