/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.analysis;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.picocontainer.ComponentLifecycle;
import org.picocontainer.PicoContainer;
import org.picocontainer.injectors.ProviderAdapter;
import org.sonar.api.batch.fs.internal.DefaultInputProject;
import org.sonar.api.impl.utils.DefaultTempFolder;
import org.sonar.api.utils.TempFolder;

public class AnalysisTempFolderProvider
extends ProviderAdapter
implements ComponentLifecycle<TempFolder> {
    static final String TMP_NAME = ".sonartmp";
    private DefaultTempFolder projectTempFolder;
    private boolean started = false;

    public TempFolder provide(DefaultInputProject project) {
        if (this.projectTempFolder == null) {
            Path workingDir = project.getWorkDir();
            Path tempDir = workingDir.normalize().resolve(TMP_NAME);
            try {
                Files.deleteIfExists(tempDir);
                Files.createDirectories(tempDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to create root temp directory " + tempDir, e);
            }
            this.projectTempFolder = new DefaultTempFolder(tempDir.toFile(), true);
        }
        return this.projectTempFolder;
    }

    @Override
    public void start(PicoContainer container) {
        this.started = true;
    }

    @Override
    public void stop(PicoContainer container) {
        if (this.projectTempFolder != null) {
            this.projectTempFolder.stop();
        }
    }

    @Override
    public void dispose(PicoContainer container) {
    }

    @Override
    public boolean componentHasLifecycle() {
        return true;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }
}

