/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scm;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.DefaultInputFile;
import org.sonar.api.batch.scm.BlameCommand;
import org.sonar.api.batch.scm.BlameLine;
import org.sonar.api.notifications.AnalysisWarnings;
import org.sonar.api.utils.Preconditions;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.scanner.protocol.output.ScannerReport;
import org.sonar.scanner.protocol.output.ScannerReportWriter;
import org.sonar.scanner.util.ProgressReport;

class DefaultBlameOutput
implements BlameCommand.BlameOutput {
    private static final Logger LOG = Loggers.get(DefaultBlameOutput.class);
    private final ScannerReportWriter writer;
    private AnalysisWarnings analysisWarnings;
    private final Set<InputFile> allFilesToBlame = new LinkedHashSet<InputFile>();
    private ProgressReport progressReport;
    private int count;
    private int total;

    DefaultBlameOutput(ScannerReportWriter writer, AnalysisWarnings analysisWarnings, List<InputFile> filesToBlame) {
        this.writer = writer;
        this.analysisWarnings = analysisWarnings;
        this.allFilesToBlame.addAll(filesToBlame);
        this.count = 0;
        this.total = filesToBlame.size();
        this.progressReport = new ProgressReport("Report about progress of SCM blame", TimeUnit.SECONDS.toMillis(10L));
        this.progressReport.start("SCM Publisher " + this.total + " " + DefaultBlameOutput.pluralize(this.total) + " to be analyzed");
    }

    @Override
    public synchronized void blameResult(InputFile file, List<BlameLine> lines) {
        DefaultBlameOutput.checkNotNull(file);
        DefaultBlameOutput.checkNotNull(lines);
        Preconditions.checkArgument(this.allFilesToBlame.contains(file), "It was not expected to blame file %s", file);
        if (lines.size() != file.lines()) {
            LOG.debug("Ignoring blame result since provider returned {} blame lines but file {} has {} lines", lines.size(), file, file.lines());
            return;
        }
        ScannerReport.Changesets.Builder scmBuilder = ScannerReport.Changesets.newBuilder();
        DefaultInputFile inputFile = (DefaultInputFile)file;
        scmBuilder.setComponentRef(inputFile.scannerId());
        HashMap<String, Integer> changesetsIdByRevision = new HashMap<String, Integer>();
        int lineId = 1;
        for (BlameLine line : lines) {
            DefaultBlameOutput.validateLine(line, lineId, file);
            Integer changesetId = (Integer)changesetsIdByRevision.get(line.revision());
            if (changesetId == null) {
                DefaultBlameOutput.addChangeset(scmBuilder, line);
                changesetId = scmBuilder.getChangesetCount() - 1;
                changesetsIdByRevision.put(line.revision(), changesetId);
            }
            scmBuilder.addChangesetIndexByLine(changesetId);
            ++lineId;
        }
        this.writer.writeComponentChangesets(scmBuilder.build());
        this.allFilesToBlame.remove(file);
        ++this.count;
        this.progressReport.message(this.count + "/" + this.total + " " + DefaultBlameOutput.pluralize(this.count) + " have been analyzed");
    }

    private static void validateLine(BlameLine line, int lineId, InputFile file) {
        Preconditions.checkArgument(StringUtils.isNotBlank(line.revision()), "Blame revision is blank for file %s at line %s", file, lineId);
        Preconditions.checkArgument(line.date() != null, "Blame date is null for file %s at line %s", file, lineId);
    }

    private static void addChangeset(ScannerReport.Changesets.Builder scmBuilder, BlameLine line) {
        ScannerReport.Changesets.Changeset.Builder changesetBuilder = ScannerReport.Changesets.Changeset.newBuilder();
        changesetBuilder.setRevision(line.revision());
        changesetBuilder.setDate(line.date().getTime());
        if (StringUtils.isNotBlank(line.author())) {
            changesetBuilder.setAuthor(DefaultBlameOutput.normalizeString(line.author()));
        }
        scmBuilder.addChangeset(changesetBuilder.build());
    }

    private static String normalizeString(@Nullable String inputString) {
        if (inputString == null) {
            return "";
        }
        return inputString.toLowerCase(Locale.US);
    }

    private static void checkNotNull(@Nullable Object obj) {
        if (obj == null) {
            throw new NullPointerException();
        }
    }

    public void finish(boolean success) {
        this.progressReport.stopAndLogTotalTime("SCM Publisher " + this.count + "/" + this.total + " " + DefaultBlameOutput.pluralize(this.count) + " have been analyzed");
        if (success && !this.allFilesToBlame.isEmpty()) {
            LOG.warn("Missing blame information for the following files:");
            for (InputFile f : this.allFilesToBlame) {
                LOG.warn("  * " + f);
            }
            LOG.warn("This may lead to missing/broken features in SonarQube");
            this.analysisWarnings.addUnique(String.format("Missing blame information for %d %s. This may lead to some features not working correctly. Please check the analysis logs and refer to <a href=\"/documentation/analysis/scm-integration/\" target=\"_blank\">the documentation</a>.", this.allFilesToBlame.size(), this.allFilesToBlame.size() > 1 ? "files" : "file"));
        }
    }

    private static String pluralize(long filesCount) {
        return filesCount == 1L ? "source file" : "source files";
    }
}

